/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.index;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunEntry;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.jetbrains.annotations.VisibleForTesting;

public class GitHubCheckRunInfo {
    @JsonProperty(value="revision")
    private final @NonNull String revision;
    @JsonProperty(value="commit")
    private final @NonNull CommitDescriptor commit;
    @JsonProperty(value="checkRunId")
    private final long checkRunId;
    @JsonProperty(value="checkRunType")
    private final @NonNull ECheckRunType checkRunType;
    @JsonProperty(value="repositoryIdentifier")
    private final @NonNull PlatformRepositoryIdentifier repositoryIdentifier;

    public GitHubCheckRunInfo(String revision, PlatformRepositoryIdentifier repositoryIdentifier, GitHubCheckRunEntry checkRunEntry) {
        this(revision, checkRunEntry.getCommit(), checkRunEntry.getCheckRunId(), checkRunEntry.getCheckRunType(), repositoryIdentifier);
    }

    @VisibleForTesting
    GitHubCheckRunInfo(@NonNull String revision, @NonNull CommitDescriptor commit, long checkRunId, @NonNull ECheckRunType checkRunType, @NonNull PlatformRepositoryIdentifier repositoryIdentifier) {
        this.revision = revision;
        this.commit = commit;
        this.checkRunId = checkRunId;
        this.checkRunType = checkRunType;
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public @NonNull String getRevision() {
        return this.revision;
    }

    public @NonNull CommitDescriptor getCommit() {
        return this.commit;
    }

    public long getCheckRunId() {
        return this.checkRunId;
    }

    public @NonNull ECheckRunType getCheckRunType() {
        return this.checkRunType;
    }

    public @NonNull PlatformRepositoryIdentifier getRepositoryIdentifier() {
        return this.repositoryIdentifier;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitHubCheckRunInfo)) {
            return false;
        }
        GitHubCheckRunInfo that = (GitHubCheckRunInfo)o;
        return this.revision.equals(that.revision) && this.checkRunId == that.checkRunId && this.checkRunType == that.checkRunType && this.repositoryIdentifier.equals(that.repositoryIdentifier) && this.commit.equals((Object)that.commit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.revision, this.checkRunId, this.checkRunType, this.repositoryIdentifier, this.commit});
    }
}

