/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;

public class ScmManagerPullRequestComments {

    public record CommentAuthor(@JsonProperty(value="id") String id) {
    }

    private record CommentLocation(@JsonProperty(value="file") String file, @JsonProperty(value="hunk") String hunk, @JsonProperty(value="newLineNumber") Integer newLineNumber, @JsonProperty(value="oldLineNumber") Integer oldLineNumber) {
    }

    public static class PullRequestComment {
        @JsonProperty(value="comment")
        private String comment;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="date")
        private String date;
        @JsonProperty(value="author")
        private CommentAuthor author;
        @JsonProperty(value="location")
        private CommentLocation location;
        @JsonProperty(value="_embedded")
        private EmbeddedPullRequestComments commentReplies;

        public PullRequestComment() {
        }

        public PullRequestComment(String text, String file, String hunk, Integer newLineNumber, Integer oldLineNumber) {
            this.comment = text;
            this.type = "COMMENT";
            this.location = new CommentLocation(file, hunk, newLineNumber, oldLineNumber);
        }

        public PullRequestComment(String text) {
            this.comment = text;
            this.type = "COMMENT";
        }

        public CommentAuthor getAuthor() {
            return this.author;
        }

        public String getId() {
            return this.id;
        }

        public String getDate() {
            return this.date;
        }

        public String getComment() {
            return this.comment;
        }

        public EmbeddedPullRequestComments getEmbeddedPullRequestComments() {
            return this.commentReplies;
        }
    }

    public static class EmbeddedPullRequestComments {
        @JsonProperty(value="pullRequestComments")
        private PullRequestComment[] comments;
        @JsonProperty(value="replies")
        private List<PullRequestComment> replies;

        public List<PullRequestComment> getReplies() {
            return this.replies;
        }
    }

    public static class PullRequestComments {
        @JsonProperty(value="_embedded")
        private EmbeddedPullRequestComments embeddedPullRequestComments;

        public List<PullRequestComment> getComments() {
            return Arrays.asList(this.embeddedPullRequestComments.comments);
        }
    }
}

