/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ProjectConnectorStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONNECTOR_IDENTIFIER_PROPERTY = "connectorIdentifier";
    private static final String STATUS_PROPERTY = "status";
    private static final String LAST_SUCCESS_PROPERTY = "lastSuccess";
    private static final String LAST_ATTEMPT_PROPERTY = "lastAttempt";
    private static final String ERROR_MESSAGE_PROPERTY = "errorMessage";
    @JsonProperty(value="connectorIdentifier")
    private final String connectorIdentifier;
    @JsonProperty(value="status")
    private final EConnectorStatus status;
    @JsonProperty(value="lastSuccess")
    private final @Nullable Long lastSuccess;
    @JsonProperty(value="lastAttempt")
    private final @Nullable Long lastAttempt;
    @JsonProperty(value="errorMessage")
    private final @Nullable String errorMessage;

    @JsonCreator
    public ProjectConnectorStatus(@JsonProperty(value="connectorIdentifier") String connectorIdentifier, @JsonProperty(value="status") EConnectorStatus status, @JsonProperty(value="lastSuccess") @Nullable Long lastSuccess, @JsonProperty(value="lastAttempt") @Nullable Long lastAttempt, @JsonProperty(value="errorMessage") @Nullable String errorMessage) {
        CCSMAssert.isNotEmpty((String)connectorIdentifier, (String)"Connector identifier must not be empty");
        this.connectorIdentifier = connectorIdentifier;
        this.status = status;
        this.lastSuccess = lastSuccess;
        this.lastAttempt = lastAttempt;
        this.errorMessage = errorMessage;
    }

    public EConnectorStatus getStatus() {
        return this.status;
    }

    public @Nullable Long getLastSuccess() {
        return this.lastSuccess;
    }

    public @Nullable Long getLastAttempt() {
        return this.lastAttempt;
    }

    public @Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    public String getConnectorIdentifier() {
        return this.connectorIdentifier;
    }

    public String toString() {
        return "connector='" + this.connectorIdentifier + "', status=" + String.valueOf((Object)this.status) + ", lastSuccess=" + this.lastSuccess + ", lastAttempt=" + this.lastAttempt + ", errorMessage='" + this.errorMessage + "'";
    }

    @ExportToTypeScript
    @IndexValueClass
    public static enum EConnectorStatus {
        HEALTHY(0),
        ERROR(4),
        WARNING(3),
        INIT(1),
        UNKNOWN(2);

        private final int priority;

        private EConnectorStatus(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

