/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.index.repository.base.CredentialsBasedIntegerRevisionRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.svn.ESvnProtocol;
import com.teamscale.index.repository.svn.SVNRepositoryConnector;
import com.teamscale.index.repository.svn.SVNRevisionRangeErrorCreator;
import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnChangeRetriever;
import com.teamscale.index.repository.svn.SvnContentUpdater;
import com.teamscale.index.repository.svn.SvnLogCacheIndex;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;

@ConnectorDescriptor
public class SVNRepositoryConnectorDescriptor
extends CredentialsBasedIntegerRevisionRepositoryConnectorDescriptorBase {
    public static final String BRANCHES_DIR_NAME = "branches";
    private static final String EXTERNALS_INCLUDES_PARAMETER = "Externals Includes";
    private static final String EXTERNALS_EXCLUDES_PARAMETER = "Externals Excludes";
    public static final String BRANCHES_DIR_PARAMETER = "Branches directory";
    @ConfigExposed(name="Enable Externals", description="Whether to also parse and interpret svn:externals properties.", visibility=ConfigExposed.EConfigVisibility.ADVANCED, dependentOptions={"Externals Excludes", "Externals Includes"})
    public boolean enableExternals = false;
    @ConfigExposed(name="Externals Includes", description="Ant patterns describing the directories that are checked for svn:externals. Use the special value '.' to denote the top-level directory.\nLines starting with '##' are ignored.", visibility=ConfigExposed.EConfigVisibility.EXPERT, multilineText=true)
    public final List<String> externalsIncludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Externals Excludes", description="Ant patterns describing the directories that are not checked for svn:externals. Use the special value '.' to denote the top-level directory.\nLines starting with '##' are ignored.", visibility=ConfigExposed.EConfigVisibility.EXPERT, multilineText=true)
    public final List<String> externalsExcludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Branches directory", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="A path (relative to the directory denoted by Path suffix) in which to look for branches.")
    public String branchesDirectory = "branches";
    @ConfigExposed(name="Ignored Revisions", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="All revisions provided here are fully ignored when crawling the SVN repository. This can be used to exclude revisions that describe erroneous SVN operations, such as invalid branch creations, that later have been corrected. Note that misuse of this option can lead to unexpected analysis behavior. The excluded revisions are given as a list of revisions separated by comma. Instead of single revisions, you can also provide revision ranges using '-'.")
    public String ignoredRevisions = "";
    private static final List<String> invalidBranchNames = List.of(".");
    private SVNRepository repositoryForValidation = null;
    private SVNLogEntry startRevisionForValidation = null;

    public SVNRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.SVN, "trunk");
        this.autoExpose();
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return SvnChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return SvnContentUpdater.class;
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        triggerBuilder.setTriggerParameter("enable-externals", this.enableExternals);
        triggerBuilder.setTriggerParameter("externals-include-pattern", ITriggerParameter.of(this.externalsIncludePatterns));
        triggerBuilder.setTriggerParameter("externals-exclude-pattern", ITriggerParameter.of(this.externalsExcludePatterns));
        triggerBuilder.setTriggerParameter("branches-directory", this.branchesDirectory);
        triggerBuilder.setTriggerParameter("ignored-revisions", this.ignoredRevisions);
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.renameIndex("svn-log-cache", this.repositoryIdentifier + "-svn-log-cache");
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(SvnLogCacheIndex.class, this.repositoryIdentifier + "-svn-log-cache");
    }

    @Override
    public void validate() throws ConnectorValidationException {
        block12: {
            super.validate();
            SVNRepository repository = null;
            SVNRepository rootRepository = null;
            ExternalCredentials credentials = this.resolveExternalCredentials();
            try {
                repository = SVNUtils.createRepository(this.getRepositoryUri().toString(), credentials.username, credentials.password);
                repository.testConnection();
                SVNURL repositoryRoot = SVNUtils.determineRepositoryRoot(repository, true);
                rootRepository = SVNUtils.createRepository(repositoryRoot, credentials.username, credentials.password);
                long startTimestamp = SVNRepositoryConnectorDescriptor.resolveDateOrRevision(this.startRevision, 0L, repository, rootRepository);
                long endTimestamp = SVNRepositoryConnectorDescriptor.resolveDateOrRevision(this.endRevision, 0x7FFFFFFFFFFFFFFDL, repository, rootRepository);
                this.startRevisionForValidation = this.validateStartRevision(repository, startTimestamp, endTimestamp);
                this.validateBranchingSupport(repository, this.startRevisionForValidation, endTimestamp);
                this.repositoryForValidation = repository;
                SVNRepositoryConnector.parseIgnoredRevisions(this.ignoredRevisions);
            }
            catch (SVNException e) {
                this.handleSVNException(e);
            }
            catch (RepositoryException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof SVNException) {
                    SVNException svnException = (SVNException)throwable;
                    this.handleSVNException(svnException);
                    break block12;
                }
                throw new ConnectorValidationException((Throwable)e);
            }
            catch (NumberFormatException e) {
                throw new ConnectorValidationException((Throwable)e);
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
                if (rootRepository != null) {
                    rootRepository.closeSession();
                }
            }
        }
    }

    @Override
    protected Predicate<String> validUriProtocol() {
        return urlProtocol -> Arrays.stream(ESvnProtocol.values()).anyMatch(svnProtocol -> svnProtocol.getProtocol().equals(urlProtocol));
    }

    @Override
    protected Optional<String> fallbackUriProtocol() {
        return Optional.of(ESvnProtocol.FILE.getProtocol());
    }

    @Override
    protected void validateFileConnection(URI parsedUri) {
    }

    @Override
    protected void validateDefaultBranchName() throws ConnectorValidationException {
        super.validateDefaultBranchName();
        if (invalidBranchNames.contains(this.defaultBranchName)) {
            throw new ConnectorValidationException("Invalid default branch name.");
        }
    }

    private SVNLogEntry validateStartRevision(SVNRepository repository, long startTimestamp, long endTimestamp) throws SVNException, RepositoryException, ConnectorValidationException {
        Optional<SVNLogEntry> firstLogEntry = SVNUtils.getFirstLogEntry(repository, startTimestamp = SVNUtils.updateStartRevisionIfTooLate(repository, startTimestamp));
        if (firstLogEntry.filter(entry -> entry.getDate() == null || entry.getDate().getTime() <= endTimestamp).isEmpty()) {
            throw new ConnectorValidationException("Could not retrieve any revisions for the given path: " + String.valueOf(this.getRepositoryUri()) + " in the revision range " + this.startRevision + "-" + this.endRevision);
        }
        return firstLogEntry.get();
    }

    private void validateBranchingSupport(SVNRepository repository, SVNLogEntry firstLogEntry, long endTimestamp) throws ConnectorValidationException {
        if (this.branchingEnabled) {
            this.validateDirectoryAtFirstRevision(repository, firstLogEntry.getRevision(), "trunk");
            this.validateDirectoryAtFirstRevision(repository, firstLogEntry.getRevision(), this.branchesDirectory);
            if (!this.defaultBranchName.equals("trunk")) {
                this.validateDirectoryAtFirstRevision(repository, firstLogEntry.getRevision(), this.branchesDirectory + "/" + this.defaultBranchName);
            }
            try {
                SVNUtils.verifyRepositoryUrlExistsAtRevision(repository, SVNUtils.getEndRevision(repository, endTimestamp), null);
            }
            catch (RepositoryException | SVNException e) {
                throw new ConnectorValidationException(e);
            }
            return;
        }
        if (CollectionUtils.anyMatch((Collection)CollectionUtils.unionSet((Collection)this.codeIncludePatterns, (Collection[])new Collection[]{this.codeExcludePatterns}), pattern -> pattern.contains("trunk") || !StringUtils.isEmpty((String)this.branchesDirectory) && pattern.contains(this.branchesDirectory))) {
            return;
        }
        this.validateDirectoryDoesNotExistAtFirstRevision(repository, firstLogEntry.getRevision(), "trunk");
        this.validateDirectoryDoesNotExistAtFirstRevision(repository, firstLogEntry.getRevision(), this.branchesDirectory);
    }

    private void validateDirectoryAtFirstRevision(SVNRepository repository, long revision, String directoryName) throws ConnectorValidationException {
        String branchesUri = SVNRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.getRepositoryUri().toString(), directoryName);
        if (!SVNUtils.directoryExists(directoryName, revision, repository)) {
            throw new ConnectorValidationException("Branching is enabled, but could not find the '" + directoryName + "' folder under the given url: " + branchesUri + " at the first revision: " + revision + ". Is the url correct?");
        }
    }

    private void validateDirectoryDoesNotExistAtFirstRevision(SVNRepository repository, long revision, String directoryName) throws ConnectorValidationException {
        String branchesUri = SVNRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.getRepositoryUri().toString(), directoryName);
        if (SVNUtils.directoryExists(directoryName, revision, repository)) {
            throw new ConnectorValidationException(String.format("Branching is disabled, but found the '%s' folder under the given URL %s at the first revision %s. Did you forget to enable branching? If you are sure the setup is what you want, add an include pattern that contains '%s' or '%s'.", directoryName, branchesUri, revision, "trunk", this.branchesDirectory));
        }
    }

    private static long resolveDateOrRevision(String dateOrRevision, long defaultValue, SVNRepository repository, SVNRepository rootRepository) throws RepositoryException {
        Optional timestamp = ConnectorUtils.getTimestampForDate((String)dateOrRevision);
        if (timestamp.isPresent()) {
            return (Long)timestamp.get();
        }
        try {
            return SVNUtils.convertRevisionToTimestamp(dateOrRevision, repository).orElse(defaultValue);
        }
        catch (RepositoryException e) {
            return SVNUtils.convertRevisionToTimestamp(dateOrRevision, rootRepository).orElse(defaultValue);
        }
    }

    private void handleSVNException(SVNException e) throws ConnectorValidationException {
        SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
        URI uri = this.getRepositoryUri();
        if (errorCode == SVNErrorCode.FS_NOT_FOUND) {
            throw new ConnectorValidationException(SVNRevisionRangeErrorCreator.createErrorMessage(this.startRevision, this.endRevision, uri));
        }
        if (errorCode == SVNErrorCode.RA_SVN_IO_ERROR) {
            throw new ConnectorValidationException("Unknown host: " + uri.getHost());
        }
        if (errorCode == SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED) {
            throw new ConnectorValidationException("Could not open local repository at: " + String.valueOf(uri) + " (Path correct?)");
        }
        if (errorCode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
            throw new ConnectorValidationException("No repository found at: " + String.valueOf(uri) + " (URL correct?)");
        }
        if (errorCode == SVNErrorCode.XML_MALFORMED) {
            throw new ConnectorValidationException("Server returned invalid response. Please ensure that URL (Account and Path suffix) points to a valid SVN repository.");
        }
        throw new ConnectorValidationException((Throwable)e);
    }

    @Override
    protected boolean hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(String preselectedUIBranchBeforeTransform) {
        if (this.repositoryForValidation == null || this.startRevisionForValidation == null) {
            return false;
        }
        try {
            Object directoryName = "trunk";
            if (!((String)directoryName).equals(preselectedUIBranchBeforeTransform)) {
                directoryName = StringUtils.ensureEndsWith((String)this.branchesDirectory, (String)"/") + preselectedUIBranchBeforeTransform;
            }
            this.validateDirectoryAtFirstRevision(this.repositoryForValidation, this.startRevisionForValidation.getRevision(), (String)directoryName);
        }
        catch (ConnectorValidationException connectorValidationException) {
            return false;
        }
        return true;
    }
}

