/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.simulink.clones.InvertedSimulinkCloneFragmentIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneFragment;
import com.teamscale.index.simulink.clones.SimulinkCloneFragmentIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class SimulinkCloneFragmentInverter
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private InvertedSimulinkCloneFragmentIndex invertedFragmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkCloneFragmentIndex fragmentIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private SimulinkCloneFragmentIndex previousFragmentIndex;
    @DeltaSource(value=SimulinkCloneFragmentIndex.class)
    private KeyDelta delta;

    public void execute() throws StorageException {
        this.deleteHashesOfDeletedFragments();
        List<List<SimulinkCloneFragment>> oldFragments = this.previousFragmentIndex.getFragmentsForRawKeys(this.delta.getAllKeysAsStrings());
        List<List<SimulinkCloneFragment>> newFragments = this.fragmentIndex.getFragmentsForRawKeys(this.delta.getAddedOrChangedKeysAsStrings());
        HashSet allHashes = new HashSet();
        oldFragments.stream().flatMap(Collection::stream).map(SimulinkCloneFragment::getHash).forEach(allHashes::add);
        newFragments.stream().flatMap(Collection::stream).map(SimulinkCloneFragment::getHash).forEach(allHashes::add);
        ArrayList<Long> hashesToUpdate = new ArrayList<Long>(allHashes);
        HashSet changedKeys = new HashSet(this.delta.getAllKeysAsStrings());
        List<List<SimulinkCloneFragment>> fragmentLists = this.invertedFragmentIndex.getFragmentLists(hashesToUpdate);
        for (List<SimulinkCloneFragment> fragmentList : fragmentLists) {
            fragmentList.removeIf(fragment -> changedKeys.contains(fragment.getRawKey()));
        }
        HashMap<Long, Integer> hashToIndex = new HashMap<Long, Integer>();
        for (int i = 0; i < hashesToUpdate.size(); ++i) {
            hashToIndex.put((Long)hashesToUpdate.get(i), i);
        }
        for (List<SimulinkCloneFragment> fragments : newFragments) {
            for (SimulinkCloneFragment fragment2 : fragments) {
                fragmentLists.get((Integer)hashToIndex.get(fragment2.getHash())).add(fragment2);
            }
        }
        fragmentLists.forEach(list -> list.sort(Comparator.comparing(SimulinkCloneFragment::getRawKey)));
        this.invertedFragmentIndex.updateFragmentLists(hashesToUpdate, fragmentLists);
    }

    private void deleteHashesOfDeletedFragments() throws StorageException {
        List<List<SimulinkCloneFragment>> deletedFragments = this.previousFragmentIndex.getFragmentsForRawKeys(this.delta.getDeletedKeysAsStrings());
        HashSet deletedHashes = new HashSet();
        deletedFragments.stream().flatMap(Collection::stream).map(SimulinkCloneFragment::getHash).forEach(deletedHashes::add);
        ArrayList<Long> hashesToDelete = new ArrayList<Long>(deletedHashes);
        if (!hashesToDelete.isEmpty()) {
            this.invertedFragmentIndex.deleteFragmentLists(hashesToDelete);
        }
    }
}

