/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.signal_labels;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.signal_type.SimulinkResolvedInformationUpdater;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedInformation;

class SimulinkSignalLabelUpdater
extends SimulinkResolvedInformationUpdater {
    public SimulinkSignalLabelUpdater(SimulinkPropagatedSignalLabels propagatedSignalLabels, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks) {
        super((SimulinkResolvedInformation)propagatedSignalLabels, typeLinks);
    }

    @Override
    protected void propagateInformation(SimulinkBlock block, String index, String information, SimulinkTypeLink link) {
        Optional<String> signalLabel = block.getOutPort(index).getSignalName();
        if (signalLabel.isEmpty()) {
            signalLabel = Optional.ofNullable(block.getOutPort(index).getParameter("PropagatedSignals"));
        }
        if (signalLabel.isEmpty()) {
            this.updateInformation(link.getReceiver(), information);
        }
    }

    @Override
    protected void propagateInformation(SimulinkBlock block, String information, SimulinkTypeLink link) {
        Optional outLine = block.getOutLines().stream().findFirst();
        Optional enteredSignalLabel = outLine.flatMap(SimulinkLine::getName);
        if (enteredSignalLabel.isEmpty()) {
            this.updateTypeLink(link, information);
        }
    }

    @Override
    protected boolean updateRequired(Set<String> currentSignalLabels, String signalLabel) {
        return signalLabel != null && !currentSignalLabels.contains(signalLabel);
    }
}

