/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.parser.state.cs;

import com.teamscale.index.stacktrace.component.ExceptionRepresentation;
import com.teamscale.index.stacktrace.component.Stacktrace;
import com.teamscale.index.stacktrace.parser.IStacktraceParserState;
import com.teamscale.index.stacktrace.parser.state.cs.CsWaitingForStackFrameState;
import com.teamscale.index.stacktrace.tokenizer.EStacktraceTokenType;
import com.teamscale.index.stacktrace.tokenizer.token.IStacktraceToken;
import com.teamscale.index.stacktrace.tokenizer.token.cs.CsExceptionToken;
import java.util.EnumSet;

public class CsWaitingForExceptionState
implements IStacktraceParserState {
    @Override
    public EnumSet<EStacktraceTokenType> getValidTokenTypes() {
        return EnumSet.of(EStacktraceTokenType.CS_EXCEPTION);
    }

    @Override
    public void handleToken(Stacktrace stacktrace, IStacktraceToken token) {
        switch (token.getTokenType()) {
            case CS_EXCEPTION: {
                CsExceptionToken exceptionToken = (CsExceptionToken)token;
                stacktrace.add(ExceptionRepresentation.newInitialException(exceptionToken.getExceptionName(), exceptionToken.getExceptionMessage(), null));
                break;
            }
        }
    }

    @Override
    public IStacktraceParserState getNextState(IStacktraceToken token) {
        switch (token.getTokenType()) {
            case CS_EXCEPTION: {
                return new CsWaitingForStackFrameState();
            }
        }
        return null;
    }
}

