/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testcoverage.CoverageMetricSynchronizerBase;
import com.teamscale.index.testcoverage.McDcCoverableAnalyzer;
import com.teamscale.index.testcoverage.ProbeCoverageIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class McDcCoverageMetricSynchronizer
extends CoverageMetricSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_LOGGED_PATHS = 50;
    public static final String ENABLE_MCDC_COVERAGE_PARAMETER_NAME = "enable-mcdc-coverage";
    public static final String COVERABLE_PARTITION = "test-coverable-mcdc";
    public static final String COVERED_PARTITION = "test-covered-mcdc";
    @DeltaSource(value=ProbeCoverageIndex.class)
    private KeyDelta probeCoverageDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProbeCoverageIndex probeCoverageIndex;
    @StepParameter(value="enable-mcdc-coverage")
    private CodeScopeAware<Boolean> enableMcDcCoverage;

    @Override
    protected Set<String> getUniformPathsToUpdate() {
        return CollectionUtils.unionSet(super.getUniformPathsToUpdate(), (Collection[])new Collection[]{this.probeCoverageDelta.getAddedOrChangedKeysAsStrings()});
    }

    @Override
    protected void updateCoverageMetrics(CoverageMetricSynchronizerBase.CoveragePartitionGroup partitionGroup, List<String> uniformPathsToUpdate) throws StorageException {
        PairList coveredMcDcData = new PairList();
        PairList coverableMcDcData = new PairList();
        Map<String, ProbeCoverageInfo> coverageInfosByPath = this.getCoverageInfosByPath(uniformPathsToUpdate, partitionGroup);
        List<TokenElementInfo> elementInfos = this.contentIndex.getTokenElements(uniformPathsToUpdate);
        for (int i = 0; i < uniformPathsToUpdate.size(); ++i) {
            String uniformPath = uniformPathsToUpdate.get(i);
            ProbeCoverageInfo coverageInfo = coverageInfosByPath.get(uniformPathsToUpdate.get(i));
            TokenElementInfo elementInfo = elementInfos.get(i);
            if (coverageInfo == null) {
                McDcCoverageMetricSynchronizer.getCoverableCount(elementInfo).ifPresent(coverableCount -> {
                    coverableMcDcData.add((Object)uniformPath, coverableCount);
                    coveredMcDcData.add((Object)uniformPath, (Object)0.0);
                });
                continue;
            }
            coverableMcDcData.add((Object)uniformPath, (Object)coverageInfo.getCoverableCount());
            coveredMcDcData.add((Object)uniformPath, (Object)coverageInfo.getCoveredCount());
        }
        this.storeData((PairList<String, Double>)coverableMcDcData, (PairList<String, Double>)coveredMcDcData, partitionGroup);
    }

    private static Optional<Double> getCoverableCount(@Nullable TokenElementInfo elementInfo) {
        if (elementInfo == null) {
            return Optional.empty();
        }
        return McDcCoverableAnalyzer.analyze(elementInfo).map(t -> t.getCoverableCount());
    }

    private Map<String, ProbeCoverageInfo> getCoverageInfosByPath(List<String> uniformPathsToUpdate, CoverageMetricSynchronizerBase.CoveragePartitionGroup partitionGroup) throws StorageException {
        HashMap<String, ProbeCoverageInfo> coverageInfosByPath = new HashMap<String, ProbeCoverageInfo>();
        List<String> partitions = partitionGroup.filterPartitions(this.lineCoverageIndex.getPartitions());
        if (partitions.isEmpty()) {
            return coverageInfosByPath;
        }
        Map partitionsToPathsAndCoverage = this.probeCoverageIndex.getCoverageInfos(partitions, uniformPathsToUpdate);
        HashSet<String> uniformPathsWithUnsafeMerge = new HashSet<String>();
        for (Map coverageInfos : partitionsToPathsAndCoverage.values()) {
            for (String uniformPathToUpdate : uniformPathsToUpdate) {
                ProbeCoverageInfo coverageInfo = (ProbeCoverageInfo)coverageInfos.get(uniformPathToUpdate);
                if (coverageInfo == null || coverageInfosByPath.computeIfAbsent(uniformPathToUpdate, x -> new ProbeCoverageInfo(true)).mergeWith(coverageInfo)) continue;
                uniformPathsWithUnsafeMerge.add(uniformPathToUpdate);
            }
        }
        McDcCoverageMetricSynchronizer.logPathsWithUnsafeMerge(uniformPathsWithUnsafeMerge);
        return coverageInfosByPath;
    }

    private static void logPathsWithUnsafeMerge(Set<String> uniformPathsWithUnsafeMerge) {
        if (uniformPathsWithUnsafeMerge.isEmpty()) {
            return;
        }
        Object pathsForMessage = uniformPathsWithUnsafeMerge.stream().sorted().limit(50L).collect(Collectors.joining(", "));
        if (uniformPathsWithUnsafeMerge.size() > 50) {
            pathsForMessage = (String)pathsForMessage + " and " + (uniformPathsWithUnsafeMerge.size() - 50) + " more";
        }
        LOGGER.warn("For the following paths more than one partition contained probe coverage (e.g. MC/DC), which did not merge trivially. The result might not be accurate: " + (String)pathsForMessage);
    }

    @Override
    protected String getDefaultCoverablePartitionName() {
        return COVERABLE_PARTITION;
    }

    @Override
    protected String getDefaultCoveredPartitionName() {
        return COVERED_PARTITION;
    }

    @Override
    protected CodeScopeAware<Boolean> getCodeScopeAwareCoverageEnablement() {
        return this.enableMcDcCoverage;
    }
}

