/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.google.common.collect.ImmutableSet;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;

public class IssueDataRetriever
implements ITgaDataRetriever {
    private final Set<TeamscaleIssueId> issueIds;
    private final List<String> partitions;
    private final CrossAnnotator crossAnnotator;
    private final TgaDataRetrieverIndexes dataRetrieverIndexes;
    private final TestInfoFilter testInfoFilter;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public IssueDataRetriever(Set<TeamscaleIssueId> issueIds, List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.issueIds = issueIds;
        this.partitions = partitions;
        this.crossAnnotator = crossAnnotator;
        this.dataRetrieverIndexes = dataRetrieverIndexes;
        this.testInfoFilter = testInfoFilter;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    public IssueDataRetriever(List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this((Set<TeamscaleIssueId>)ImmutableSet.of((Object)MethodIssueIndex.NO_ISSUE), partitions, dataRetrieverIndexes, crossAnnotator, testInfoFilter, tgaEnablementPerCodeScope);
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        ArrayList<TeamscaleIssueId> issueIds = new ArrayList<TeamscaleIssueId>(this.issueIds);
        List<Map<MethodLocation, Long>> mappings = this.dataRetrieverIndexes.getMethodIssueIndex().getMappingsForIssueIds(issueIds);
        Map<MethodLocation, Pair<Long, TeamscaleIssueId>> mergedMapping = IssueDataRetriever.mergeMethodLastChangedMappingsWithIssues(issueIds, mappings);
        return this.createUnassessedData(this.partitions, mergedMapping, methodInfoFilter);
    }

    private static Map<MethodLocation, Pair<Long, TeamscaleIssueId>> mergeMethodLastChangedMappingsWithIssues(List<TeamscaleIssueId> issueIds, List<Map<MethodLocation, Long>> mappings) {
        HashMap<MethodLocation, Pair<Long, TeamscaleIssueId>> mergedMapping = new HashMap<MethodLocation, Pair<Long, TeamscaleIssueId>>();
        CollectionUtils.forEach(issueIds, mappings, (issueId, mapping) -> mapping.forEach((method, lastChanged) -> mergedMapping.merge((MethodLocation)method, (Pair<Long, TeamscaleIssueId>)new Pair(lastChanged, issueId), (BiFunction<Pair<Long, TeamscaleIssueId>, Pair<Long, TeamscaleIssueId>, Pair<Long, TeamscaleIssueId>>)IssueDataRetriever.pickMaxByLong(ImmutablePair::getFirst))));
        return mergedMapping;
    }

    private static <T> BiFunction<T, T, T> pickMaxByLong(Function<T, Long> longFunction) {
        return (element1, element2) -> {
            if ((Long)longFunction.apply(element1) > (Long)longFunction.apply(element2)) {
                return element1;
            }
            return element2;
        };
    }

    private UnassessedTestGapData createUnassessedData(List<String> partitions, Map<MethodLocation, Pair<Long, TeamscaleIssueId>> lastChangeInIssuePerMethod, MethodInfoFilter methodInfoFilter) throws StorageException {
        Set<MethodLocation> methodLocations = lastChangeInIssuePerMethod.keySet();
        boolean includeCrossAnnotationInformation = this.crossAnnotator.hasCrossAnnotationIndices();
        Set<AssociatedMethodInfo> issueSpecificMethodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getAssociatedMethodInfosForExactPathsAndRegions(methodLocations, includeCrossAnnotationInformation);
        UnassessedTestGapData dataWithIncorrectLastChangeTimestamps = DataRetrieverUtils.createUnassessedTestGapData(issueSpecificMethodInfos, partitions, this.crossAnnotator, this.dataRetrieverIndexes, methodInfoFilter, this.testInfoFilter, this.tgaEnablementPerCodeScope);
        return IssueDataRetriever.fixLastChangeTimestamp(dataWithIncorrectLastChangeTimestamps, lastChangeInIssuePerMethod);
    }

    private static UnassessedTestGapData fixLastChangeTimestamp(UnassessedTestGapData data, Map<MethodLocation, Pair<Long, TeamscaleIssueId>> lastChangeInIssuePerMethod) {
        UnassessedTestGapData fixedData = new UnassessedTestGapData();
        for (UnassessedTestGapData.UnassessedMethodData method : data.getMethods()) {
            Long lastChangeTimestamp = (Long)lastChangeInIssuePerMethod.get(method.getLocation()).getFirst();
            CCSMAssert.isNotNull((Object)lastChangeTimestamp, (String)("Couldn't fix last change timestamp for " + String.valueOf(method) + ". This is a programming error"));
            TeamscaleIssueId lastChangeIssueId = (TeamscaleIssueId)lastChangeInIssuePerMethod.get(method.getLocation()).getSecond();
            fixedData.addMethod(method.withLastChangeInIssueId(lastChangeTimestamp, lastChangeIssueId));
        }
        return fixedData;
    }
}

