/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.collect.Iterables;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdPool;
import com.teamscale.index.testimpact.MethodSet;
import com.teamscale.index.testimpact.MethodToTestsMappingUpdater;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.index.testimpact.TestsToMethodsMapIndexUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="tests-to-methods", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={String.class})
public class CoverageUnitToMethodsMapIndex
extends PartitionIndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "tests-to-methods";
    private static final byte[] TEST_PREFIX = new byte[]{1};
    private static final byte[] METHOD_PREFIX = new byte[]{2};
    private static final long NO_TIMESTAMP = -1L;
    private static final int MAX_METHOD_CHUNKS = Integer.getInteger("com.teamscale.test-impact-method-chunk-size", 100);

    public CoverageUnitToMethodsMapIndex(IStore store) {
        super(store);
    }

    public void appendCoverageInfos(long timestamp, SetMap<PartitionAndPath, MethodId> testMethodsList) throws StorageException {
        MethodToTestsMappingUpdater changeOperations = new MethodToTestsMappingUpdater();
        this.calculateChangeOperations(testMethodsList, changeOperations);
        this.overwriteTestToMethodsMapping(timestamp, testMethodsList);
        this.applyOperationsToMethodsToCoverageUnitMappings(changeOperations);
    }

    public void applyOperationsToMethodsToCoverageUnitMappings(MethodToTestsMappingUpdater mappingUpdater) throws StorageException {
        Set<MethodId> affectedMethods = mappingUpdater.getAffectedMethods();
        UnmodifiableSet<String> affectedPartitions = mappingUpdater.getAffectedPartitions();
        Iterable methodsToUpdateChunked = Iterables.partition(affectedMethods, (int)MAX_METHOD_CHUNKS);
        for (List methodsChunk : methodsToUpdateChunked) {
            Map<MethodId, PartitionedTestSet> methodToTestsMapping = this.getTestsCoveringMethods(methodsChunk, (Collection<String>)affectedPartitions);
            mappingUpdater.applyTo(methodToTestsMapping);
            this.storeMethodsToTestsMapping(methodToTestsMapping);
        }
    }

    public void calculateChangeOperations(SetMap<PartitionAndPath, MethodId> testMethodsList, MethodToTestsMappingUpdater changeOperations) throws StorageException {
        ArrayList<PartitionAndPath> currentExecutedTests = new ArrayList<PartitionAndPath>((Collection<PartitionAndPath>)testMethodsList.getKeys());
        List<MethodSet> previouslyCoveredMethods = this.getMethodSetsCoveredBy(currentExecutedTests);
        for (int i = 0; i < testMethodsList.size(); ++i) {
            MethodSet oldMethods = previouslyCoveredMethods.get(i);
            if (oldMethods == null) {
                oldMethods = new MethodSet(-1L);
            }
            PartitionAndPath testCase = (PartitionAndPath)currentExecutedTests.get(i);
            MethodSet newMethods = new MethodSet(-1L, (Set)testMethodsList.getCollection((Object)testCase));
            MethodSet methodsNotExecutedAnymore = MethodSet.getRelativeComplement(oldMethods, newMethods);
            MethodSet newlyExecutedMethods = MethodSet.getRelativeComplement(newMethods, oldMethods);
            for (MethodId method : methodsNotExecutedAnymore) {
                changeOperations.markAsNoLongerCoveredByTest(method, testCase);
            }
            for (MethodId method : newlyExecutedMethods) {
                changeOperations.markAsNewlyCoveredByTest(method, testCase);
            }
        }
    }

    private void storeMethodsToTestsMapping(Map<MethodId, PartitionedTestSet> methodLocationToTestsMapping) throws StorageException {
        PairList updatedEntries = new PairList();
        for (MethodId method : methodLocationToTestsMapping.keySet()) {
            PartitionedTestSet tests = methodLocationToTestsMapping.get(method);
            for (String partition : tests.getPartitions()) {
                updatedEntries.add((Object)this.makeMethodKey(method, partition), (Object)this.serializeTestList(tests.getTestsFromPartition(partition)));
            }
        }
        this.store.put(updatedEntries);
    }

    private byte[] serializeTestList(UnmodifiableSet<String> testsPaths) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        List abbreviations = abbreviator.abbreviate(new ArrayList<String>((Collection<String>)testsPaths));
        ArrayList list = CollectionUtils.sort((Collection)abbreviations);
        byte[] data = new byte[list.size() * 4];
        for (int i = 0; i < list.size(); ++i) {
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(i * 4), (int)((Integer)list.get(i)));
        }
        return data;
    }

    private @NonNull List<String> deserializeTestList(byte[] data) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ArrayList<String> tests = new ArrayList<String>();
        for (int offset = 0; offset < data.length; offset += 4) {
            tests.add(abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset)));
        }
        return tests;
    }

    void storeTestsToMethodsMapIndexUpdate(TestsToMethodsMapIndexUpdate testsToMethodsMapIndexUpdate) throws StorageException {
        this.updateMethodToTestsMapping(testsToMethodsMapIndexUpdate.methodLocationToTests, testsToMethodsMapIndexUpdate.replace);
        this.updateTestToMethodIds(testsToMethodsMapIndexUpdate);
    }

    void removeMethodLocations(Collection<MethodId> methodLocations) throws StorageException {
        this.store.remove(this.makeMethodKeys(methodLocations, this.getPartitions()));
    }

    private void updateMethodToTestsMapping(Map<MethodId, PartitionedTestSet> methodLocationToTests, boolean replace) throws StorageException {
        if (replace) {
            this.storeMethodsToTestsMapping(methodLocationToTests);
        } else {
            MethodToTestsMappingUpdater methodToTestsMappingUpdater = new MethodToTestsMappingUpdater();
            for (Map.Entry<MethodId, PartitionedTestSet> methodLocationToTest : methodLocationToTests.entrySet()) {
                for (PartitionAndPath partitionAndTest : methodLocationToTest.getValue()) {
                    methodToTestsMappingUpdater.markAsNewlyCoveredByTest(methodLocationToTest.getKey(), partitionAndTest);
                }
            }
            this.applyOperationsToMethodsToCoverageUnitMappings(methodToTestsMappingUpdater);
        }
    }

    private void updateTestToMethodIds(TestsToMethodsMapIndexUpdate testsToMethodsMapIndexUpdate) throws StorageException {
        PairList updatedEntries = new PairList();
        for (Map.Entry<PartitionAndPath, MethodSet> entry : testsToMethodsMapIndexUpdate.testToMethodLocations.entrySet()) {
            PartitionAndPath test = entry.getKey();
            MethodSet methodsCoveredByTest = entry.getValue();
            updatedEntries.add((Object)this.makeTestKey(test), (Object)methodsCoveredByTest.serialize(this.store.getAbbreviator()));
        }
        this.store.put(updatedEntries);
    }

    public Map<MethodId, PartitionedTestSet> getTestsCoveringMethods(Collection<MethodId> methods) throws StorageException {
        return this.getTestsCoveringMethods(methods, this.getPartitions());
    }

    public Map<MethodId, PartitionedTestSet> getTestsCoveringMethods(Collection<MethodId> methods, Collection<String> partitions) throws StorageException {
        HashMap<MethodId, PartitionedTestSet> result = new HashMap<MethodId, PartitionedTestSet>();
        List<byte[]> keys = this.makeMethodKeys(methods, partitions);
        List values = this.store.get(keys);
        CollectionUtils.forEachWithException(keys, (Collection)values, (key, value) -> {
            Pair<MethodId, String> methodIdAndPartition = this.splitKeyToMethodIdAndPartition((byte[])key);
            PartitionedTestSet partitionedTestSet = result.computeIfAbsent((MethodId)methodIdAndPartition.getFirst(), m -> new PartitionedTestSet());
            if (value == null) {
                return;
            }
            List<String> tests = this.deserializeTestList((byte[])value);
            partitionedTestSet.addAll((String)methodIdAndPartition.getSecond(), tests);
        });
        return result;
    }

    public PartitionedTestSet getTestsCoveringMethod(MethodId method) throws StorageException {
        Map<MethodId, PartitionedTestSet> testsCoveringMethods = this.getTestsCoveringMethods(List.of(method));
        return testsCoveringMethods.computeIfAbsent(method, key -> new PartitionedTestSet());
    }

    public void overwriteTestToMethodsMapping(long timestamp, SetMap<PartitionAndPath, MethodId> testMethodsList) throws StorageException {
        PairList keysValues = new PairList();
        for (PartitionAndPath testCase : testMethodsList.getKeys()) {
            byte[] key = this.makeTestKey(testCase);
            MethodSet newMethodSet = new MethodSet(timestamp, (Set)testMethodsList.getCollection((Object)testCase));
            byte[] value = newMethodSet.serialize(this.store.getAbbreviator());
            keysValues.add((Object)key, (Object)value);
        }
        this.store.put(keysValues);
    }

    public List<MethodSet> getMethodSetsCoveredBy(List<PartitionAndPath> tests) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return CollectionUtils.mapWithException((Collection)this.store.get(this.makeTestKeys(tests)), data -> MethodSet.deserialize(data, abbreviator));
    }

    public List<Boolean> getTestsWithCoverage(List<PartitionAndPath> tests) throws StorageException {
        return CollectionUtils.mapWithException((Collection)this.store.get(this.makeTestKeys(tests)), Objects::nonNull);
    }

    private byte[] makeTestKey(PartitionAndPath testCase) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{TEST_PREFIX, ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(StringUtils.emptyIfNull((String)testCase.getPartition()))), ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(testCase.getUniformPath()))});
    }

    private List<byte[]> makeTestKeys(List<PartitionAndPath> testCases) throws StorageException {
        return CollectionUtils.mapWithException(testCases, this::makeTestKey);
    }

    private byte[] makeTestPrefixKey(String partition) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{TEST_PREFIX, ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(partition))});
    }

    private byte[] makeMethodKey(MethodId method, String partition) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{METHOD_PREFIX, ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(method.getUniformPath().toString())), ByteArrayUtils.intToByteArray((int)method.getId()), ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(partition))});
    }

    private Pair<MethodId, String> splitKeyToMethodIdAndPartition(byte[] key) throws StorageException {
        int offset = METHOD_PREFIX.length;
        int pathId = ByteArrayUtils.getIntFromByteArray((byte[])key, (int)offset);
        UniformPath uniformPath = UniformPath.parse((String)this.store.getAbbreviator().unabbreviate(pathId));
        int methodId = ByteArrayUtils.getIntFromByteArray((byte[])key, (int)(offset += 4));
        String partition = this.store.getAbbreviator().unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)(offset += 4)));
        return Pair.createPair((Object)MethodIdPool.getOrCreate(uniformPath, methodId), (Object)partition);
    }

    private List<byte[]> makeMethodKeys(Collection<MethodId> methods, Collection<String> partitions) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (MethodId method : methods) {
            for (String partition : partitions) {
                keys.add(this.makeMethodKey(method, partition));
            }
        }
        return keys;
    }

    public PartitionedTestSet getAllCoveringTestsForMethodsMerged(Set<String> partitions, Set<MethodId> methods) throws StorageException {
        PartitionedTestSet result = new PartitionedTestSet();
        List<byte[]> keys = this.makeMethodKeys(methods, partitions);
        List values = this.store.get(keys);
        CollectionUtils.forEachWithException(keys, (Collection)values, (key, value) -> {
            if (value == null) {
                return;
            }
            Pair<MethodId, String> methodIdAndPartition = this.splitKeyToMethodIdAndPartition((byte[])key);
            List<String> tests = this.deserializeTestList((byte[])value);
            result.addAll((String)methodIdAndPartition.getSecond(), tests);
        });
        return result;
    }

    public List<PartitionAndPath> getAllTests(Set<String> partitions) throws StorageException {
        final ArrayList<PartitionAndPath> result = new ArrayList<PartitionAndPath>();
        final StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        final int testPathOffset = TEST_PREFIX.length + 4;
        for (final String partition : partitions) {
            ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){

                protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                    String testPath = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)testPathOffset));
                    PartitionAndPath partitionAndTest = PartitionAndPath.forCoverageUnit((String)partition, (String)testPath);
                    result.add(partitionAndTest);
                }
            };
            this.store.scanKeys(this.makeTestPrefixKey(partition), (IKeyValueCallback)callback);
            callback.throwCaughtException();
        }
        return result;
    }

    public void deleteCoverageUnits(List<PartitionAndPath> testPartitionAndUniformPaths) throws StorageException {
        MethodToTestsMappingUpdater deleteOperations = this.calculateDeleteOperations(testPartitionAndUniformPaths);
        this.applyOperationsToMethodsToCoverageUnitMappings(deleteOperations);
        this.store.remove(this.makeTestKeys(testPartitionAndUniformPaths));
    }

    private MethodToTestsMappingUpdater calculateDeleteOperations(List<PartitionAndPath> testPartitionAndUniformPaths) throws StorageException {
        List<MethodSet> coveredMethods = this.getMethodSetsCoveredBy(testPartitionAndUniformPaths);
        MethodToTestsMappingUpdater mappingUpdater = new MethodToTestsMappingUpdater();
        for (int i = 0; i < testPartitionAndUniformPaths.size(); ++i) {
            MethodSet oldMethods = coveredMethods.get(i);
            if (oldMethods == null) continue;
            PartitionAndPath testCase = testPartitionAndUniformPaths.get(i);
            for (MethodId method : oldMethods) {
                mappingUpdater.markAsNoLongerCoveredByTest(method, testCase);
            }
        }
        return mappingUpdater;
    }

    public Set<MethodId> getMethodsCoveredBy(UniformPath pathToTest, Collection<String> partitions) throws StorageException {
        List<PartitionAndPath> testInAllPartitions = CoverageUnitToMethodsMapIndex.resolveTestInPartitions(pathToTest, partitions);
        return this.getMethodsCoveredBy(testInAllPartitions).stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public List<PartitionAndPath> resolveTestsWithCoverage(final Set<String> testPaths, Iterable<String> partitions) throws StorageException {
        final ArrayList<PartitionAndPath> result = new ArrayList<PartitionAndPath>();
        final StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        final int testPathOffset = TEST_PREFIX.length + 4;
        for (final String partition : partitions) {
            ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){

                protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                    String testUniformPath = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)testPathOffset));
                    if (testPaths.contains(testUniformPath)) {
                        result.add(PartitionAndPath.forCoverageUnit((String)partition, (String)testUniformPath));
                    }
                }
            };
            this.store.scanKeys(this.makeTestPrefixKey(partition), (IKeyValueCallback)callback);
            callback.throwCaughtException();
        }
        return result;
    }

    private static List<PartitionAndPath> resolveTestInPartitions(UniformPath pathToTest, Collection<String> partitions) {
        return CollectionUtils.map(partitions, partition -> PartitionAndPath.forCoverageUnit((String)partition, (String)pathToTest.toString()));
    }

    public List<Set<MethodId>> getMethodsCoveredBy(List<PartitionAndPath> testCases) throws StorageException {
        List<MethodSet> methodSets = this.getMethodSetsCoveredBy(testCases);
        return CollectionUtils.map(methodSets, methodSet -> {
            if (methodSet == null) {
                return Collections.emptySet();
            }
            return methodSet.toSet();
        });
    }

    public Set<MethodId> getAllMethodIds() throws StorageException {
        final HashSet<MethodId> keys = new HashSet<MethodId>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                keys.add((MethodId)CoverageUnitToMethodsMapIndex.this.splitKeyToMethodIdAndPartition(key).getFirst());
            }
        };
        this.store.scanKeys(METHOD_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return keys;
    }

    @VisibleForTesting
    public Map<MethodId, PartitionedTestSet> getAllMethodEntries() throws StorageException {
        final HashMap<MethodId, PartitionedTestSet> result = new HashMap<MethodId, PartitionedTestSet>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                Pair<MethodId, String> methodIdAndPartition = CoverageUnitToMethodsMapIndex.this.splitKeyToMethodIdAndPartition(key);
                PartitionedTestSet partitionedTestSet = result.computeIfAbsent((MethodId)methodIdAndPartition.getFirst(), methodId -> new PartitionedTestSet());
                partitionedTestSet.addAll((String)methodIdAndPartition.getSecond(), CoverageUnitToMethodsMapIndex.this.deserializeTestList(value));
            }
        };
        this.store.scan(METHOD_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return result;
    }

    @VisibleForTesting
    public Map<PartitionAndPath, MethodSet> getAllTestEntries() throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        int partitionOffset = TEST_PREFIX.length;
        int testPathOffset = TEST_PREFIX.length + 4;
        PairList result = new PairList();
        this.store.scanEntriesStartingWith(CollectionUtils.mapWithException((Collection)this.getPartitions(), this::makeTestPrefixKey), (key, value) -> {
            String partition = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)partitionOffset));
            String testUniformPath = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)testPathOffset));
            result.add((Object)PartitionAndPath.forCoverageUnit((String)partition, (String)testUniformPath), (Object)MethodSet.deserialize(value, abbreviator));
        });
        return result.toMap();
    }

    public Map<PartitionAndPath, MethodSet> getTestEntries(List<PartitionAndPath> tests) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        HashMap<PartitionAndPath, MethodSet> result = new HashMap<PartitionAndPath, MethodSet>();
        List<byte[]> keys = this.makeTestKeys(tests);
        List values = this.store.get(keys);
        for (int i = 0; i < tests.size(); ++i) {
            if (values.get(i) == null) continue;
            result.put(tests.get(i), MethodSet.deserialize((byte[])values.get(i), abbreviator));
        }
        return result;
    }
}

