/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.information_retrieval;

import com.google.common.annotations.VisibleForTesting;
import com.teamscale.index.tests.information_retrieval.data.Term;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.collections.CounterSetSerializer;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Index(name="term-path-frequency-index", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS})
public class TermPathFrequencyIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "term-path-frequency-index";
    private final SimpleCrudIndex<Term, CounterSet<UniformPath>> delegateIndex;

    public TermPathFrequencyIndex(IStore store) {
        super(store);
        CounterSetSerializer counterSetSerializer = new CounterSetSerializer(this::abbreviateUniformPaths, this::unabbreviateUniformPaths);
        this.delegateIndex = new SimpleCrudIndex(store, (ISerializer)new Term.Serializer(), (ISerializer)counterSetSerializer);
    }

    private List<Integer> abbreviateUniformPaths(List<UniformPath> paths) throws StorageException {
        return this.store.getAbbreviator().abbreviate((SequencedCollection)UniformPathCompatibilityUtil.asUniformPathStrings(paths));
    }

    private List<UniformPath> unabbreviateUniformPaths(List<Integer> pathIds) throws StorageException {
        return UniformPathCompatibilityUtil.convertCollection((Collection)this.store.getAbbreviator().unabbreviate(pathIds));
    }

    @VisibleForTesting
    public void put(Term term, CounterSet<UniformPath> pathsWithFrequencyOfTerm) throws StorageException {
        this.delegateIndex.put((Object)term, pathsWithFrequencyOfTerm);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public CounterSet<Term> getNumberOfPathsIncludingTerms(Set<Term> termSet, @Nullable Set<UniformPath> withIntersectionToPaths) throws StorageException {
        CounterSet result = new CounterSet();
        List<Term> terms = List.copyOf(termSet);
        @Nullable List frequencyOfTermsInPaths = this.delegateIndex.get(terms);
        for (int i = 0; i < terms.size(); ++i) {
            Term term = terms.get(i);
            @Nullable CounterSet frequencyOfTermInPaths = (CounterSet)frequencyOfTermsInPaths.get(i);
            if (frequencyOfTermInPaths == null || frequencyOfTermInPaths.isEmpty()) continue;
            if (withIntersectionToPaths != null) {
                frequencyOfTermInPaths.removeIf((path, count) -> !withIntersectionToPaths.contains(path));
            }
            result.inc((Object)term, frequencyOfTermInPaths.getKeys().size());
        }
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void updateWith(Map<Term, CounterSet<UniformPath>> termPathDeltas) throws StorageException {
        List<Term> termsToUpdate = List.copyOf(termPathDeltas.keySet());
        @Nullable Map oldFrequenciesInPaths = this.delegateIndex.getValuesByKeys(termsToUpdate);
        PairList termsWithNewFrequencies = new PairList();
        for (Map.Entry oldFrequency : oldFrequenciesInPaths.entrySet()) {
            Term term = (Term)oldFrequency.getKey();
            CounterSet<UniformPath> termDelta = termPathDeltas.get(term);
            CounterSet newPathTermCount = new CounterSet();
            if (oldFrequency.getValue() != null) {
                newPathTermCount.add((CounterSet)oldFrequency.getValue());
            }
            for (Pair deltaEntry : termDelta) {
                newPathTermCount.inc((Object)((UniformPath)deltaEntry.getFirst()), ((Integer)deltaEntry.getSecond()).intValue());
            }
            termsWithNewFrequencies.add((Object)term, (Object)newPathTermCount);
        }
        this.delegateIndex.put(termsWithNewFrequencies);
    }

    @VisibleForTesting
    public Map<Term, CounterSet<UniformPath>> getAll() throws StorageException {
        return this.delegateIndex.getEntries().toMap();
    }
}

