/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import java.util.HashSet;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ExternalUploadUtils {
    public static final int UPLOAD_TO_CODE_COMMIT_OFFSET = 20;

    public static CommitDescriptor getAdjustedCommit(CommitDescriptor uploadCommit, CommitLayeringBranchingLayer uploadBranchingLayer, boolean useCodeCommitOffset) throws StorageException {
        long adjustedTimestamp = uploadCommit.getTimestamp();
        if (uploadCommit.isHeadCommit()) {
            adjustedTimestamp = DateTimeUtils.millisNow();
        }
        if (useCodeCommitOffset) {
            adjustedTimestamp += 20L;
        }
        HashSet commitTimestamps = new HashSet(uploadBranchingLayer.getAllTimestampsForBranch(uploadCommit.getBranchName()));
        while (commitTimestamps.contains(adjustedTimestamp)) {
            ++adjustedTimestamp;
        }
        return new CommitDescriptor(uploadCommit.getBranchName(), adjustedTimestamp);
    }

    public static boolean isCodeCommit(String repositoryIdentifier) {
        return !repositoryIdentifier.equals("external analysis") && !repositoryIdentifier.equals("architecture upload") && !repositoryIdentifier.equals("Finding flagging uploads") && !repositoryIdentifier.equals("Review commits");
    }

    private ExternalUploadUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

