/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.c.PreprocessorConditionalTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.preprocessor.swift.ConditionalCompilationClauses;
import eu.cqse.check.framework.preprocessor.swift.EvaluationException;
import eu.cqse.check.framework.preprocessor.swift.ProcessingException;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilationCondition;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilerControlConfig;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilerControlStatements;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.Unmodifiable;

class ConditionalCompilationBlockProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @Unmodifiable List<ConditionalCompilationClauses.ClauseInfo> clauseInfos;
    private final @Unmodifiable List<IToken> tokens;
    private final SwiftCompilerControlConfig config;
    private final List<PreprocessorTokenReplacement> removalRegions = new ArrayList<PreprocessorTokenReplacement>();
    private ProcessingState currentState = ProcessingState.INIT;
    private ConditionalCompilationClauses.ClauseInfo currentRemovalStartClause = null;

    private ConditionalCompilationBlockProcessor(@NonNull List<IToken> tokens, @NonNull SwiftCompilerControlConfig config, @NonNull List<ConditionalCompilationClauses.ClauseInfo> clauseInfos) {
        this.tokens = tokens;
        this.config = config;
        this.clauseInfos = clauseInfos;
    }

    public static @NonNull ConditionalRegionResult processBlock(@NonNull List<IToken> tokens, int startIndex, @NonNull SwiftCompilerControlConfig config) throws ProcessingException {
        Preconditions.checkNotNull(tokens);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkElementIndex((int)startIndex, (int)tokens.size(), (String)"Start tokenIndex must be within token list");
        Preconditions.checkArgument((boolean)SwiftCompilerControlStatements.isIf(tokens.get(startIndex)), (Object)"Token at start tokenIndex must be '#if'");
        return ConditionalCompilationBlockProcessor.processBlockInternal(tokens, startIndex, config);
    }

    private static @NonNull ConditionalRegionResult processBlockInternal(@NonNull List<IToken> tokens, int startIndex, @NonNull SwiftCompilerControlConfig config) throws ProcessingException {
        List<ConditionalCompilationClauses.ClauseInfo> clauseInfos = ConditionalCompilationClauses.extractClauses(tokens, startIndex);
        Optional<String> maybeValidationMessage = ConditionalCompilationClauses.validateClauses(clauseInfos);
        if (maybeValidationMessage.isPresent()) {
            IToken startToken = tokens.get(startIndex);
            throw new ProcessingException("Invalid conditional compilation block in '%s:%d' : %s".formatted(startToken.getOriginId(), startToken.getLineNumber() + 1, maybeValidationMessage.get()));
        }
        ConditionalCompilationBlockProcessor processor = new ConditionalCompilationBlockProcessor(tokens, config, clauseInfos);
        return processor.processClauses();
    }

    private @NonNull ConditionalRegionResult processClauses() throws ProcessingException {
        for (int clauseIndex = 0; clauseIndex < this.clauseInfos.size(); ++clauseIndex) {
            ConditionalCompilationClauses.ClauseInfo currentClause = this.clauseInfos.get(clauseIndex);
            this.processClause(currentClause, clauseIndex);
        }
        if (this.currentState != ProcessingState.FINISHED) {
            throw new ProcessingException("End state not reached after processing %d clauses".formatted(this.clauseInfos.size()));
        }
        if (this.removalRegions.isEmpty()) {
            throw new ProcessingException("Processing of %d clauses did not result in any replacements".formatted(this.clauseInfos.size()));
        }
        int lastRemovalEndIndex = this.removalRegions.get((int)(this.removalRegions.size() - 1)).originalTokensEndIndex - 1;
        return new ConditionalRegionResult(lastRemovalEndIndex, this.removalRegions);
    }

    private void processClause(ConditionalCompilationClauses.ClauseInfo currentClause, int clauseIndex) throws ProcessingException {
        switch (this.currentState.ordinal()) {
            case 0: {
                this.processStateInit(currentClause, clauseIndex);
                break;
            }
            case 1: {
                this.processStateRemoveNext(currentClause);
                break;
            }
            case 2: {
                this.processStateRemovingBreakable(currentClause, clauseIndex);
                break;
            }
            case 3: {
                this.processStateRemovingAll(currentClause);
                break;
            }
            case 4: {
                throw new ProcessingException("Attempt to process clause while already in end state: " + String.valueOf(currentClause));
            }
            default: {
                throw new ProcessingException("Reached invalid state while processing: " + String.valueOf(currentClause));
            }
        }
    }

    private void processStateInit(ConditionalCompilationClauses.ClauseInfo currentClause, int clauseIndex) throws ProcessingException {
        if (this.evaluateCondition(currentClause.conditionTokens())) {
            this.logStateChange(ProcessingState.REMOVE_NEXT, currentClause);
            this.storeRegionRemoval(currentClause, currentClause);
            this.processNestedBlockIfNeeded(currentClause.indexAfter(), this.clauseInfos.get(clauseIndex + 1).tokenIndex());
            this.currentState = ProcessingState.REMOVE_NEXT;
        } else {
            this.logStateChange(ProcessingState.REMOVING_BREAKABLE, currentClause);
            this.currentRemovalStartClause = currentClause;
            this.currentState = ProcessingState.REMOVING_BREAKABLE;
        }
    }

    private void processStateRemoveNext(ConditionalCompilationClauses.ClauseInfo currentClause) throws ProcessingException {
        if (SwiftCompilerControlStatements.isEndif(currentClause.token())) {
            this.finishWithEndif(currentClause, currentClause);
        } else if (SwiftCompilerControlStatements.isElse(currentClause.token()) || SwiftCompilerControlStatements.isElseif(currentClause.token())) {
            this.logStateChange(ProcessingState.REMOVING_ALL, currentClause);
            this.currentRemovalStartClause = currentClause;
            this.currentState = ProcessingState.REMOVING_ALL;
        } else {
            throw new ProcessingException("Invalid state: '%s' with %s".formatted(new Object[]{this.currentState, currentClause}));
        }
    }

    private void processStateRemovingBreakable(ConditionalCompilationClauses.ClauseInfo currentClause, int clauseIndex) throws ProcessingException {
        if (SwiftCompilerControlStatements.isEndif(currentClause.token())) {
            this.finishWithEndif(currentClause, this.currentRemovalStartClause);
        } else if (SwiftCompilerControlStatements.isElseif(currentClause.token())) {
            if (this.evaluateCondition(currentClause.conditionTokens())) {
                this.continueWithRemoveNext(currentClause, clauseIndex);
            } else {
                this.logStateChange(this.currentState, currentClause);
            }
        } else if (SwiftCompilerControlStatements.isElse(currentClause.token())) {
            this.continueWithRemoveNext(currentClause, clauseIndex);
        } else {
            throw new ProcessingException("Invalid state: '%s' with %s".formatted(new Object[]{this.currentState, currentClause}));
        }
    }

    private void processStateRemovingAll(ConditionalCompilationClauses.ClauseInfo currentClause) throws ProcessingException {
        if (SwiftCompilerControlStatements.isEndif(currentClause.token())) {
            this.finishWithEndif(currentClause, this.currentRemovalStartClause);
        } else if (SwiftCompilerControlStatements.isElse(currentClause.token()) || SwiftCompilerControlStatements.isElseif(currentClause.token())) {
            this.logStateChange(this.currentState, currentClause);
        } else {
            throw new ProcessingException("Invalid state: '%s' with %s".formatted(new Object[]{this.currentState, currentClause}));
        }
    }

    private void finishWithEndif(ConditionalCompilationClauses.ClauseInfo currentClause, ConditionalCompilationClauses.ClauseInfo removalStartClause) {
        this.logStateChange(ProcessingState.FINISHED, currentClause);
        this.storeRegionRemoval(removalStartClause, currentClause);
        this.currentState = ProcessingState.FINISHED;
    }

    private void continueWithRemoveNext(ConditionalCompilationClauses.ClauseInfo currentClause, int clauseIndex) {
        this.logStateChange(ProcessingState.REMOVE_NEXT, currentClause);
        this.storeRegionRemoval(this.currentRemovalStartClause, currentClause);
        this.currentState = ProcessingState.REMOVE_NEXT;
        this.processNestedBlockIfNeeded(currentClause.indexAfter(), this.clauseInfos.get(clauseIndex + 1).tokenIndex());
    }

    private void processNestedBlockIfNeeded(int startIndex, int endIndex) {
        int nextStartIndex = startIndex;
        int nextIfIndex = SwiftCompilerControlStatements.findFirstIfDirective(this.tokens, nextStartIndex, endIndex);
        while (nextIfIndex >= 0) {
            try {
                ConditionalRegionResult results = ConditionalCompilationBlockProcessor.processBlockInternal(this.tokens, nextIfIndex, this.config);
                this.removalRegions.addAll(results.deletions());
                nextStartIndex = results.lastRemovalEndIndex() + 1;
            }
            catch (Exception e) {
                IToken ifToken = this.tokens.get(nextIfIndex);
                LOGGER.warn("Swift conditional compilation block (nested '{}') could not be processed at '{}:{}'. Attempting to continue, but processing will be incomplete.", (Object)ifToken.getText(), (Object)ifToken.getOriginId(), (Object)(ifToken.getLineNumber() + 1), (Object)e);
                ++nextStartIndex;
            }
            nextIfIndex = SwiftCompilerControlStatements.findFirstIfDirective(this.tokens, nextStartIndex, endIndex);
        }
    }

    private void storeRegionRemoval(ConditionalCompilationClauses.ClauseInfo startClause, ConditionalCompilationClauses.ClauseInfo endClause) {
        PreprocessorTokenReplacement replacement;
        if (SwiftCompilerControlStatements.isIf(startClause.token())) {
            replacement = new PreprocessorTokenReplacement((List<IToken>)CollectionUtils.emptyList(), startClause.tokenIndex(), endClause.indexAfter(), null);
        } else {
            ConditionalCompilationClauses.ClauseInfo firstClause = this.clauseInfos.get(0);
            replacement = new PreprocessorConditionalTokenReplacement(firstClause.token(), (List<IToken>)CollectionUtils.emptyList(), startClause.tokenIndex(), endClause.indexAfter(), null);
        }
        ConditionalCompilationBlockProcessor.logRemovalRegion(this.tokens, replacement);
        this.removalRegions.add(replacement);
    }

    private void logStateChange(ProcessingState nextState, ConditionalCompilationClauses.ClauseInfo currentClause) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("STATE-CHANGE {} -> {}: {}", (Object)this.currentState, (Object)nextState, (Object)currentClause);
        }
    }

    private static void logRemovalRegion(List<IToken> tokens, PreprocessorTokenReplacement replacement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("REMOVAL-REGION {}-{} :\n=====\n{}\n=====", (Object)replacement.originalTokensStartIndex, (Object)(replacement.originalTokensEndIndex - 1), (Object)TokenStreamTextUtils.concatTokenTexts(tokens.subList(replacement.originalTokensStartIndex, replacement.originalTokensEndIndex)));
        }
    }

    private boolean evaluateCondition(List<IToken> conditionTokens) throws ProcessingException {
        try {
            return SwiftCompilationCondition.evaluate(conditionTokens, this.config);
        }
        catch (EvaluationException e) {
            throw new ProcessingException("Condition evaluation failed: " + e.getMessage(), e);
        }
    }

    private static enum ProcessingState {
        INIT,
        REMOVE_NEXT,
        REMOVING_BREAKABLE,
        REMOVING_ALL,
        FINISHED;

    }

    public record ConditionalRegionResult(int lastRemovalEndIndex, @NonNull List<PreprocessorTokenReplacement> deletions) {
    }
}

