/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.IEvaluableConditionValue;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionBase;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.Version;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;

class ImportPlatformCondition
extends PlatformConditionBase {
    private static final TokenPattern VALUE_PARSE_PATTERN = new TokenPattern().sequence(ETokenType.LPAREN).sequence(new TokenPattern().sequence(ETokenType.IDENTIFIER).repeated(ETokenType.DOT, ETokenType.IDENTIFIER)).group(0).optional(new TokenPattern().sequence(ETokenType.COMMA, ETokenType.IDENTIFIER, ETokenType.COLON).skipUntil(ETokenType.RPAREN).group(1)).sequence(ETokenType.RPAREN);
    private static final Pattern CONFIG_SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Pattern VALID_MODULE_NAME_PATTERN = Pattern.compile("[\\w.]+", 256);

    public ImportPlatformCondition(@NonNull String name) {
        super(name);
    }

    @Override
    public @NonNull PlatformConditionBase copyWithName(@NonNull String newName) {
        return new ImportPlatformCondition(newName);
    }

    @Override
    public @NonNull PlatformConditionParseResult parse(@NonNull TokenStream tokenStream) throws ParseException {
        PlatformConditionBase.GenericParseResult genericParseResult = this.parseGeneric(tokenStream);
        TokenPatternMatch valueMatch = VALUE_PARSE_PATTERN.matchFully(genericParseResult.valueTokens());
        ImportPlatformCondition.verifyMatch(tokenStream, valueMatch, 0);
        List<IToken> moduleNameTokens = valueMatch.groupTokens(0);
        String moduleName = TokenStreamTextUtils.concatTokenTexts(moduleNameTokens);
        Version version = null;
        if (valueMatch.hasGroup(1)) {
            String versionString = StringUtils.removeDoubleQuotes((String)TokenStreamTextUtils.concatTokenTexts(valueMatch.groupTokens(1)));
            version = Version.parse(versionString).orElseThrow(() -> new ParseException("Version parse of '%s' failed at: %s".formatted(versionString, tokenStream.peekCurrent())));
        }
        tokenStream.advancePosition(genericParseResult.tokenCount());
        return new PlatformConditionParseResult(this, new Value(moduleName, version));
    }

    @Override
    public @NonNull Object parseConfig(@NonNull String configValue) throws ParseException {
        if (StringUtils.isEmpty((String)configValue)) {
            throw new ParseException("Empty configuration value");
        }
        String[] splitValue = CONFIG_SPLIT_PATTERN.split(configValue, 2);
        String moduleName = splitValue[0];
        if (!VALID_MODULE_NAME_PATTERN.matcher(moduleName).matches()) {
            throw new ParseException("Module name '%s' contains invalid characters".formatted(moduleName));
        }
        Version version = null;
        if (splitValue.length > 1) {
            String versionString = splitValue[1];
            version = Version.parse(versionString).orElseThrow(() -> new ParseException("Cannot parse version '%s' for module '%s' from configuration".formatted(versionString, moduleName)));
        }
        return new ConfigValue(moduleName, version);
    }

    @Override
    public String toString() {
        return "ImportPlatformCondition{name='" + this.name + "'}";
    }

    static class Value
    implements IEvaluableConditionValue {
        private final String moduleName;
        private final @Nullable Version version;

        private Value(@NonNull String moduleName, @Nullable Version version) {
            this.moduleName = moduleName;
            this.version = version;
        }

        @Override
        public Optional<Boolean> evaluate(@NonNull Object configValue) {
            if (!(configValue instanceof ConfigValue)) {
                return Optional.empty();
            }
            ConfigValue configModuleInfo = (ConfigValue)configValue;
            if (!this.moduleName.equals(configModuleInfo.name())) {
                return Optional.of(Boolean.FALSE);
            }
            if (this.version == null) {
                return Optional.of(Boolean.TRUE);
            }
            if (configModuleInfo.version() == null) {
                return Optional.of(Boolean.FALSE);
            }
            return Optional.of(configModuleInfo.version().isGreaterOrEqual(this.version));
        }

        public String toString() {
            if (this.version != null) {
                return this.moduleName + "-" + String.valueOf(this.version);
            }
            return this.moduleName;
        }
    }

    record ConfigValue(@NonNull String name, @Nullable Version version) {
        ConfigValue(@NonNull String name, @Nullable Version version) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkArgument((!name.isBlank() ? 1 : 0) != 0);
        }
    }
}

