/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.RecognizerUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.region.Region;

class CreateNodeRecognizer<STATE extends Enum<STATE>>
extends RecognizerBase<STATE> {
    private final EShallowEntityType type;
    private final INameResolver subtype;
    private final INameResolver name;
    private final int offset;

    public CreateNodeRecognizer(EShallowEntityType type, INameResolver subtype, INameResolver name, int offset) {
        CreateNodeRecognizer.checkNameParameter(subtype);
        CreateNodeRecognizer.checkNameParameter(name);
        this.type = type;
        this.subtype = subtype;
        this.name = name;
        this.offset = offset;
    }

    private static void checkNameParameter(Object subtype) {
        CCSMAssert.isTrue((subtype == null || subtype instanceof String || subtype instanceof Integer || subtype instanceof Region || subtype.getClass().isArray() || subtype instanceof INameResolver ? 1 : 0) != 0, (String)"Parameter must be null, String, int, Region, array or INameResolver!");
    }

    @Override
    public int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        String resolvedSubtype = RecognizerUtils.resolveShallowEntityName(tokens, parserState, startOffset, this.subtype, false);
        String resolvedName = RecognizerUtils.resolveShallowEntityName(tokens, parserState, startOffset, this.name, CreateNodeRecognizer.shouldExtractStringContentFromName(this.type));
        parserState.setNode(new ShallowEntity(this.type, resolvedSubtype, resolvedName, tokens, parserState.getCurrentMatchStart() + this.offset));
        return startOffset;
    }

    public static boolean shouldExtractStringContentFromName(EShallowEntityType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EShallowEntityType.MODULE, EShallowEntityType.TYPE, EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE -> true;
            case EShallowEntityType.STATEMENT, EShallowEntityType.META -> false;
        };
    }

    @Override
    public int matches(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        return Math.max(startOffset, super.matches(parserState, tokens, startOffset));
    }

    @Override
    protected String getRecognizerStringRepresentation() {
        return "createNode[" + String.valueOf(this.type) + ", " + String.valueOf(this.subtype) + "]";
    }
}

