/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cobol;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.postprocessor.cobol.SectionParagraphToMethodProcessor;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.cobol.BoundedByOppositeClausesRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cobol.ConditionalClauseWithEndScopeRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cobol.ECobolParserState;
import eu.cqse.check.framework.shallowparser.languages.cobol.EStatementEndType;
import eu.cqse.check.framework.shallowparser.languages.cobol.NoElseRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cobol.OutOfScopeRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cobol.ParagraphRecognizer;
import java.util.List;

public class CobolShallowParser
extends ShallowParserBase<ECobolParserState> {
    private static final ITokenMatcher IDENTIFIER_AND_STRING_LITERALS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL});
    private static final ITokenMatcher IDENTIFIER_AND_NUMERIC_LITERALS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL});
    private static final ITokenMatcher IDENTIFIER_AND_LITERALS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.STRING_LITERAL});
    private static final ITokenMatcher IDENTIFIER_LITERALS_AND_ZERO = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.STRING_LITERAL, ETokenType.ZERO});
    private static final ITokenMatcher LITERAL_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL});
    private static final ITokenMatcher VALID_VARIABLE_NAMES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.COMPILER_OPTIONS});
    public static final String SECTION_SUBTYPE_NAME = "section";
    public static final String PARAGRAPH_SUBTYPE_NAME = "paragraph";

    public CobolShallowParser() {
        super(ECobolParserState.class, ECobolParserState.TOP_LEVEL);
        this.createTopLevelRules();
    }

    private void createTopLevelRules() {
        this.createRuleForDivision(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ID, ETokenType.IDENTIFICATION}));
        this.createRuleForProgramType(ETokenType.PROGRAM_ID, EShallowEntityType.MODULE, ETokenType.PROGRAM, true);
        this.createRuleForProgramType(ETokenType.CLASS_ID, EShallowEntityType.TYPE, ETokenType.CLASS, true);
        this.createRuleForProgramType(ETokenType.METHOD_ID, EShallowEntityType.METHOD, ETokenType.METHOD, true);
        this.createRuleForProgramType(ETokenType.FUNCTION_ID, EShallowEntityType.METHOD, ETokenType.METHOD, true);
        this.createRuleForProgramType(ETokenType.OBJECT, EShallowEntityType.TYPE, ETokenType.OBJECT, false);
        this.createRuleForProgramType(ETokenType.FACTORY, EShallowEntityType.TYPE, ETokenType.FACTORY, false);
        this.createRulesForEnvironmentDivision();
        this.createRulesForDataDivision();
        this.createRulesForProcedureDivision();
        this.createRulesForCompilerDirectiveStatements();
    }

    private void createRuleForProgramType(ETokenType startType, EShallowEntityType entityType, ETokenType endType, boolean canIncludeEndIdentifier) {
        RecognizerBase<Object> recognizer = this.inAnyState().sequence(new ITokenMatcher[]{startType, ETokenType.DOT});
        if (canIncludeEndIdentifier) {
            recognizer = recognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL}));
            recognizer = startType == ETokenType.PROGRAM_ID ? recognizer.optional(new ITokenMatcher[]{ETokenType.IS}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RECURSIVE, ETokenType.COMMON, ETokenType.INITIAL})).skipAfter(new ITokenMatcher[]{ETokenType.DOT}) : (startType == ETokenType.CLASS_ID ? recognizer.optional(new ITokenMatcher[]{ETokenType.INHERITS, ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.DOT}) : recognizer.sequence(new ITokenMatcher[]{ETokenType.DOT}));
            recognizer = recognizer.createNode(entityType, INameResolver.ofIndex(2)).parseUntilOrEof((Object)ECobolParserState.TOP_LEVEL);
        } else {
            recognizer = recognizer.createNode(entityType, INameResolver.firstMatchedTokenText()).parseUntilOrEof(ECobolParserState.TOP_LEVEL);
        }
        recognizer.sequence(new ITokenMatcher[]{ETokenType.END, endType, ETokenType.DOT}).endNode();
        if (canIncludeEndIdentifier) {
            recognizer.sequence(new ITokenMatcher[]{ETokenType.END, endType, ETokenType.IDENTIFIER, ETokenType.DOT}).endNode();
        }
    }

    private void createRuleForDivision(ITokenMatcher division) {
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{division, ETokenType.DIVISION}).createNode(EShallowEntityType.META, INameResolver.secondMatchedTokenText(), INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
    }

    private void createRulesForEnvironmentDivision() {
        this.createRuleForDivision((ITokenMatcher)ETokenType.ENVIRONMENT);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CONFIGURATION, ETokenType.SECTION}).createNode(EShallowEntityType.META, INameResolver.ofRange(0, 1)), null, EStatementEndType.SIMPLE);
        RecognizerBase sourceComputerSubRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.WITH}).optional(new ITokenMatcher[]{ETokenType.DEBUGGING, ETokenType.MODE}));
        RecognizerBase<ECobolParserState> sourceComputerRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.SOURCE_COMPUTER, ETokenType.DOT}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optionalSubRecognizer(sourceComputerSubRecognizer);
        CobolShallowParser.completeRule(sourceComputerRecognizer, null, EStatementEndType.SIMPLE);
        this.createRulesForObjectComputer();
        this.createRulesForSpecialNamesParagraph();
        this.createRulesForRepositoryParagraph();
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONSTRAINTS, ETokenType.ASSEMBLY_ATTRIBUTES, ETokenType.CLASS_ATTRIBUTES})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CUSTOM_ATTRIBUTE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}), null, EStatementEndType.SIMPLE);
        this.createRulesForIOSection();
    }

    private void createRulesForRepositoryParagraph() {
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.REPOSITORY}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.INTERFACE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).subRecognizer(this.getRepositoryInterfaceClassSubRecognizer()), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROGRAM, ETokenType.PROPERTY, ETokenType.DELEGATE, ETokenType.ENUM}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.AS, LITERAL_TYPES}), null, EStatementEndType.SIMPLE);
        RecognizerBase functionNameRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.AS, LITERAL_TYPES}));
        functionNameRecognizer.sequence(new ITokenMatcher[]{ETokenType.INTRINSIC});
        RecognizerBase<ECobolParserState> functionSubRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.ALL, ETokenType.INTRINSIC}));
        functionSubRecognizer.repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)).optionalSubRecognizer(functionNameRecognizer);
        RecognizerBase<ECobolParserState> functionRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).subRecognizer(functionSubRecognizer);
        CobolShallowParser.completeRule(functionRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRulesForSpecialNamesParagraph() {
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.SPECIAL_NAMES}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        this.createRuleForSwitchClause();
        this.createRuleForAlphabetClause();
        this.createRuleForSymbolicClause();
        this.createRuleForClassClauses();
        RecognizerBase currencySubrecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.WITH}).sequence(new ITokenMatcher[]{ETokenType.PICTURE, ETokenType.SYMBOL, ETokenType.STRING_LITERAL}));
        RecognizerBase<ECobolParserState> currencyRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CURRENCY}).optional(new ITokenMatcher[]{ETokenType.SIGN}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.ofIndex(3)).optionalSubRecognizer(currencySubrecognizer);
        CobolShallowParser.completeRule(currencyRecognizer, null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.DECIMAL_POINT}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), "comma").optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.COMMA}), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.XML_SCHEMA, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(IDENTIFIER_AND_LITERALS).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.NUMERIC, ETokenType.SIGN}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.TRAILING, ETokenType.SEPARATE}).createNode(EShallowEntityType.META, INameResolver.ofRange(0, 1)), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CALL_CONVENTION, ETokenType.INTEGER_LITERAL}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CONSOLE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.CRT}), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CURSOR}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CRT, ETokenType.STATUS}).createNode(EShallowEntityType.META, INameResolver.ofRange(0, 1)).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}), null, EStatementEndType.SIMPLE);
    }

    private void createRuleForClassClauses() {
        RecognizerBase<ECobolParserState> classRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CLASS, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText());
        classRecognizer.sequence(new ITokenMatcher[]{ETokenType.IS}).repeatedSubRecognizer(this.getLiteralThroughAlsoRecognizer(false));
        classRecognizer.sequence(new ITokenMatcher[]{ETokenType.IMPLEMENTS}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER));
        classRecognizer.subRecognizer(this.getRepositoryInterfaceClassSubRecognizer());
        CobolShallowParser.completeRule(classRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getRepositoryInterfaceClassSubRecognizer() {
        RecognizerBase expandsRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.EXPANDS, ETokenType.IDENTIFIER, ETokenType.USING, ETokenType.IDENTIFIER}));
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.AS, LITERAL_TYPES}).optionalSubRecognizer(expandsRecognizer));
    }

    private void createRuleForSwitchClause() {
        RecognizerBase isIdentifierRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase statusRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ON, ETokenType.OFF})).optional(new ITokenMatcher[]{ETokenType.STATUS}).optionalSubRecognizer(isIdentifierRecognizer));
        RecognizerBase switchSubRecognizer = this.createRecognizer(start -> start.optionalSubRecognizer(isIdentifierRecognizer).optionalSubRecognizer(statusRecognizer).optionalSubRecognizer(statusRecognizer));
        RecognizerBase<ECobolParserState> switchRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SWITCH_0, ETokenType.SWITCH_1, ETokenType.SWITCH_2, ETokenType.SWITCH_3, ETokenType.SWITCH_4, ETokenType.SWITCH_5, ETokenType.SWITCH_6, ETokenType.SWITCH_7, ETokenType.SWITCH_8, ETokenType.IDENTIFIER})).subRecognizer(switchSubRecognizer).createNode(EShallowEntityType.META, "special-name", INameResolver.firstMatchedTokenText());
        CobolShallowParser.completeRule(switchRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForSymbolicClause() {
        RecognizerBase symbolicSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.ARE})).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.INTEGER_LITERAL)));
        RecognizerBase<ECobolParserState> symbolicRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.SYMBOLIC}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.CHARACTERS}).repeatedSubRecognizer(symbolicSubRecognizer).optional(new ITokenMatcher[]{ETokenType.IN, ETokenType.IDENTIFIER});
        CobolShallowParser.completeRule(symbolicRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForAlphabetClause() {
        RecognizerBase<ECobolParserState> alphabetRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ALPHABET, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).sequence(new ITokenMatcher[]{ETokenType.IS});
        alphabetRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STANDARD_1, ETokenType.STANDARD_2, ETokenType.NATIVE, ETokenType.ASCII, ETokenType.EBCDIC}));
        alphabetRecognizer.repeatedSubRecognizer(this.getLiteralThroughAlsoRecognizer(true));
        CobolShallowParser.completeRule(alphabetRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getLiteralThroughAlsoRecognizer(boolean includeAlsoRecognizer) {
        RecognizerBase alsoRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.ALSO, LITERAL_TYPES}));
        RecognizerBase literalSubRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(LITERAL_TYPES);
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROUGH, ETokenType.THRU}), LITERAL_TYPES);
            if (includeAlsoRecognizer) {
                prefix.repeatedSubRecognizer(alsoRecognizer);
            }
        });
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).subRecognizer(literalSubRecognizer));
    }

    private void createRulesForObjectComputer() {
        RecognizerBase segmentLimitRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.SEGMENT_LIMIT}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL})));
        RecognizerBase programRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.PROGRAM}).optional(new ITokenMatcher[]{ETokenType.COLLATING}).sequence(new ITokenMatcher[]{ETokenType.SEQUENCE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase memoryRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.MEMORY}).optional(new ITokenMatcher[]{ETokenType.SIZE}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WORDS, ETokenType.CHARACTERS, ETokenType.MODULES})}));
        RecognizerBase<ECobolParserState> objectComputerRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.OBJECT_COMPUTER, ETokenType.DOT}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(memoryRecognizer).optionalSubRecognizer(programRecognizer).optionalSubRecognizer(segmentLimitRecognizer);
        CobolShallowParser.completeRule(objectComputerRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRulesForIOSection() {
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.INPUT_OUTPUT, ETokenType.SECTION}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FILE_CONTROL, ETokenType.I_O_CONTROL})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.SELECT}).optional(new ITokenMatcher[]{ETokenType.OPTIONAL}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, "select", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.createRuleForRerunClause();
        RecognizerBase<ECobolParserState> sameRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.SAME}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RECORD, ETokenType.SORT, ETokenType.SORT_MERGE})).optional(new ITokenMatcher[]{ETokenType.AREA}).optional(new ITokenMatcher[]{ETokenType.FOR}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER));
        CobolShallowParser.completeRule(sameRecognizer, null, EStatementEndType.SIMPLE);
        RecognizerBase multipleFileSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.POSITION, ETokenType.INTEGER_LITERAL}));
        RecognizerBase<ECobolParserState> multipleFileRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.MULTIPLE, ETokenType.FILE}).createNode(EShallowEntityType.META, INameResolver.ofRange(0, 1)).optional(new ITokenMatcher[]{ETokenType.TAPE}).optional(new ITokenMatcher[]{ETokenType.CONTAINS}).repeatedSubRecognizer(multipleFileSubRecognizer);
        CobolShallowParser.completeRule(multipleFileRecognizer, null, EStatementEndType.SIMPLE);
        this.createRuleForApplyClause();
    }

    private void createRuleForApplyClause() {
        RecognizerBase<ECobolParserState> applyRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.APPLY}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText());
        applyRecognizer.sequence(new ITokenMatcher[]{ETokenType.REORG_CRITERIA}).optional(new ITokenMatcher[]{ETokenType.TO}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.ON}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        applyRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CORE_INDEX, ETokenType.RECORD_OVERFLOW, ETokenType.WRITE_ONLY})).optional(new ITokenMatcher[]{ETokenType.ON}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER));
        CobolShallowParser.completeRule(applyRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForRerunClause() {
        RecognizerBase everyIntegerRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL});
            prefix.sequence(new ITokenMatcher[]{ETokenType.RECORDS}).optional(new ITokenMatcher[]{ETokenType.OF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.CLOCK_UNITS});
        });
        RecognizerBase everyRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(new ITokenMatcher[]{ETokenType.EVERY});
            prefix.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.OF}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.REEL, ETokenType.UNIT})).optional(new ITokenMatcher[]{ETokenType.OF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.subRecognizer(everyIntegerRecognizer);
        });
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.RERUN}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.ON, ETokenType.IDENTIFIER}).subRecognizer(everyRecognizer), null, EStatementEndType.SIMPLE);
    }

    private void createRulesForDataDivision() {
        this.createRuleForDivision((ITokenMatcher)ETokenType.DATA);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FILE, ETokenType.WORKING_STORAGE, ETokenType.LOCAL_STORAGE, ETokenType.THREAD_LOCAL_STORAGE, ETokenType.OBJECT_STORAGE, ETokenType.LINKAGE, ETokenType.REPORT, ETokenType.SCREEN}), ETokenType.SECTION}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()), null, EStatementEndType.SIMPLE);
        this.createRuleForFileDescriptionEntry();
        this.createRuleForDataDescriptionEntries();
    }

    private RecognizerBase<ECobolParserState> getUsageClauseRecognizer() {
        RecognizerBase objectRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(new ITokenMatcher[]{ETokenType.REFERENCE});
            prefix.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.FACTORY}).optional(new ITokenMatcher[]{ETokenType.OF}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ACTIVE_CLASS, ETokenType.IDENTIFIER})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ONLY, ETokenType.EVENT}));
        });
        RecognizerBase usageSubRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.IS});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BINARY, ETokenType.CHARACTER, ETokenType.COMPUTATIONAL, ETokenType.COMP, ETokenType.COMPUTATIONAL_1, ETokenType.COMP_1, ETokenType.COMPUTATIONAL_2, ETokenType.COMP_2, ETokenType.COMPUTATIONAL_3, ETokenType.COMP_3, ETokenType.COMPUTATIONAL_4, ETokenType.COMP_4, ETokenType.COMPUTATIONAL_5, ETokenType.COMP_5, ETokenType.COMPUTATIONAL_X, ETokenType.COMP_X, ETokenType.CONDITIONAL_VALUE, ETokenType.DECIMAL, ETokenType.DISPLAY, ETokenType.EVENT_POINTER, ETokenType.FLOAT_SHORT, ETokenType.FLOAT_LONG, ETokenType.INDEX, ETokenType.MONITOR_POINTER, ETokenType.MUTEX_POINTER, ETokenType.NATIONAL, ETokenType.PACKED_DECIMAL, ETokenType.POINTER, ETokenType.PROCEDURE_POINTER, ETokenType.SEMAPHORE_POINTER, ETokenType.STRING, ETokenType.THREAD_POINTER, ETokenType.IDENTIFIER}));
            prefix.sequence(new ITokenMatcher[]{ETokenType.PROGRAM_POINTER}).optional(new ITokenMatcher[]{ETokenType.TO}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.OBJECT}).optionalSubRecognizer(objectRecognizer);
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BINARY_CHAR, ETokenType.BINARY_SHORT, ETokenType.BINARY_LONG, ETokenType.BINARY_DOUBLE}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SIGNED, ETokenType.UNSIGNED}));
        });
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.USAGE}).optional(new ITokenMatcher[]{ETokenType.IS}).subRecognizer(usageSubRecognizer));
    }

    private RecognizerBase<ECobolParserState> getOccursClauseRecognizer() {
        RecognizerBase indexedRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.INDEXED}).optional(new ITokenMatcher[]{ETokenType.BY}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)));
        RecognizerBase ascendDescendRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ASCENDING, ETokenType.DESCENDING})).optional(new ITokenMatcher[]{ETokenType.KEY}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)));
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.OCCURS}).optional(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL, ETokenType.TO}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ANY, ETokenType.INTEGER_LITERAL}))).optional(new ITokenMatcher[]{ETokenType.TIMES}).optionalSubRecognizer(this.getDependingRecognizer()).repeatedSubRecognizer(ascendDescendRecognizer).repeatedSubRecognizer(indexedRecognizer));
    }

    private RecognizerBase<ECobolParserState> getDependingRecognizer() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.DEPENDING}).optional(new ITokenMatcher[]{ETokenType.ON}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
    }

    private void createRuleForDataDescriptionEntries() {
        RecognizerBase renameRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.RENAMES, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROUGH, ETokenType.THRU}), ETokenType.IDENTIFIER}));
        RecognizerBase classModifierRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.INTERNAL})));
        RecognizerBase blankRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.BLANK}).optional(new ITokenMatcher[]{ETokenType.WHEN}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ZERO, ETokenType.ZEROS, ETokenType.ZEROES})));
        RecognizerBase justRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.JUSTIFIED, ETokenType.JUST}), ETokenType.RIGHT}));
        RecognizerBase syncRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SYNC, ETokenType.SYNCHRONIZED})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LEFT, ETokenType.RIGHT})));
        RecognizerBase redefinesRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.REDEFINES, ETokenType.IDENTIFIER}));
        RecognizerBase<ECobolParserState> dataDescriptionRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FILLER, ETokenType.IDENTIFIER})).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.secondMatchedTokenText()).optionalSubRecognizer(redefinesRecognizer).subRecognizer(this.getIsClauseRecognizer(), 0, 4).optionalSubRecognizer(this.getUsageClauseRecognizer()).optionalSubRecognizer(this.getOccursClauseRecognizer()).optionalSubRecognizer(this.getSignRecognizer()).optionalSubRecognizer(syncRecognizer).optionalSubRecognizer(justRecognizer).optionalSubRecognizer(blankRecognizer).optionalSubRecognizer(this.getPropertyClauseRecognizer()).optionalSubRecognizer(classModifierRecognizer).optional(new ITokenMatcher[]{ETokenType.ANY, ETokenType.LENGTH}).optional(new ITokenMatcher[]{ETokenType.PICTURE_CLAUSE}).optionalSubRecognizer(renameRecognizer).optionalSubRecognizer(this.getValuesIsAreRecognizer());
        CobolShallowParser.completeRule(dataDescriptionRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getIsClauseRecognizer() {
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.IS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXTERNAL, ETokenType.GLOBAL, ETokenType.TYPEDEF, ETokenType.THREAD_LOCAL})).optional(new ITokenMatcher[]{ETokenType.BY, LITERAL_TYPES}));
    }

    private RecognizerBase<ECobolParserState> getValuesIsAreRecognizer() {
        RecognizerBase arithmeticRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUS, ETokenType.MINUS, ETokenType.MULT, ETokenType.DIV, ETokenType.AND, ETokenType.OR}));
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTEGER_LITERAL, ETokenType.NEXT}));
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.START, ETokenType.LENGTH})).optional(new ITokenMatcher[]{ETokenType.OF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        });
        RecognizerBase whenRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.WHEN}).optional(new ITokenMatcher[]{ETokenType.SET}).optional(new ITokenMatcher[]{ETokenType.TO}).sequence(new ITokenMatcher[]{ETokenType.FALSE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(LITERAL_TYPES));
        RecognizerBase literalRecognizer = this.createRecognizer(start -> {
            RecognizerBase<ECobolParserState> prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.optional(LITERAL_TYPES).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROUGH, ETokenType.THRU}), LITERAL_TYPES).optionalSubRecognizer(whenRecognizer);
            prefix.subRecognizer(arithmeticRecognizer);
            prefix.repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(LITERAL_TYPES)).sequence(new ITokenMatcher[]{ETokenType.FROM}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.TO}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        });
        RecognizerBase isAreRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.ARE}));
            prefix.sequence(new ITokenMatcher[]{ETokenType.NEXT}).optionalSubRecognizer(arithmeticRecognizer);
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.START, ETokenType.LENGTH})).optional(new ITokenMatcher[]{ETokenType.OF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(arithmeticRecognizer);
            prefix.sequence(LITERAL_TYPES).repeatedSubRecognizer(literalRecognizer);
        });
        return this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VALUE, ETokenType.VALUES})).subRecognizer(isAreRecognizer));
    }

    private RecognizerBase<ECobolParserState> getSignRecognizer() {
        RecognizerBase separateCharRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.SEPARATE}).optional(new ITokenMatcher[]{ETokenType.CHARACTER}));
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.SIGN}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LEADING, ETokenType.TRAILING})).optionalSubRecognizer(separateCharRecognizer));
    }

    private RecognizerBase<ECobolParserState> getPropertyClauseRecognizer() {
        RecognizerBase getSetRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.WITH}).sequence(new ITokenMatcher[]{ETokenType.NO, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET})}));
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.PROPERTY}).optionalSubRecognizer(getSetRecognizer));
    }

    private void createRuleForFileDescriptionEntry() {
        RecognizerBase lineRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.LINES}).optional(new ITokenMatcher[]{ETokenType.AT}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TOP, ETokenType.BOTTOM}), IDENTIFIER_AND_LITERALS));
        RecognizerBase dataRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.DATA}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RECORD, ETokenType.RECORDS})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.ARE})).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)));
        RecognizerBase recordingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.RECORDING}).optional(new ITokenMatcher[]{ETokenType.MODE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FIXED, ETokenType.VARIABLE, ETokenType.IDENTIFIER})));
        RecognizerBase valueOfRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.VALUE, ETokenType.OF, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FILE_ID, ETokenType.IDENTIFIER})}).optional(new ITokenMatcher[]{ETokenType.IS}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS)));
        RecognizerBase recordRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.RECORD}).subRecognizer(this.getContainsRecognizer()));
        RecognizerBase blockRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.BLOCK}).subRecognizer(this.getContainsRecognizer()));
        RecognizerBase<ECobolParserState> descriptionRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FD, ETokenType.SD}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).subRecognizer(this.getIsClauseRecognizer(), 0, 3).optionalSubRecognizer(blockRecognizer).optionalSubRecognizer(recordRecognizer).optionalSubRecognizer(this.getLabelClauseRecognizer()).optionalSubRecognizer(valueOfRecognizer).optionalSubRecognizer(recordingRecognizer).optionalSubRecognizer(dataRecognizer).optionalSubRecognizer(this.linageClauseRecognizer()).optionalSubRecognizer(lineRecognizer).optionalSubRecognizer(lineRecognizer).optionalSubRecognizer(this.getCodeSetClauseRecognizer());
        CobolShallowParser.completeRule(descriptionRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getCodeSetClauseRecognizer() {
        RecognizerBase codeSetSubRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.FOR}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)));
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.CODE_SET}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(codeSetSubRecognizer));
    }

    private RecognizerBase<ECobolParserState> linageClauseRecognizer() {
        RecognizerBase linageSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.WITH}).sequence(new ITokenMatcher[]{ETokenType.FOOTING}).optional(new ITokenMatcher[]{ETokenType.AT}).sequence(IDENTIFIER_AND_LITERALS));
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LINAGE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(IDENTIFIER_AND_LITERALS).optional(new ITokenMatcher[]{ETokenType.LINES}).optionalSubRecognizer(linageSubRecognizer));
    }

    private RecognizerBase<ECobolParserState> getLabelClauseRecognizer() {
        RecognizerBase labelSubRecognizer = this.createRecognizer(start -> {
            start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STANDARD, ETokenType.OMITTED}));
            start.repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER));
        });
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LABEL, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RECORD, ETokenType.RECORDS})}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.ARE})).subRecognizer(labelSubRecognizer));
    }

    private RecognizerBase<ECobolParserState> getContainsRecognizer() {
        RecognizerBase fromToRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.FROM}).optional(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).optional(new ITokenMatcher[]{ETokenType.TO, ETokenType.INTEGER_LITERAL}).optional(new ITokenMatcher[]{ETokenType.CHARACTERS}));
        RecognizerBase containsSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.VARYING}).optional(new ITokenMatcher[]{ETokenType.IN}).optional(new ITokenMatcher[]{ETokenType.SIZE}).optionalSubRecognizer(fromToRecognizer).optionalSubRecognizer(this.getDependingRecognizer()));
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.CONTAINS}).optional(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL, ETokenType.TO}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RECORDS, ETokenType.CHARACTERS})).optionalSubRecognizer(containsSubRecognizer));
    }

    private void createRulesForProcedureDivision() {
        this.createRuleForDivision((ITokenMatcher)ETokenType.PROCEDURE);
        this.createSimpleVerbRules();
        this.createConditionRules();
        this.createLoopVerbRules();
        this.createRulesForFileIOVerbs();
        this.createTryCatchFinallyVerbsRules();
        this.createRuleForSortVerb();
        this.createRuleForMergeVerb();
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).preCondition(new ParagraphRecognizer()).createNode(EShallowEntityType.STATEMENT, PARAGRAPH_SUBTYPE_NAME, INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.SECTION, ETokenType.DOT}).createNode(EShallowEntityType.STATEMENT, SECTION_SUBTYPE_NAME, INameResolver.firstMatchedTokenText()).endNode();
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXEC, ETokenType.EXECUTE})).createNode(EShallowEntityType.STATEMENT, "execute").skipAfter(new ITokenMatcher[]{ETokenType.END_EXEC}), null, EStatementEndType.SIMPLE);
    }

    private void createRuleForSortVerb() {
        RecognizerBase withRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.WITH}).sequence(new ITokenMatcher[]{ETokenType.DUPLICATES}).optional(new ITokenMatcher[]{ETokenType.IN}).optional(new ITokenMatcher[]{ETokenType.ORDER}));
        RecognizerBase collatingRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COLLATING}).sequence(new ITokenMatcher[]{ETokenType.SEQUENCE}).optional(new ITokenMatcher[]{ETokenType.IS}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STANDARD_1, ETokenType.STANDARD_2, ETokenType.NATIVE, ETokenType.EBCDIC, ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL})));
        RecognizerBase onRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).optional(new ITokenMatcher[]{ETokenType.ON}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ASCENDING, ETokenType.DESCENDING})).optional(new ITokenMatcher[]{ETokenType.KEY}).optional(new ITokenMatcher[]{ETokenType.IS}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)));
        RecognizerBase<ECobolParserState> sortRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.SORT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(onRecognizer).optionalSubRecognizer(withRecognizer).optionalSubRecognizer(collatingRecognizer).optionalSubRecognizer(this.getIOUsingGivingRecognizer(ETokenType.INPUT, ETokenType.USING)).optionalSubRecognizer(this.getIOUsingGivingRecognizer(ETokenType.OUTPUT, ETokenType.GIVING));
        CobolShallowParser.completeRule(sortRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getIOUsingGivingRecognizer(ETokenType inputOutputToken, ETokenType usingGiving) {
        RecognizerBase throughRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROUGH, ETokenType.THRU}), ETokenType.IDENTIFIER}));
        RecognizerBase<ECobolParserState> result = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{inputOutputToken, ETokenType.PROCEDURE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(throughRecognizer));
        result.sequence(new ITokenMatcher[]{usingGiving}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER));
        return result;
    }

    private void createRuleForMergeVerb() {
        RecognizerBase onRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).optional(new ITokenMatcher[]{ETokenType.ON}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ASCENDING, ETokenType.DESCENDING})).optional(new ITokenMatcher[]{ETokenType.KEY}).optional(new ITokenMatcher[]{ETokenType.IS}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS)));
        RecognizerBase collatingRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COLLATING}).sequence(new ITokenMatcher[]{ETokenType.SEQUENCE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STANDARD_1, ETokenType.STANDARD_2, ETokenType.NATIVE, ETokenType.EBCDIC, ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL})));
        RecognizerBase usingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.USING, IDENTIFIER_AND_STRING_LITERALS}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_STRING_LITERALS)));
        RecognizerBase outputRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.OUTPUT, ETokenType.PROCEDURE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(IDENTIFIER_AND_STRING_LITERALS).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROUGH, ETokenType.THRU}), IDENTIFIER_AND_STRING_LITERALS));
        outputRecognizer.sequence(new ITokenMatcher[]{ETokenType.GIVING}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_STRING_LITERALS));
        RecognizerBase<ECobolParserState> mergeRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.MERGE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(onRecognizer).optionalSubRecognizer(collatingRecognizer).optionalSubRecognizer(usingRecognizer).optionalSubRecognizer(outputRecognizer);
        CobolShallowParser.completeRule(mergeRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createSingleVerbRules(ITokenMatcher ... statement) {
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(statement).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
    }

    private void createRulesForCompilerDirectiveStatements() {
        this.createSingleVerbRules(new ITokenMatcher[]{ETokenType.EJECT});
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.BASIS, IDENTIFIER_AND_LITERALS}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        ITokenMatcher moreCompilerOptionTokens = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CURRENCY, ETokenType.DATA, ETokenType.DBCS, ETokenType.LIST, ETokenType.OBJECT, ETokenType.SIZE, ETokenType.SOURCE, ETokenType.SPACE, ETokenType.SQL, ETokenType.TEST, ETokenType.CICS, ETokenType.NAME, ETokenType.NOSOURCE, ETokenType.NOLIST, ETokenType.NOMAP, ETokenType.MAP});
        RecognizerBase compilerOptionsRecognizer = this.createRecognizer(start -> {
            RecognizerBase comma = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            comma.sequence(new ITokenMatcher[]{ETokenType.COMPILER_OPTIONS});
            comma.sequence(moreCompilerOptionTokens);
        });
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CBL, ETokenType.PROCESS})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(compilerOptionsRecognizer), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.CONTROL}).subRecognizer(this.getRepeatedSequenceRecognizer(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SOURCE, ETokenType.NOSOURCE, ETokenType.LIST, ETokenType.NOLIST, ETokenType.MAP, ETokenType.NOMAP})), 1, Integer.MAX_VALUE).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        this.createRuleForCopyVerb();
        RecognizerBase<ECobolParserState> replaceRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.REPLACE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        replaceRecognizer.sequence(new ITokenMatcher[]{ETokenType.OFF});
        replaceRecognizer.repeatedSubRecognizer(this.getPseudoTextPartialWordRecognizer());
        CobolShallowParser.completeRule(replaceRecognizer, null, EStatementEndType.SIMPLE);
        this.createSingleVerbRules(new ITokenMatcher[]{ETokenType.INSERT, ETokenType.INTEGER_LITERAL});
        this.createRulesForMoreCompilerDirectives();
    }

    private void createRulesForMoreCompilerDirectives() {
        RecognizerBase<ECobolParserState> textRecognizer = this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS);
        this.createSingleVerbRules(new ITokenMatcher[]{ETokenType.TITLE, ETokenType.STRING_LITERAL});
        this.createSingleVerbRules(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SKIP1, ETokenType.SKIP2, ETokenType.SKIP3}));
        this.createSingleVerbRules(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.READY, ETokenType.RESET}), ETokenType.TRACE});
        RecognizerBase<ECobolParserState> dollarDisplayRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.DOLLAR_DISPLAY}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        dollarDisplayRecognizer.sequence(new ITokenMatcher[]{ETokenType.VCS, ETokenType.EQ, ETokenType.STRING_LITERAL});
        dollarDisplayRecognizer.repeatedSubRecognizer(textRecognizer);
        CobolShallowParser.completeRule(dollarDisplayRecognizer, null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.MINUS, ETokenType.INC}).createNode(EShallowEntityType.STATEMENT, INameResolver.secondMatchedTokenText()).repeatedSubRecognizer(textRecognizer), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.PLUS, ETokenType.PLUS, ETokenType.INCLUDE}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofIndex(2)).repeatedSubRecognizer(textRecognizer), null, EStatementEndType.SIMPLE);
        this.createIfRule(ETokenType.DOLLAR_IF, (ITokenMatcher)ETokenType.DOLLAR_ELSE, ETokenType.DOLLAR_END);
        this.createElseRule((ITokenMatcher)ETokenType.DOLLAR_ELSE, ETokenType.DOLLAR_END);
    }

    private void createRuleForCopyVerb() {
        RecognizerBase ofInRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OF, ETokenType.IN}), IDENTIFIER_AND_LITERALS));
        RecognizerBase replacingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.REPLACING}).repeatedSubRecognizer(this.getPseudoTextPartialWordRecognizer()));
        RecognizerBase<ECobolParserState> copyRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.COPY, IDENTIFIER_AND_LITERALS}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optionalSubRecognizer(ofInRecognizer).optional(new ITokenMatcher[]{ETokenType.SUPPRESS}).optionalSubRecognizer(replacingRecognizer);
        CobolShallowParser.completeRule(copyRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getPseudoTextPartialWordRecognizer() {
        RecognizerBase replacingOperandRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.sequence(IDENTIFIER_AND_LITERALS);
            prefix.sequence(new ITokenMatcher[]{ETokenType.EQ, ETokenType.EQ}).skipAfter(new ITokenMatcher[]{ETokenType.EQ, ETokenType.EQ});
        });
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LEADING, ETokenType.TRAILING})).subRecognizer(replacingOperandRecognizer).sequence(new ITokenMatcher[]{ETokenType.BY}).subRecognizer(replacingOperandRecognizer));
    }

    private void createRulesForFileIOVerbs() {
        this.createRuleForOpenVerb();
        this.createRuleForRewriteVerb();
        this.createRuleForDeleteVerb();
        this.createRuleForStartVerb();
        this.createRuleForCloseVerb();
        this.createRuleForWriteVerb();
        this.createRuleForReadVerb();
    }

    private void createRuleForOpenVerb() {
        RecognizerBase sharingPhraseSubRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.WITH});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ALL, ETokenType.NO})).optional(new ITokenMatcher[]{ETokenType.OTHER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.READ, ETokenType.ONLY});
        });
        RecognizerBase sharingPhraseRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.SHARING}).subRecognizer(sharingPhraseSubRecognizer));
        RecognizerBase openSubRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.sequence(new ITokenMatcher[]{ETokenType.INPUT}).optionalSubRecognizer(sharingPhraseRecognizer).repeatedSubRecognizer(this.getOpenVerbFileSubrecognizer(true, true));
            prefix.sequence(new ITokenMatcher[]{ETokenType.OUTPUT}).optionalSubRecognizer(sharingPhraseRecognizer).repeatedSubRecognizer(this.getOpenVerbFileSubrecognizer(false, true));
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.I_O, ETokenType.EXTEND})).optionalSubRecognizer(sharingPhraseRecognizer).repeatedSubRecognizer(this.getOpenVerbFileSubrecognizer(false, false));
        });
        RecognizerBase<ECobolParserState> openRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.OPEN}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)).repeatedSubRecognizer(openSubRecognizer);
        CobolShallowParser.completeRule(openRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getOpenVerbFileSubrecognizer(boolean includeReserved, boolean includeNoRewind) {
        RecognizerBase withRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.WITH});
            if (includeNoRewind) {
                prefix.sequence(new ITokenMatcher[]{ETokenType.NO, ETokenType.REWIND});
            }
            prefix.sequence(new ITokenMatcher[]{ETokenType.LOCK});
        });
        return this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            if (includeReserved) {
                prefix.sequence(new ITokenMatcher[]{ETokenType.REVERSED});
            }
            prefix.subRecognizer(withRecognizer);
        });
    }

    private void createRuleForCloseVerb() {
        RecognizerBase withRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.WITH});
            prefix.sequence(new ITokenMatcher[]{ETokenType.NO, ETokenType.REWIND});
            prefix.sequence(new ITokenMatcher[]{ETokenType.LOCK});
            prefix.sequence(new ITokenMatcher[]{ETokenType.DISP});
        });
        RecognizerBase reelUnitWithRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.WITH});
            prefix.sequence(new ITokenMatcher[]{ETokenType.LOCK});
            prefix.optional(new ITokenMatcher[]{ETokenType.NO}).sequence(new ITokenMatcher[]{ETokenType.REWIND});
        });
        RecognizerBase reelUnitRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.REEL, ETokenType.UNIT}));
            prefix.optional(new ITokenMatcher[]{ETokenType.FOR}).sequence(new ITokenMatcher[]{ETokenType.REMOVAL});
            prefix.subRecognizer(reelUnitWithRecognizer);
        });
        RecognizerBase fileRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(reelUnitRecognizer).optionalSubRecognizer(withRecognizer));
        RecognizerBase<ECobolParserState> closeRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.CLOSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(fileRecognizer);
        CobolShallowParser.completeRule(closeRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForReadVerb() {
        RecognizerBase<ECobolParserState> readRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.READ, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NEXT, ETokenType.PREVIOUS, ETokenType.RECORD}));
        RecognizerBase<ECobolParserState> intoRecognizer = readRecognizer.sequence(new ITokenMatcher[]{ETokenType.INTO, ETokenType.IDENTIFIER}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WITH, ETokenType.KEPT, ETokenType.NO, ETokenType.LOCK, ETokenType.WAIT, ETokenType.IGNORE}));
        RecognizerBase<ECobolParserState> readWithKeyRecognizer = readRecognizer.skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WITH, ETokenType.KEPT, ETokenType.NO, ETokenType.LOCK, ETokenType.WAIT, ETokenType.IGNORE})).sequence(new ITokenMatcher[]{ETokenType.KEY}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        RecognizerBase<ECobolParserState> intoWithKeyRecognizer = intoRecognizer.sequence(new ITokenMatcher[]{ETokenType.KEY}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        readRecognizer = readRecognizer.skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WITH, ETokenType.KEPT, ETokenType.NO, ETokenType.LOCK, ETokenType.WAIT}));
        this.completeReadImperativeRule(intoWithKeyRecognizer);
        this.completeReadImperativeRule(readWithKeyRecognizer);
        this.completeReadImperativeRule(intoRecognizer);
        this.completeReadImperativeRule(readRecognizer);
        CobolShallowParser.completeRule(intoRecognizer, null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(readRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void completeReadImperativeRule(RecognizerBase<ECobolParserState> recognizer) {
        RecognizerBase<ECobolParserState> notAtSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.NOT}).optional(new ITokenMatcher[]{ETokenType.AT}).sequence(new ITokenMatcher[]{ETokenType.END}).parseOnce(ECobolParserState.IN_STATEMENT));
        CobolShallowParser.completeRuleWithConditionalClause(recognizer, notAtSubRecognizer, ETokenType.END_READ);
        CobolShallowParser.completeRuleWithConditionalClause(recognizer, this.getNotInvalidKeyClauseSubRecognizer(), ETokenType.END_READ);
        CobolShallowParser.completeRule(recognizer, ETokenType.END_READ, EStatementEndType.SIMPLE);
    }

    private void createRuleForWriteVerb() {
        RecognizerBase<ECobolParserState> writeRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.WRITE, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.FLOATING_POINT_LITERAL})}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.FROM, ETokenType.IDENTIFIER});
        RecognizerBase<ECobolParserState> withAdvancingRecognizer = writeRecognizer.skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BEFORE, ETokenType.AFTER, ETokenType.ADVANCING, ETokenType.POSITIONING})).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.PAGE, ETokenType.TAB, ETokenType.FORMFEED})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LINE, ETokenType.LINES}));
        RecognizerBase<ECobolParserState> notAtRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.NOT}).optional(new ITokenMatcher[]{ETokenType.AT}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOP, ETokenType.END_OF_PAGE})).parseOnce(ECobolParserState.IN_STATEMENT));
        CobolShallowParser.completeRuleWithConditionalClause(withAdvancingRecognizer, notAtRecognizer, ETokenType.END_WRITE);
        CobolShallowParser.completeRuleWithConditionalClause(writeRecognizer, this.getNotInvalidKeyClauseSubRecognizer(), ETokenType.END_WRITE);
        CobolShallowParser.completeRule(withAdvancingRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getNotInvalidKeyClauseSubRecognizer() {
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.NOT}).sequence(new ITokenMatcher[]{ETokenType.INVALID}).optional(new ITokenMatcher[]{ETokenType.KEY}).parseOnce(ECobolParserState.IN_STATEMENT));
    }

    private static void completeRuleWithConditionalClause(RecognizerBase<ECobolParserState> recognizer, RecognizerBase<ECobolParserState> subRecognizer, ETokenType endTokenType) {
        RecognizerBase<ECobolParserState> firstRecognizer = recognizer.preCondition(new BoundedByOppositeClausesRecognizer()).subRecognizer(subRecognizer);
        RecognizerBase<ECobolParserState> secondRecognizer = firstRecognizer.subRecognizer(subRecognizer);
        RecognizerBase<ECobolParserState> thirdRecognizer = secondRecognizer.subRecognizer(subRecognizer);
        thirdRecognizer.preCondition(new ConditionalClauseWithEndScopeRecognizer(endTokenType)).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{endTokenType, ETokenType.DOT})).endNode();
        thirdRecognizer.endNode();
        secondRecognizer.preCondition(new ConditionalClauseWithEndScopeRecognizer(endTokenType)).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{endTokenType, ETokenType.DOT})).endNode();
        secondRecognizer.endNode();
        firstRecognizer.preCondition(new ConditionalClauseWithEndScopeRecognizer(endTokenType)).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{endTokenType, ETokenType.DOT})).endNode();
        firstRecognizer.endNode();
    }

    private static void completeRule(RecognizerBase<ECobolParserState> recognizer, ETokenType endToken, EStatementEndType statementEndType) {
        switch (statementEndType) {
            case SIMPLE: {
                if (endToken != null) {
                    recognizer.sequence(new ITokenMatcher[]{endToken}).endNode();
                }
                recognizer.notPreCondition(new OutOfScopeRecognizer()).sequenceBefore(new ITokenMatcher[]{ETokenType.DOT}).endNode();
                recognizer.preCondition(new OutOfScopeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.DOT}).endNode();
                recognizer.endNode();
                break;
            }
            case IMPERATIVE: {
                recognizer.parseOnce(ECobolParserState.IN_STATEMENT).endNode();
                break;
            }
            default: {
                recognizer.preCondition(new OutOfScopeRecognizer()).parseOnce(ECobolParserState.IN_STATEMENT).endNode();
                RecognizerBase<ECobolParserState> finalRecognizer = recognizer.notPreCondition(new OutOfScopeRecognizer()).parseUntil(ECobolParserState.IN_STATEMENT);
                if (endToken != null) {
                    finalRecognizer.sequence(new ITokenMatcher[]{endToken}).endNode();
                }
                finalRecognizer.sequenceBefore(new ITokenMatcher[]{ETokenType.DOT}).endNode();
            }
        }
    }

    private void createSimpleVerbRules() {
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.RAISE}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.RELEASE, IDENTIFIER_AND_LITERALS}).optional(new ITokenMatcher[]{ETokenType.FROM, IDENTIFIER_AND_LITERALS}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.UNLOCK, IDENTIFIER_AND_STRING_LITERALS, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RECORD, ETokenType.RECORDS})}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), null, EStatementEndType.SIMPLE);
        this.createRuleForInspectVerb();
        this.createRuleForServiceVerb();
        this.createRuleForInitializeVerb();
        this.createRuleForComputeVerb();
        this.createRuleForAcceptVerb();
        this.createRuleForDisplayVerb();
        this.createRulesForCallVerb();
        this.createRuleForExamineVerb();
        this.createRuleForExhibitVerb();
        this.createRuleForArithmeticVerbs(ETokenType.ADD, ETokenType.END_ADD, new ITokenMatcher[]{ETokenType.TO});
        this.createRuleForArithmeticVerbs(ETokenType.SUBTRACT, ETokenType.END_SUBTRACT, new ITokenMatcher[]{ETokenType.FROM});
        this.createRuleForArithmeticVerbs(ETokenType.MULTIPLY, ETokenType.END_MULTIPLY, new ITokenMatcher[]{ETokenType.BY});
        this.createRuleForArithmeticVerbs(ETokenType.DIVIDE, ETokenType.END_DIVIDE, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTO, ETokenType.BY}));
        this.createRuleForReturnVerb();
        this.createRuleForOnVerb();
        this.createSingleVerbRules(new ITokenMatcher[]{ETokenType.CONTINUE});
        this.createSingleVerbRules(new ITokenMatcher[]{ETokenType.COMMIT});
        this.createSingleVerbRules(new ITokenMatcher[]{ETokenType.ROLLBACK});
        this.createMoreRulesForSimpleVerbs();
    }

    private void createRuleForInspectVerb() {
        RecognizerBase tallyingForRecognizer = this.createRecognizer(start -> {
            RecognizerBase<ECobolParserState> comma = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            comma.subRecognizer(this.getAllLeadingFirstRecognizer());
            comma.subRecognizer(this.getCharactersRecognizer());
        });
        RecognizerBase forRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.FOR}).repeatedSubRecognizer(tallyingForRecognizer));
        RecognizerBase tallyingSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeatedSubRecognizer(forRecognizer));
        RecognizerBase tallyingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.TALLYING}).repeatedSubRecognizer(tallyingSubRecognizer));
        RecognizerBase replacingSubRecognizer = this.createRecognizer(start -> {
            RecognizerBase<ECobolParserState> comma = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            comma.subRecognizer(this.getCharactersRecognizer());
            comma.subRecognizer(this.getAllLeadingFirstRecognizer());
        });
        RecognizerBase replacingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.REPLACING}).repeatedSubRecognizer(replacingSubRecognizer));
        RecognizerBase convertingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.CONVERTING, IDENTIFIER_AND_LITERALS, ETokenType.TO, IDENTIFIER_AND_LITERALS}).optionalSubRecognizer(this.getBeforeAfterRecognizer()));
        RecognizerBase<ECobolParserState> inspectRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.INSPECT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        inspectRecognizer.subRecognizer(tallyingRecognizer).optionalSubRecognizer(replacingRecognizer);
        inspectRecognizer.subRecognizer(replacingRecognizer);
        inspectRecognizer.subRecognizer(convertingRecognizer);
        CobolShallowParser.completeRule(inspectRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getAllLeadingFirstRecognizer() {
        RecognizerBase identifierLiteralRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(IDENTIFIER_AND_LITERALS).optional(new ITokenMatcher[]{ETokenType.BY, IDENTIFIER_AND_LITERALS}).repeatedSubRecognizer(this.getBeforeAfterRecognizer()));
        return this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ALL, ETokenType.LEADING, ETokenType.FIRST})).repeatedSubRecognizer(identifierLiteralRecognizer));
    }

    private RecognizerBase<ECobolParserState> getCharactersRecognizer() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.CHARACTERS}).optional(new ITokenMatcher[]{ETokenType.BY, IDENTIFIER_AND_LITERALS}).repeatedSubRecognizer(this.getBeforeAfterRecognizer()));
    }

    private RecognizerBase<ECobolParserState> getBeforeAfterRecognizer() {
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BEFORE, ETokenType.AFTER})).optional(new ITokenMatcher[]{ETokenType.INITIAL}).sequence(IDENTIFIER_AND_LITERALS));
    }

    private void createRuleForOnVerb() {
        RecognizerBase everyRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.AND, ETokenType.EVERY, IDENTIFIER_AND_LITERALS}));
        RecognizerBase untilRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.UNTIL, IDENTIFIER_AND_LITERALS}));
        RecognizerBase elseOtherwiseRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.OTHERWISE})).parseOnce(ECobolParserState.IN_STATEMENT));
        RecognizerBase<ECobolParserState> onRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.ON, IDENTIFIER_AND_LITERALS}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optionalSubRecognizer(everyRecognizer).optionalSubRecognizer(untilRecognizer).parseOnce(ECobolParserState.IN_STATEMENT).optionalSubRecognizer(elseOtherwiseRecognizer);
        CobolShallowParser.completeRule(onRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForServiceVerb() {
        RecognizerBase<ECobolParserState> serviceRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.SERVICE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        serviceRecognizer.sequence(new ITokenMatcher[]{ETokenType.RELOAD, ETokenType.IDENTIFIER});
        serviceRecognizer.sequence(new ITokenMatcher[]{ETokenType.LABEL});
        CobolShallowParser.completeRule(serviceRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForReturnVerb() {
        RecognizerBase<ECobolParserState> returnRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.RETURN, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.RECORD}).optional(new ITokenMatcher[]{ETokenType.INTO, ETokenType.IDENTIFIER});
        CobolShallowParser.completeRuleWithConditionalClause(returnRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.END}), ETokenType.END_RETURN);
        CobolShallowParser.completeRule(returnRecognizer, ETokenType.END_RETURN, EStatementEndType.SIMPLE);
    }

    private void createRuleForArithmeticVerbs(ETokenType startVerb, ETokenType endVerb, ITokenMatcher ... qualifyVerbs) {
        RecognizerBase identifierRoundedRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(IDENTIFIER_AND_NUMERIC_LITERALS).optional(new ITokenMatcher[]{ETokenType.ROUNDED}));
        RecognizerBase givingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.GIVING}).repeatedSubRecognizer(identifierRoundedRecognizer));
        RecognizerBase<ECobolParserState> arithmeticRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{startVerb}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CORRESPONDING, ETokenType.CORR})).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_NUMERIC_LITERALS)).optional(qualifyVerbs).repeatedSubRecognizer(identifierRoundedRecognizer).optionalSubRecognizer(givingRecognizer).optional(new ITokenMatcher[]{ETokenType.REMAINDER, ETokenType.IDENTIFIER});
        CobolShallowParser.completeRuleWithConditionalClause(arithmeticRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.SIZE, ETokenType.ERROR}), endVerb);
        CobolShallowParser.completeRule(arithmeticRecognizer, endVerb, EStatementEndType.SIMPLE);
    }

    private void createRuleForExhibitVerb() {
        RecognizerBase<ECobolParserState> exhibitRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.EXHIBIT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        exhibitRecognizer.sequence(new ITokenMatcher[]{ETokenType.NAMED}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS));
        exhibitRecognizer.sequence(new ITokenMatcher[]{ETokenType.CHANGED}).optional(new ITokenMatcher[]{ETokenType.NAMED}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS));
        exhibitRecognizer.repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS));
        CobolShallowParser.completeRule(exhibitRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForExamineVerb() {
        RecognizerBase tallyingRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(new ITokenMatcher[]{ETokenType.TALLYING});
            prefix.sequence(new ITokenMatcher[]{ETokenType.UNTIL, ETokenType.FIRST, IDENTIFIER_AND_LITERALS}).optional(new ITokenMatcher[]{ETokenType.REPLACING, ETokenType.BY, IDENTIFIER_AND_LITERALS});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ALL, ETokenType.LEADING}), IDENTIFIER_AND_LITERALS).optional(new ITokenMatcher[]{ETokenType.REPLACING, ETokenType.BY, IDENTIFIER_AND_STRING_LITERALS});
        });
        RecognizerBase replacingRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(new ITokenMatcher[]{ETokenType.REPLACING});
            prefix.sequence(new ITokenMatcher[]{ETokenType.UNTIL, ETokenType.FIRST, IDENTIFIER_AND_LITERALS, ETokenType.BY, IDENTIFIER_AND_LITERALS});
            prefix.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ALL, ETokenType.LEADING, ETokenType.FIRST}), IDENTIFIER_AND_LITERALS, ETokenType.BY, IDENTIFIER_AND_LITERALS});
        });
        RecognizerBase<ECobolParserState> examineRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.EXAMINE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        examineRecognizer.subRecognizer(tallyingRecognizer);
        examineRecognizer.subRecognizer(replacingRecognizer);
        CobolShallowParser.completeRule(examineRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForRewriteVerb() {
        RecognizerBase<ECobolParserState> rewriteRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.REWRITE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.FROM, ETokenType.IDENTIFIER});
        CobolShallowParser.completeRuleWithConditionalClause(rewriteRecognizer, this.getNotInvalidKeyClauseSubRecognizer(), ETokenType.END_REWRITE);
        CobolShallowParser.completeRule(rewriteRecognizer, ETokenType.END_REWRITE, EStatementEndType.SIMPLE);
    }

    private void createRuleForDeleteVerb() {
        RecognizerBase baseDeleteRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.DELETE});
        CobolShallowParser.completeRule(baseDeleteRecognizer.sequence(new ITokenMatcher[]{ETokenType.FILE}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofRange(0, 1)).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)), null, EStatementEndType.SIMPLE);
        RecognizerBase<ECobolParserState> withRecordRecognizer = baseDeleteRecognizer.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.RECORD});
        CobolShallowParser.completeRuleWithConditionalClause(withRecordRecognizer, this.getNotInvalidKeyClauseSubRecognizer(), ETokenType.END_DELETE);
        CobolShallowParser.completeRule(withRecordRecognizer, ETokenType.END_DELETE, EStatementEndType.SIMPLE);
    }

    private void createRuleForInitializeVerb() {
        ITokenMatcher categoryNameTokens = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ALPHABETIC, ETokenType.ALPHANUMERIC, ETokenType.ALPHANUMERIC_EDITED, ETokenType.DATA_POINTER, ETokenType.DBCS, ETokenType.NATIONAL, ETokenType.NATIONAL_EDITED, ETokenType.NUMERIC, ETokenType.NUMERIC_EDITED, ETokenType.OBJECT_REFERENCE, ETokenType.PROGRAM_POINTER});
        ITokenMatcher categoryNamesWithALLToken = categoryNameTokens.or(new ITokenMatcher[]{ETokenType.ALL});
        RecognizerBase byRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).optional(categoryNameTokens).optional(new ITokenMatcher[]{ETokenType.DATA}).sequence(new ITokenMatcher[]{ETokenType.BY, IDENTIFIER_AND_LITERALS}));
        RecognizerBase replacingRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.THEN}).sequence(new ITokenMatcher[]{ETokenType.REPLACING}).repeatedSubRecognizer(byRecognizer));
        RecognizerBase toValueRecognizer = this.createRecognizer(start -> start.sequence(categoryNamesWithALLToken).optional(new ITokenMatcher[]{ETokenType.TO}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase identifierRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase<ECobolParserState> initializeRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.INITIALIZE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(identifierRecognizer).optional(new ITokenMatcher[]{ETokenType.WITH}).optional(new ITokenMatcher[]{ETokenType.FILLER}).optionalSubRecognizer(toValueRecognizer).optionalSubRecognizer(replacingRecognizer).optional(new ITokenMatcher[]{ETokenType.THEN, ETokenType.TO, ETokenType.DEFAULT});
        CobolShallowParser.completeRule(initializeRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForComputeVerb() {
        RecognizerBase identifierRoundedRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.ROUNDED}));
        RecognizerBase<ECobolParserState> computeRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.COMPUTE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(identifierRoundedRecognizer).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.EQUAL})).subRecognizer(this.getArithmeticExpressionRecognizer(false));
        CobolShallowParser.completeRuleWithConditionalClause(computeRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.SIZE, ETokenType.ERROR}), ETokenType.END_COMPUTE);
        CobolShallowParser.completeRule(computeRecognizer, ETokenType.END_COMPUTE, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getAtRecognizer() {
        RecognizerBase columnRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLUMN, ETokenType.COL})).optional(new ITokenMatcher[]{ETokenType.NUMBER}).sequence(IDENTIFIER_AND_NUMERIC_LITERALS));
        return this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.AT});
            prefix.sequence(new ITokenMatcher[]{ETokenType.LINE}).optional(new ITokenMatcher[]{ETokenType.NUMBER}).sequence(IDENTIFIER_AND_NUMERIC_LITERALS).optionalSubRecognizer(columnRecognizer);
            prefix.sequence(IDENTIFIER_AND_NUMERIC_LITERALS);
        });
    }

    private RecognizerBase<ECobolParserState> getModeRecognizer() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.MODE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.BLOCK}));
    }

    private RecognizerBase<ECobolParserState> getWithRecognizer(boolean includeTokensForAcceptVerb) {
        RecognizerBase withSubRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BELL, ETokenType.BEEP, ETokenType.BLINK, ETokenType.GRID, ETokenType.HIGHLIGHT, ETokenType.LOWLIGHT, ETokenType.LEFTLINE, ETokenType.OVERLINE, ETokenType.REVERSE_VIDEO, ETokenType.UNDERLINE}));
            if (includeTokensForAcceptVerb) {
                prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AUTO, ETokenType.AUTO_SKIP, ETokenType.FULL, ETokenType.LENGTH_CHECK, ETokenType.REQUIRED, ETokenType.EMPTY_CHECK, ETokenType.SECURE, ETokenType.NO_ECHO, ETokenType.LEFT_JUSTIFY, ETokenType.RIGHT_JUSTIFY, ETokenType.SPACE_FILL, ETokenType.TRAILING_SIGN, ETokenType.UPDATE, ETokenType.UPPER, ETokenType.LOWER, ETokenType.ZERO_FILL}));
                prefix.sequence(new ITokenMatcher[]{ETokenType.PROMPT}).optional(new ITokenMatcher[]{ETokenType.CHARACTER}).optional(new ITokenMatcher[]{ETokenType.IS}).optional(IDENTIFIER_AND_LITERALS);
                prefix.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TIMEOUT, ETokenType.TIME_OUT}), ETokenType.AFTER, IDENTIFIER_AND_LITERALS});
            }
            prefix.sequence(new ITokenMatcher[]{ETokenType.ERASE, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.EOS})});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SIZE, ETokenType.FOREGROUND_COLOR, ETokenType.FOREGROUND_COLOUR, ETokenType.BACKGROUND_COLOR, ETokenType.BACKGROUND_COLOUR, ETokenType.CONTROL})).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(IDENTIFIER_AND_LITERALS);
            prefix.sequence(new ITokenMatcher[]{ETokenType.BLANK, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SCREEN, ETokenType.LINE})});
            prefix.sequence(new ITokenMatcher[]{ETokenType.NO, ETokenType.ADVANCING});
        });
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.WITH}).repeatedSubRecognizer(withSubRecognizer));
    }

    private void createRuleForAcceptVerb() {
        RecognizerBase fromRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(new ITokenMatcher[]{ETokenType.FROM});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DAY_OF_WEEK, ETokenType.TIME, ETokenType.CRT}));
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DATE, ETokenType.DAY})).optional(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL});
            prefix.sequence(new ITokenMatcher[]{ETokenType.LINE, ETokenType.NUMBER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.USER, ETokenType.NAME});
            prefix.sequence(new ITokenMatcher[]{ETokenType.ESCAPE, ETokenType.KEY});
            prefix.sequence(new ITokenMatcher[]{ETokenType.EXCEPTION, ETokenType.STATUS});
        });
        RecognizerBase<ECobolParserState> acceptRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.ACCEPT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optionalSubRecognizer(this.getAtRecognizer()).optionalSubRecognizer(fromRecognizer).optionalSubRecognizer(this.getModeRecognizer()).optionalSubRecognizer(this.getWithRecognizer(true));
        CobolShallowParser.completeRuleWithConditionalClause(acceptRecognizer, this.createOnAtClauseSubRecognizer(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXCEPTION, ETokenType.ESCAPE})), ETokenType.END_ACCEPT);
        CobolShallowParser.completeRule(acceptRecognizer, ETokenType.END_ACCEPT, EStatementEndType.SIMPLE);
    }

    private void createRuleForDisplayVerb() {
        RecognizerBase uponRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.UPON, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CRT, ETokenType.CRT_UNDER, ETokenType.IDENTIFIER})}));
        RecognizerBase displaySubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS)).optionalSubRecognizer(this.getAtRecognizer()).optionalSubRecognizer(uponRecognizer).optionalSubRecognizer(this.getModeRecognizer()).optionalSubRecognizer(this.getWithRecognizer(false)));
        RecognizerBase<ECobolParserState> displayRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.DISPLAY}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(displaySubRecognizer);
        CobolShallowParser.completeRuleWithConditionalClause(displayRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.EXCEPTION}), ETokenType.END_DISPLAY);
        CobolShallowParser.completeRule(displayRecognizer, ETokenType.END_DISPLAY, EStatementEndType.SIMPLE);
    }

    private void createRuleForXMLVerb() {
        RecognizerBase xmlRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.XML, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GENERATE, ETokenType.PARSE}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText());
        RecognizerBase countRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.COUNT}).optional(new ITokenMatcher[]{ETokenType.IN}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase<ECobolParserState> generateRecognizer = xmlRecognizer.sequence(new ITokenMatcher[]{ETokenType.FROM, ETokenType.IDENTIFIER}).optionalSubRecognizer(countRecognizer);
        RecognizerBase<ECobolParserState> parseRecognizer = xmlRecognizer.sequence(new ITokenMatcher[]{ETokenType.PROCESSING, ETokenType.PROCEDURE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROUGH, ETokenType.THRU}), ETokenType.IDENTIFIER});
        CobolShallowParser.completeRuleWithConditionalClause(generateRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.EXCEPTION}), ETokenType.END_XML);
        CobolShallowParser.completeRule(generateRecognizer, ETokenType.END_XML, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRuleWithConditionalClause(parseRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.EXCEPTION}), ETokenType.END_XML);
        CobolShallowParser.completeRule(parseRecognizer, ETokenType.END_XML, EStatementEndType.SIMPLE);
    }

    private void createRuleForInvokeVerb() {
        RecognizerBase identifierRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.AS, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OBJECT, ETokenType.IDENTIFIER}), IDENTIFIER_AND_LITERALS});
            prefix.sequence(IDENTIFIER_AND_LITERALS);
        });
        RecognizerBase<ECobolParserState> invokeRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.INVOKE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).subRecognizer(identifierRecognizer).optionalSubRecognizer(this.getUsingSubrecognizer()).optionalSubRecognizer(this.getGivingReturningRecognizer());
        CobolShallowParser.completeRule(invokeRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForChainVerb() {
        RecognizerBase<ECobolParserState> chainRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.CHAIN, IDENTIFIER_AND_LITERALS}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optionalSubRecognizer(this.getUsingSubrecognizer());
        CobolShallowParser.completeRule(chainRecognizer, ETokenType.END_CHAIN, EStatementEndType.SIMPLE);
    }

    private void createRulesForCallVerb() {
        RecognizerBase identifierNumeralsRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL}), ETokenType.AS, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NESTED, ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL})}));
        identifierNumeralsRecognizer.sequence(IDENTIFIER_AND_LITERALS, IDENTIFIER_AND_LITERALS);
        identifierNumeralsRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NESTED, ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL}));
        identifierNumeralsRecognizer.sequence(new ITokenMatcher[]{ETokenType.COMPILER_OPTIONS});
        RecognizerBase<ECobolParserState> baseCallRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.CALL}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).subRecognizer(identifierNumeralsRecognizer);
        baseCallRecognizer = baseCallRecognizer.optionalSubRecognizer(this.getUsingSubrecognizer()).optionalSubRecognizer(this.getGivingReturningRecognizer());
        this.completeCallRules(baseCallRecognizer);
    }

    private RecognizerBase<ECobolParserState> getGivingReturningRecognizer() {
        return this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GIVING, ETokenType.RETURNING}));
            prefix.sequence(new ITokenMatcher[]{ETokenType.ADDRESS, ETokenType.OF, ETokenType.IDENTIFIER});
            prefix.optional(new ITokenMatcher[]{ETokenType.INTO}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        });
    }

    private RecognizerBase<ECobolParserState> getUsingSubrecognizer() {
        RecognizerBase repeatedUsingSubRecognizer = this.createRecognizer(start -> {
            RecognizerBase<ECobolParserState> prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ADDRESS, ETokenType.LENGTH}), ETokenType.OF, ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL, ETokenType.SIZE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.OMITTED}));
            prefix.subRecognizer(this.getArithmeticExpressionRecognizer(true));
        });
        RecognizerBase usingRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).optional(new ITokenMatcher[]{ETokenType.BY}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.REFERENCE, ETokenType.CONTENT, ETokenType.VALUE})).optional(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ADDRESS, ETokenType.LENGTH}), ETokenType.OF}).repeatedSubRecognizer(repeatedUsingSubRecognizer));
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.USING}).repeatedSubRecognizer(usingRecognizer));
    }

    private void completeCallRules(RecognizerBase<ECobolParserState> recognizer) {
        CobolShallowParser.completeRuleWithConditionalClause(recognizer, this.createOnAtClauseSubRecognizer(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXCEPTION, ETokenType.OVERFLOW})), ETokenType.END_CALL);
        CobolShallowParser.completeRule(recognizer, ETokenType.END_CALL, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> createOnAtClauseSubRecognizer(ITokenMatcher ... statement) {
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.NOT}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ON, ETokenType.AT})).sequence(statement).parseOnce(ECobolParserState.IN_STATEMENT));
    }

    private void createMoreRulesForSimpleVerbs() {
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.NEXT, ETokenType.SENTENCE}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofRange(0, 1)), null, EStatementEndType.SIMPLE);
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.INSPECT, ETokenType.IDENTIFIER, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TALLYING, ETokenType.REPLACING})}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).endNode();
        this.createRuleForAlterVerb();
        this.createRuleForMoveVerb();
        this.createRuleForStopVerb();
        this.createRuleForSetVerb();
        this.createRuleForExitVerb();
        this.createRuleForStringVerb();
        this.createRuleForUnstringVerb();
        this.createRuleForGobackVerb();
        this.createRuleForTransformVerb();
        this.createRuleForUseVerb();
        this.createRuleForWaitVerb();
        this.createRuleForChainVerb();
        this.createRuleForInvokeVerb();
        this.createRuleForXMLVerb();
        this.createRuleForEntryVerb();
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.ENTER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL})), null, EStatementEndType.SIMPLE);
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.LIST}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.CANCEL}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS)), null, EStatementEndType.SIMPLE);
    }

    private void createRuleForEntryVerb() {
        RecognizerBase givingReturningRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GIVING, ETokenType.RETURNING}), ETokenType.IDENTIFIER}));
        RecognizerBase repeatedRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.REPEATED}).optional(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL, ETokenType.TO, ETokenType.INTEGER_LITERAL}));
        RecognizerBase referenceValueRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.DELIMITED}).optional(new ITokenMatcher[]{ETokenType.BY, ETokenType.SIZE});
            prefix.sequence(new ITokenMatcher[]{ETokenType.ANY});
        });
        RecognizerBase usingSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.BY}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.REFERENCE, ETokenType.VALUE})).repeatedSubRecognizer(referenceValueRecognizer));
        RecognizerBase usingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.USING}).repeatedSubRecognizer(usingSubRecognizer).optionalSubRecognizer(repeatedRecognizer));
        RecognizerBase<ECobolParserState> entryRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.ENTRY, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(usingRecognizer).optionalSubRecognizer(givingReturningRecognizer);
        CobolShallowParser.completeRule(entryRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForStartVerb() {
        RecognizerBase contentRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.BY}).sequence(new ITokenMatcher[]{ETokenType.CONTENT}));
        RecognizerBase usingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.USING}).optionalSubRecognizer(contentRecognizer).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase returningRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.RETURNING}).optional(new ITokenMatcher[]{ETokenType.INTO}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase identifiedRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIED}).optional(new ITokenMatcher[]{ETokenType.BY}).sequence(IDENTIFIER_AND_LITERALS));
        RecognizerBase statusRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.STATUS}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase withRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.WITH}).sequence(new ITokenMatcher[]{ETokenType.SIZE, IDENTIFIER_AND_LITERALS}));
        RecognizerBase keyConditionalRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.KEY}).skipAfter(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(withRecognizer));
        RecognizerBase<ECobolParserState> startRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.START}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_LITERALS)).optionalSubRecognizer(usingRecognizer).optionalSubRecognizer(returningRecognizer).optionalSubRecognizer(identifiedRecognizer).optionalSubRecognizer(statusRecognizer).optionalSubRecognizer(keyConditionalRecognizer);
        CobolShallowParser.completeRuleWithConditionalClause(startRecognizer, this.getNotInvalidKeyClauseSubRecognizer(), ETokenType.END_START);
        CobolShallowParser.completeRuleWithConditionalClause(startRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.EXCEPTION}), ETokenType.END_START);
        CobolShallowParser.completeRule(startRecognizer, ETokenType.END_START, EStatementEndType.SIMPLE);
    }

    private void createRuleForWaitVerb() {
        RecognizerBase returningRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.RETURNING}).optional(new ITokenMatcher[]{ETokenType.INTO}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase statusRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.STATUS}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase<ECobolParserState> waitRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.WAIT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.FOR}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(returningRecognizer).optionalSubRecognizer(statusRecognizer);
        CobolShallowParser.completeRuleWithConditionalClause(waitRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.EXCEPTION}), ETokenType.END_WAIT);
        CobolShallowParser.completeRule(waitRecognizer, ETokenType.END_WAIT, EStatementEndType.SIMPLE);
    }

    private void createRuleForUseVerb() {
        RecognizerBase procedureRecognizer = this.createRecognizer(start -> {
            RecognizerBase<ECobolParserState> onRecognizer = start.optional(new ITokenMatcher[]{ETokenType.ON});
            onRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INPUT, ETokenType.OUTPUT, ETokenType.I_O, ETokenType.EXTEND}));
            onRecognizer.repeatedSubRecognizer(this.getRepeatedSequenceRecognizer(IDENTIFIER_AND_STRING_LITERALS));
        });
        RecognizerBase givingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.GIVING, IDENTIFIER_AND_STRING_LITERALS}).optional(IDENTIFIER_AND_STRING_LITERALS));
        RecognizerBase<ECobolParserState> useRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.USE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.GLOBAL}).sequence(new ITokenMatcher[]{ETokenType.AFTER}).optional(new ITokenMatcher[]{ETokenType.STANDARD});
        useRecognizer.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXCEPTION, ETokenType.ERROR}), ETokenType.PROCEDURE}).subRecognizer(procedureRecognizer).optionalSubRecognizer(givingRecognizer);
        useRecognizer.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BEGINNING, ETokenType.ENDING}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FILE, ETokenType.REEL, ETokenType.UNIT}), ETokenType.LABEL, ETokenType.PROCEDURE}).subRecognizer(procedureRecognizer);
        CobolShallowParser.completeRule(useRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForTransformVerb() {
        RecognizerBase<ECobolParserState> transformRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.TRANSFORM, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.CHARACTERS});
        transformRecognizer.sequence(new ITokenMatcher[]{ETokenType.FROM, IDENTIFIER_AND_STRING_LITERALS, ETokenType.TO, IDENTIFIER_AND_STRING_LITERALS});
        CobolShallowParser.completeRule(transformRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForGobackVerb() {
        RecognizerBase givingReturningRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GIVING, ETokenType.RETURNING}));
            prefix.optional(new ITokenMatcher[]{ETokenType.ADDRESS, ETokenType.OF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL});
        });
        RecognizerBase<ECobolParserState> goBackRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.GOBACK}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        goBackRecognizer.optionalSubRecognizer(givingReturningRecognizer);
        CobolShallowParser.completeRule(goBackRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForAlterVerb() {
        RecognizerBase repeatedRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.TO}).optional(new ITokenMatcher[]{ETokenType.PROCEED, ETokenType.TO}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase<ECobolParserState> alterRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.ALTER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(repeatedRecognizer);
        CobolShallowParser.completeRule(alterRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForMoveVerb() {
        RecognizerBase<ECobolParserState> moveRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.MOVE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.TO}).sequence(VALID_VARIABLE_NAMES).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase rightOperandRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN));
        moveRecognizer.repeatedSubRecognizer(rightOperandRecognizer);
        CobolShallowParser.completeRule(moveRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForStopVerb() {
        RecognizerBase stopRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.STOP}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        RecognizerBase<ECobolParserState> withLiteralRecognizer = stopRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL}));
        RecognizerBase<ECobolParserState> baseRunRecognizer = stopRecognizer.sequence(new ITokenMatcher[]{ETokenType.RUN});
        RecognizerBase<ECobolParserState> runRecognizer = baseRunRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GIVING, ETokenType.RETURNING}));
        runRecognizer.sequence(new ITokenMatcher[]{ETokenType.ADDRESS, ETokenType.OF, ETokenType.IDENTIFIER});
        runRecognizer.sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL, ETokenType.SIZE}).optional(new ITokenMatcher[]{ETokenType.IS}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL});
        runRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTEGER_LITERAL, ETokenType.IDENTIFIER}));
        CobolShallowParser.completeRule(runRecognizer, null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(baseRunRecognizer, null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(withLiteralRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createRuleForStringVerb() {
        RecognizerBase leftOperandRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(IDENTIFIER_AND_LITERALS));
        ITokenMatcher rightOperandTokens = IDENTIFIER_AND_LITERALS.or(new ITokenMatcher[]{ETokenType.SIZE});
        RecognizerBase stringRecognizer = this.createRecognizer(start -> start.repeatedSubRecognizer(leftOperandRecognizer).sequence(new ITokenMatcher[]{ETokenType.DELIMITED}).optional(new ITokenMatcher[]{ETokenType.BY}).sequence(rightOperandTokens));
        RecognizerBase<ECobolParserState> baseStringRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.STRING}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(stringRecognizer).sequence(new ITokenMatcher[]{ETokenType.INTO, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.WITH}).optional(new ITokenMatcher[]{ETokenType.POINTER, ETokenType.IDENTIFIER});
        CobolShallowParser.completeRuleWithConditionalClause(baseStringRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.OVERFLOW}), ETokenType.END_STRING);
        CobolShallowParser.completeRule(baseStringRecognizer, ETokenType.END_STRING, EStatementEndType.SIMPLE);
    }

    private void createRuleForUnstringVerb() {
        RecognizerBase orAllRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.OR}).optional(new ITokenMatcher[]{ETokenType.ALL}).sequence(IDENTIFIER_AND_LITERALS));
        RecognizerBase delimitedByRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.DELIMITED}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BY, ETokenType.ALL})).sequence(IDENTIFIER_AND_LITERALS).repeatedSubRecognizer(orAllRecognizer));
        RecognizerBase intoRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.optional(new ITokenMatcher[]{ETokenType.COMMA});
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DELIMITER, ETokenType.COUNT})).optional(new ITokenMatcher[]{ETokenType.IN}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        });
        RecognizerBase withPointerRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.WITH}).sequence(new ITokenMatcher[]{ETokenType.POINTER, ETokenType.IDENTIFIER}));
        RecognizerBase tallyingRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.TALLYING}).optional(new ITokenMatcher[]{ETokenType.IN}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        RecognizerBase<ECobolParserState> unstringRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.UNSTRING, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText());
        unstringRecognizer = unstringRecognizer.optionalSubRecognizer(delimitedByRecognizer).sequence(new ITokenMatcher[]{ETokenType.INTO}).repeatedSubRecognizer(intoRecognizer).optionalSubRecognizer(withPointerRecognizer).optionalSubRecognizer(tallyingRecognizer);
        CobolShallowParser.completeRuleWithConditionalClause(unstringRecognizer, this.createOnAtClauseSubRecognizer(new ITokenMatcher[]{ETokenType.OVERFLOW}), ETokenType.END_UNSTRING);
        CobolShallowParser.completeRule(unstringRecognizer, ETokenType.END_UNSTRING, EStatementEndType.SIMPLE);
    }

    private void createRuleForSetVerb() {
        RecognizerBase<ECobolParserState> baseSetRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.SET}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        RecognizerBase leftAndRightRepetitionRecognizer = this.createRecognizer(start -> start.repeatedSubRecognizer(this.getLeftOperandForSetVerb()).subRecognizer(this.getRightOperandForSetVerb()));
        baseSetRecognizer.repeatedSubRecognizer(leftAndRightRepetitionRecognizer);
        CobolShallowParser.completeRule(baseSetRecognizer, null, EStatementEndType.SIMPLE);
    }

    private RecognizerBase<ECobolParserState> getRightOperandForSetVerb() {
        return this.createRecognizer(start -> {
            RecognizerBase<ECobolParserState> prefix = start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TO, ETokenType.UP, ETokenType.DOWN}));
            prefix.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.ON, ETokenType.OFF, ETokenType.TRUE, ETokenType.FALSE, ETokenType.NULL, ETokenType.NULLS}));
            prefix.sequence(new ITokenMatcher[]{ETokenType.ADDRESS, ETokenType.OF, ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.BY}).optional(new ITokenMatcher[]{ETokenType.LENGTH, ETokenType.OF}).sequence(IDENTIFIER_AND_NUMERIC_LITERALS);
            prefix.sequence(new ITokenMatcher[]{ETokenType.ENTRY, IDENTIFIER_AND_LITERALS});
            prefix.optional(new ITokenMatcher[]{ETokenType.NOT}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BROWSING, ETokenType.READING, ETokenType.WRITING}), ETokenType.CONVERTING, ETokenType.FROM, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BROWSING, ETokenType.WRITING})});
            prefix.optional(new ITokenMatcher[]{ETokenType.NOT}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BROWSING, ETokenType.READING, ETokenType.WRITING}));
            prefix.repeatedSubRecognizer(this.getArithmeticExpressionRecognizer(true));
        });
    }

    private RecognizerBase<ECobolParserState> getRepeatedSequenceRecognizer(ITokenMatcher sequence) {
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(sequence));
    }

    private RecognizerBase<ECobolParserState> getLeftOperandForSetVerb() {
        return this.createRecognizer(start -> {
            start.optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ADDRESS, ETokenType.SIZE, ETokenType.CONTENT})).optional(new ITokenMatcher[]{ETokenType.OF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            start.subRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER));
        });
    }

    private void createRuleForExitVerb() {
        RecognizerBase exitProgramRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GIVING, ETokenType.RETURNING}));
            prefix.optional(new ITokenMatcher[]{ETokenType.ADDRESS, ETokenType.OF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL});
        });
        RecognizerBase<ECobolParserState> exitRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.EXIT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        exitRecognizer.sequence(new ITokenMatcher[]{ETokenType.PERFORM}).optional(new ITokenMatcher[]{ETokenType.CYCLE});
        exitRecognizer.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FUNCTION, ETokenType.METHOD, ETokenType.PARAGRAPH, ETokenType.SECTION}));
        exitRecognizer.sequence(new ITokenMatcher[]{ETokenType.PROGRAM}).optionalSubRecognizer(exitProgramRecognizer);
        CobolShallowParser.completeRule(exitRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createConditionRules() {
        this.createIfAndElseRules();
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.EVALUATE}).createNode(EShallowEntityType.STATEMENT, "evaluate"), ETokenType.END_EVALUATE, EStatementEndType.SCOPE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.SEARCH}).optional(new ITokenMatcher[]{ETokenType.ALL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VARYING, ETokenType.IDENTIFIER, ETokenType.AT, ETokenType.END})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), ETokenType.END_SEARCH, EStatementEndType.SCOPE);
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.WHEN}).optional(new ITokenMatcher[]{ETokenType.OTHER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()), null, EStatementEndType.SIMPLE);
    }

    private void createLoopVerbRules() {
        this.createPerformRules();
        RecognizerBase<ECobolParserState> gotoRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.GO}).createNode(EShallowEntityType.STATEMENT, "goto").optional(new ITokenMatcher[]{ETokenType.TO}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        RecognizerBase<ECobolParserState> gotoDependingRecognizer = gotoRecognizer.repeatedSubRecognizer(this.getRepeatedSequenceRecognizer((ITokenMatcher)ETokenType.IDENTIFIER)).subRecognizer(this.getDependingRecognizer());
        CobolShallowParser.completeRule(gotoDependingRecognizer, null, EStatementEndType.SIMPLE);
        CobolShallowParser.completeRule(gotoRecognizer, null, EStatementEndType.SIMPLE);
    }

    private void createPerformRules() {
        RecognizerBase performRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.PERFORM});
        RecognizerBase<ECobolParserState> identifierRecognizer = performRecognizer.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText());
        RecognizerBase<ECobolParserState> throughRecognizer = identifierRecognizer.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THRU, ETokenType.THROUGH}), ETokenType.IDENTIFIER});
        this.completePerformRule(throughRecognizer, EStatementEndType.SIMPLE);
        this.completePerformRule(identifierRecognizer, EStatementEndType.SIMPLE);
        this.completePerformRule(performRecognizer.createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), EStatementEndType.SCOPE);
    }

    private void completePerformRule(RecognizerBase<ECobolParserState> recognizer, EStatementEndType statementEndType) {
        ITokenMatcher skippedTokens = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WITH, ETokenType.TEST, ETokenType.BEFORE, ETokenType.AFTER});
        RecognizerBase<ECobolParserState> timesRecognizer = recognizer.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL}), ETokenType.TIMES});
        RecognizerBase<ECobolParserState> untilRecognizer = recognizer.skipWhile(skippedTokens).sequence(new ITokenMatcher[]{ETokenType.UNTIL}).subRecognizer(this.getConditionSubRecognizer());
        RecognizerBase<ECobolParserState> varyingUntilRecognizer = recognizer.skipWhile(skippedTokens).sequence(new ITokenMatcher[]{ETokenType.VARYING}).skipAfter(new ITokenMatcher[]{ETokenType.UNTIL}).subRecognizer(this.getConditionSubRecognizer());
        RecognizerBase repeatedAfterUntilRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.AFTER}).skipAfter(new ITokenMatcher[]{ETokenType.UNTIL}).subRecognizer(this.getConditionSubRecognizer()));
        RecognizerBase<ECobolParserState> varyingUntilAfterRecognizer = varyingUntilRecognizer.repeatedSubRecognizer(repeatedAfterUntilRecognizer);
        CobolShallowParser.completeRule(varyingUntilAfterRecognizer, ETokenType.END_PERFORM, statementEndType);
        CobolShallowParser.completeRule(varyingUntilRecognizer, ETokenType.END_PERFORM, statementEndType);
        CobolShallowParser.completeRule(untilRecognizer, ETokenType.END_PERFORM, statementEndType);
        CobolShallowParser.completeRule(timesRecognizer, ETokenType.END_PERFORM, statementEndType);
        if (statementEndType == EStatementEndType.SIMPLE) {
            recognizer.notPreCondition(new OutOfScopeRecognizer()).sequenceBefore(new ITokenMatcher[]{ETokenType.END_PERFORM}).endNode();
        }
        CobolShallowParser.completeRule(recognizer, ETokenType.END_PERFORM, statementEndType);
    }

    private RecognizerBase<ECobolParserState> getArithmeticExpressionRecognizer(boolean includeComma) {
        ITokenMatcher operatorTokens = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUS, ETokenType.MINUS, ETokenType.DIV, ETokenType.MULT, ETokenType.B_AND, ETokenType.B_OR, ETokenType.B_NOT, ETokenType.B_XOR});
        ITokenMatcher operandTokens = IDENTIFIER_LITERALS_AND_ZERO.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NULL, ETokenType.NULLS, ETokenType.SELF})}).except(new ITokenMatcher[]{ETokenType.STRING_LITERAL});
        ITokenMatcher finalOperandTokens = includeComma ? operandTokens.or(new ITokenMatcher[]{ETokenType.COMMA}) : operandTokens;
        RecognizerBase operatorBeforeExpressionRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.sequence(operatorTokens);
            prefix.sequence(finalOperandTokens);
            prefix.skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        });
        RecognizerBase repeatedExpressionRecognizer = this.createRecognizer(start -> {
            start.subRecognizer(operatorBeforeExpressionRecognizer);
            start.skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        });
        return this.createRecognizer(start -> {
            start.sequence(finalOperandTokens).repeatedSubRecognizer(repeatedExpressionRecognizer);
            start.skipNested(ETokenType.LPAREN, ETokenType.RPAREN).repeatedSubRecognizer(repeatedExpressionRecognizer);
        });
    }

    private RecognizerBase<ECobolParserState> getConditionSubRecognizer() {
        ITokenMatcher leftOperandTokens = IDENTIFIER_LITERALS_AND_ZERO.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NULL, ETokenType.NULLS, ETokenType.SELF})});
        RecognizerBase singleOperandRecognizer = this.createRecognizer(start -> start.sequence(leftOperandTokens));
        return this.createRecognizer(start -> start.optionalSubRecognizer(this.getArithmeticExpressionRecognizer(false)).optionalSubRecognizer(singleOperandRecognizer));
    }

    private void createIfAndElseRules() {
        this.createIfRule(ETokenType.IF, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.OTHERWISE}), ETokenType.END_IF);
        this.createElseRule(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.OTHERWISE}), ETokenType.END_IF);
    }

    private void createElseRule(ITokenMatcher elseOtherwise, ETokenType endToken) {
        RecognizerBase<ECobolParserState> elseOtherwiseRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(elseOtherwise).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(ECobolParserState.IN_STATEMENT);
        elseOtherwiseRecognizer.sequenceBefore(elseOtherwise).endNode();
        elseOtherwiseRecognizer.sequence(new ITokenMatcher[]{endToken}).endNode();
        elseOtherwiseRecognizer.sequenceBefore(new ITokenMatcher[]{ETokenType.DOT}).endNode();
    }

    private void createIfRule(ETokenType ifType, ITokenMatcher elseOtherwise, ETokenType endIfType) {
        RecognizerBase<ECobolParserState> ifRecognizer = this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ifType}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(ECobolParserState.IN_STATEMENT);
        ifRecognizer.sequenceBefore(elseOtherwise).endNodeWithContinuation();
        ifRecognizer.preCondition(new NoElseRecognizer(ifType, endIfType)).sequence(new ITokenMatcher[]{endIfType}).endNode();
        ifRecognizer.sequenceBefore(new ITokenMatcher[]{ETokenType.DOT}).endNode();
    }

    private void createTryCatchFinallyVerbsRules() {
        CobolShallowParser.completeRule(this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.TRY}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()), ETokenType.END_TRY, EStatementEndType.SCOPE);
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.CATCH, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(ECobolParserState.IN_STATEMENT).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY, ETokenType.END_TRY, ETokenType.DOT})).endNode();
        this.inState(new ECobolParserState[]{ECobolParserState.TOP_LEVEL, ECobolParserState.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.FINALLY}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(ECobolParserState.IN_STATEMENT).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.END_TRY, ETokenType.DOT})).endNode();
    }

    @Override
    public List<ShallowEntity> parseTopLevelWithErrors(List<IToken> tokens) throws ShallowParserException {
        return new SectionParagraphToMethodProcessor(tokens).postProcess(super.parseTopLevelWithErrors(tokens));
    }
}

