/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.go;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.RecognizerUtils;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import java.util.List;

class GoBraceSkipRecognizer
extends RecognizerBase<EGenericParserStates> {
    private static final RecognizerBase<EGenericParserStates> SKIP_TO_OPENING_BRACE = RecognizerUtils.createRecognizer(start -> start.skipBeforeWithNesting((ITokenMatcher)ETokenType.LBRACE, List.of(ETokenType.LPAREN, ETokenType.LBRACK), List.of(ETokenType.RPAREN, ETokenType.RBRACK)));
    private static final RecognizerBase<EGenericParserStates> SKIP_AFTER_CLOSING_BRACE = RecognizerUtils.createRecognizer(start -> start.skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE));

    GoBraceSkipRecognizer() {
    }

    @Override
    protected int matchesLocally(ParserState<EGenericParserStates> parserState, List<IToken> tokens, int startOffset) {
        int closingMatch;
        int openingMatch = SKIP_TO_OPENING_BRACE.matches(parserState, tokens, startOffset);
        if (openingMatch == -1) {
            return -1;
        }
        if (openingMatch == 0) {
            return openingMatch;
        }
        do {
            IToken previousToken = tokens.get(openingMatch - 1);
            if (ETokenType.INTERFACE.or(new ITokenMatcher[]{ETokenType.STRUCT}).matches(previousToken)) {
                closingMatch = SKIP_AFTER_CLOSING_BRACE.matches(parserState, tokens, openingMatch + 1);
                if (closingMatch != -1) continue;
                return -1;
            }
            return openingMatch;
        } while ((openingMatch = SKIP_TO_OPENING_BRACE.matches(parserState, tokens, closingMatch)) != -1);
        return -1;
    }
}

