/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;

public class TokenStreamParser {
    private final List<IToken> tokens;
    private int currentToken = 0;

    public TokenStreamParser(List<IToken> tokens, Set<ETokenType> filteredTokens) {
        this(TokenStreamParser.filter(tokens, filteredTokens));
    }

    public TokenStreamParser(List<IToken> tokens) {
        this.tokens = tokens;
    }

    public TokenStreamParser(List<IToken> tokens, int startPosition) {
        TokenStreamParser.assertPositionAllowed(startPosition, tokens);
        this.tokens = tokens;
        this.currentToken = startPosition;
    }

    private static List<IToken> filter(List<IToken> tokens, Set<ETokenType> filteredTokens) {
        ArrayList<IToken> filtered = new ArrayList<IToken>();
        for (IToken token : tokens) {
            if (filteredTokens.contains(token.getType())) continue;
            filtered.add(token);
        }
        return filtered;
    }

    public List<IToken> consumeAnyOf(Set<ETokenType> matchTypes) {
        return this.consumeAnyOf(ITokenMatcher.anyOfType(matchTypes));
    }

    public List<IToken> consumeAnyOf(ITokenMatcher matcher) {
        int start = this.currentToken;
        while (!this.isDone() && matcher.matches(this.tokens.get(this.currentToken))) {
            ++this.currentToken;
        }
        return this.tokens.subList(start, this.currentToken);
    }

    public Optional<IToken> consumeOneOrZeroOf(Set<ETokenType> types) {
        if (this.isAnyOf(types)) {
            if (this.isDone()) {
                return Optional.empty();
            }
            IToken token = this.tokens.get(this.currentToken);
            ++this.currentToken;
            return Optional.of(token);
        }
        return Optional.empty();
    }

    public Optional<IToken> consumeOneOrZeroOf(ETokenType type) {
        return this.consumeOneOrZeroOf(EnumSet.of(type));
    }

    public List<String> consumeAnyExcept(Set<ETokenType> types) {
        ArrayList<String> texts = new ArrayList<String>();
        while (!this.isAnyOf(types) && this.currentType() != null) {
            texts.add(this.currentText());
            ++this.currentToken;
        }
        return texts;
    }

    public boolean skipToFirstTopLevel(Set<ETokenType> searchTypes, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        int firstTopLevelOccurrence = TokenStreamUtils.findFirstTopLevel(this.tokens, this.currentToken, ITokenMatcher.anyOfType(searchTypes), openingTypes, closingTypes);
        if (firstTopLevelOccurrence == -1) {
            return false;
        }
        this.currentToken = firstTopLevelOccurrence;
        return true;
    }

    public Pair<Boolean, List<IToken>> skipBalanced(ETokenType openingType, ETokenType closingType, Set<ETokenType> allowedInnerTypes) {
        CCSMAssert.isFalse((boolean)allowedInnerTypes.contains(openingType), (String)"The given inner token types contain the opening token type");
        CCSMAssert.isFalse((boolean)allowedInnerTypes.contains(closingType), (String)"The given inner token types contain the closing token type");
        if (this.currentType() != openingType) {
            return Pair.createPair((Object)false, Collections.emptyList());
        }
        ArrayList<IToken> consumedTokens = new ArrayList<IToken>();
        this.consumeOneOrZeroOf(EnumSet.of(openingType)).ifPresent(consumedTokens::add);
        int openCount = 1;
        while (openCount > 0) {
            consumedTokens.addAll(this.consumeAnyOf(allowedInnerTypes));
            Optional<IToken> consumed = this.consumeOneOrZeroOf(EnumSet.of(openingType));
            if (consumed.isPresent()) {
                ++openCount;
                consumedTokens.add(consumed.get());
                continue;
            }
            consumed = this.consumeOneOrZeroOf(EnumSet.of(closingType));
            if (consumed.isPresent()) {
                --openCount;
                consumedTokens.add(consumed.get());
                continue;
            }
            return Pair.createPair((Object)false, consumedTokens);
        }
        return Pair.createPair((Object)true, consumedTokens);
    }

    public Pair<Boolean, List<IToken>> skipBalancedParentheses() {
        return this.skipBalanced(ETokenType.LPAREN, ETokenType.RPAREN, EnumSet.complementOf(EnumSet.of(ETokenType.LPAREN, ETokenType.RPAREN)));
    }

    public Pair<Boolean, List<IToken>> skipBalancedAngleBrackets() {
        return this.skipBalanced(ETokenType.LT, ETokenType.GT, EnumSet.complementOf(EnumSet.of(ETokenType.LT, ETokenType.GT)));
    }

    public List<IToken> consumeAlternating(Set<ETokenType> typeSet1, Set<ETokenType> typeSet2) {
        Optional<IToken> token1;
        ArrayList<IToken> list = new ArrayList<IToken>();
        while (!(token1 = this.consumeOneOrZeroOf(typeSet1)).isEmpty()) {
            list.add(token1.get());
            Optional<IToken> token2 = this.consumeOneOrZeroOf(typeSet2);
            if (token2.isEmpty()) break;
            list.add(token2.get());
        }
        return list;
    }

    public boolean isAnyOf(Set<ETokenType> types) {
        return types.contains(this.currentType());
    }

    public boolean isDone() {
        return this.currentToken >= this.tokens.size();
    }

    public String currentText() {
        if (this.isDone()) {
            return null;
        }
        return this.tokens.get(this.currentToken).getText();
    }

    public ETokenType currentType() {
        if (this.isDone()) {
            return null;
        }
        return this.tokens.get(this.currentToken).getType();
    }

    public boolean continuesWithSequence(ETokenType ... tokenTypes) {
        List<IToken> nextTokens = this.tokens.subList(this.currentToken, this.tokens.size() - 1);
        return !this.isDone() && TokenStreamUtils.startsWith(nextTokens, tokenTypes);
    }

    public void skipToSequence(ETokenType ... tokenTypes) {
        int index = TokenStreamUtils.firstTokenOfTypeSequence(this.tokens, this.currentToken, tokenTypes);
        if (index != -1) {
            this.currentToken = index;
        } else {
            this.skipToEnd();
        }
    }

    public int getConsumedTokenCount() {
        return this.currentToken;
    }

    public void resetToPosition(int newPosition) {
        TokenStreamParser.assertPositionAllowed(newPosition, this.tokens);
        this.currentToken = newPosition;
    }

    private static void assertPositionAllowed(int index, List<IToken> tokens) throws AssertionError {
        CCSMAssert.isTrue((index >= 0 && index <= tokens.size() ? 1 : 0) != 0, (String)("The new position is out of range (position: " + index + " range: 0--" + (tokens.size() - 1)));
    }

    public String toString() {
        return "TokenStreamParser " + String.valueOf(this.tokens.subList(this.currentToken, this.tokens.size()));
    }

    public List<IToken> getTokens() {
        return this.tokens;
    }

    public <T> Optional<T> tryConsume(Function<TokenStreamParser, Optional<T>> consumer) {
        int parserPositionBefore = this.getConsumedTokenCount();
        Optional<T> result = consumer.apply(this);
        if (result.isEmpty()) {
            this.resetToPosition(parserPositionBefore);
        }
        return result;
    }

    public ELanguage getTokenLanguage() {
        return TokenStreamUtils.getLanguage(this.tokens);
    }

    private void skipToEnd() {
        this.currentToken = this.tokens.size();
    }

    public IToken currentToken() {
        if (this.isDone()) {
            return null;
        }
        return this.tokens.get(this.currentToken);
    }

    public boolean previousTokenTypeIs(ETokenType type) {
        if (this.currentToken == 0) {
            return false;
        }
        return this.tokens.get(this.currentToken - 1).getType() == type;
    }
}

