/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;

@IndexValueClass
public class SimulinkEnumeratedType
implements ISimulinkDataDictionaryEntry {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dataType;
    private final Map<String, String> enumerationNamesAndValues;
    private final String defaultItem;

    public SimulinkEnumeratedType(String name, String dataType, Map<String, String> enumerationNamesAndValues, String defaultItem) {
        this.name = name;
        this.dataType = dataType;
        this.enumerationNamesAndValues = enumerationNamesAndValues;
        this.defaultItem = defaultItem;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getEntryType() {
        return "Simulink.data.dictionary.EnumTypeDefinition";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getEntryType() + " " + this.name;
    }

    public String getDefaultItem() {
        return this.defaultItem;
    }

    public Set<String> getEnumerationItems() {
        return this.enumerationNamesAndValues.keySet();
    }

    public boolean hasItemValue(String value) {
        return this.enumerationNamesAndValues.containsKey(value);
    }
}

