/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.FlexiblePortPlacementParameters;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.EOrientation;
import org.conqat.lib.simulink.model.datahandler.ESimulinkBlockType;
import org.conqat.lib.simulink.model.datahandler.FontData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.conqat.lib.simulink.model.datahandler.PortLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkBlockLabelUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkPortLayoutUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class SimulinkPortLabelUtils {
    private static final String EN_DASH = "\u2013";
    private static final FontData PORT_LABEL_FONT_DATA = new FontData("SansSerif", 9, false, false);
    private static final int PORT_LABEL_ICON_WIDTH = 12;
    private static final Logger LOGGER = LogManager.getLogger();

    public static LabelLayoutData extractPortLabelData(SimulinkPortBase port) {
        ESimulinkBlockType blockType = SimulinkUtils.determineBlockType(port.getBlock());
        return blockType.getBlockPortLabels(port);
    }

    public static LabelLayoutData obtainFlipFlopPortData(SimulinkPortBase port, List<String> inPortOptions) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("Q", "!Q"));
        }
        return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, inPortOptions);
    }

    public static LabelLayoutData obtainBaceLowPassPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            if (port.getIndex().equals("2")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "state", Color.RED);
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "y");
        }
        String sourceType = port.getBlock().getSourceType();
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "k");
            }
            case "2": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            case "3": {
                if ("BACE LowPass (unsafe) external".equals(sourceType)) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "state", Color.RED);
                }
                if ("BACE LowPass_IV".equals(sourceType)) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "IV");
                }
                return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
            }
            case "4": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "R");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    public static LabelLayoutData obtainBaceLowPassConstPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "y");
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            case "2": {
                if (!"BACE LowPass with Constant Parameters  and initial value (safe)".equals(port.getBlock().getSourceType())) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "IV");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    public static LabelLayoutData obtainBaceHysteresisPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "B");
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "R", Color.BLUE);
            }
            case "2": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "L", Color.BLUE);
            }
            case "4": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
            }
        }
        return null;
    }

    public static LabelLayoutData obtainBaceFixedVariableDelayPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return null;
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "ln");
            }
            case "2": {
                if (!port.getBlock().getParameter("SourceType").contains("Variable")) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "n");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    public static LabelLayoutData obtainBaceTimerPortData(SimulinkPortBase port) {
        String label = SimulinkPortLabelUtils.getBaceCounterTimerPortLabel(port);
        if (label == null) {
            if (port.getIndex().equals("4")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "dt");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, label);
    }

    public static LabelLayoutData obtainBaceCounterPortData(SimulinkPortBase port) {
        String label = SimulinkPortLabelUtils.getBaceCounterTimerPortLabel(port);
        if (label == null) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, label);
    }

    public static String getBaceCounterTimerPortLabel(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return "out";
        }
        switch (port.getIndex()) {
            case "1": {
                return "Enable";
            }
            case "2": {
                return "Reset";
            }
            case "3": {
                return "IV";
            }
        }
        return null;
    }

    public static LabelLayoutData obtainDelayBlockPortData(SimulinkPortBase port) {
        if (port.getBlock().getInPorts().size() == 1 || port instanceof SimulinkOutPort) {
            return null;
        }
        String inputPortMap = port.getBlock().getParameter("InputPortMap");
        return SimulinkPortLabelUtils.retrieveDelayPortLabel(port, inputPortMap.split(",")[Integer.parseInt(port.getIndex()) - 1]);
    }

    public static LabelLayoutData retrieveDelayPortLabel(SimulinkPortBase port, String inputPortLabel) {
        switch (inputPortLabel) {
            case "u0": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            case "p1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "d");
            }
            case "p4": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "x0");
            }
            case "e6": {
                return SimulinkPortLabelUtils.positionPortImage(port, "enable_port_label.png");
            }
            case "r5": {
                return SimulinkPortLabelUtils.getExternalResetIcon(port);
            }
        }
        return null;
    }

    public static LabelLayoutData getExternalResetIcon(SimulinkPortBase port) {
        String resetParameter = port.getBlock().getParameter("ExternalReset");
        if (resetParameter == null) {
            return null;
        }
        return SimulinkPortLabelUtils.extractExternalResetIcon(resetParameter.toLowerCase(), port);
    }

    private static LabelLayoutData extractExternalResetIcon(String resetParameter, SimulinkPortBase port) {
        if (resetParameter == null) {
            return null;
        }
        switch (resetParameter) {
            case "rising": {
                return SimulinkPortLabelUtils.positionPortImage(port, "reset_rising.png");
            }
            case "falling": {
                return SimulinkPortLabelUtils.positionPortImage(port, "reset_falling.png");
            }
            case "either": {
                return SimulinkPortLabelUtils.positionPortImage(port, "reset_either.png");
            }
            case "level": {
                if (port.getBlock().isOfType("Delay") || port.getBlock().isOfType("DiscreteFilter") || port.getBlock().isOfType("DiscreteTransferFcn")) {
                    return SimulinkPortLabelUtils.positionPortImage(port, "reset_level_delay.png");
                }
                return SimulinkPortLabelUtils.positionPortImage(port, "reset_level.png");
            }
            case "level hold": {
                return SimulinkPortLabelUtils.positionPortImage(port, "reset_level_hold.png");
            }
        }
        return null;
    }

    public static LabelLayoutData obtainAssignmentPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "Y");
        }
        boolean inputInitialize = StringUtils.emptyIfNull((String)port.getBlock().getParameter("OutputInitialize")).contains("port");
        int index = Integer.parseInt(port.getIndex());
        if (index == 1) {
            if (inputInitialize) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Y0");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "U");
        }
        if (index == 2 && inputInitialize) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "U");
        }
        int subtractionValue = 2;
        if (inputInitialize) {
            subtractionValue = 3;
        }
        int base = 0;
        String indexMode = port.getBlock().getParameter("IndexMode");
        if ("One-based".equals(indexMode)) {
            base = 1;
        }
        int arrayIndex = index - subtractionValue;
        String indexOptions = port.getBlock().getParameter("PortIndices");
        String[] indexOptionsArray = indexOptions.split(" ");
        Object indexOnPort = "" + arrayIndex;
        if (arrayIndex < indexOptionsArray.length) {
            indexOnPort = indexOptionsArray[arrayIndex];
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "ldx" + (String)indexOnPort + "\n" + base);
    }

    public static LabelLayoutData obtainSelectorPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "Y");
        }
        int index = Integer.parseInt(port.getIndex());
        if (index == 1) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "U");
        }
        int subtractionValue = 2;
        int base = 0;
        String indexMode = port.getBlock().getParameter("IndexMode");
        if ("One-based".equals(indexMode)) {
            base = 1;
        }
        String indexOptions = port.getBlock().getParameter("PortIndices");
        String indexOnPort = indexOptions.split(" ")[index - subtractionValue];
        return SimulinkPortLabelUtils.positionPortLabel(port, "ldx" + indexOnPort + "\n" + base);
    }

    public static LabelLayoutData obtainDiscretePulseGeneratorPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "t");
        }
        return null;
    }

    public static LabelLayoutData obtainProductPortData(SimulinkPortBase port) {
        if (!(port instanceof SimulinkInPort)) {
            return null;
        }
        String inputs = port.getBlock().getParameter("Inputs");
        if (inputs == null) {
            return null;
        }
        try {
            Integer.parseInt(inputs);
        }
        catch (NumberFormatException e) {
            String multiplicationType = port.getBlock().getParameter("Multiplication");
            return SimulinkPortLabelUtils.getProductPortLabel(port, inputs, multiplicationType);
        }
        return null;
    }

    public static LabelLayoutData getProductPortLabel(SimulinkPortBase port, String inputs, String multiplicationType) {
        char c = inputs.charAt(Integer.parseInt(port.getIndex()) - 1);
        if ("Matrix(*)".equals(multiplicationType)) {
            if (c == '/') {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Inv");
            }
            return SimulinkPortLabelUtils.positionPortImage(port, "matrixprod_mult.png");
        }
        if (inputs.length() == 1 || !inputs.contains("/")) {
            return null;
        }
        if (c == '/') {
            return SimulinkPortLabelUtils.positionPortImage(port, "elementprod_divide.png");
        }
        return SimulinkPortLabelUtils.positionPortImage(port, "elementprod_mult.png");
    }

    public static LabelLayoutData obtainReshapePortData(SimulinkPortBase port) {
        String dimensionality = port.getBlock().getParameter("OutputDimensionality");
        if ("Derive from reference input port".equals(dimensionality)) {
            if (port instanceof SimulinkOutPort) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Y");
            }
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "U");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "Ref");
        }
        return null;
    }

    public static LabelLayoutData obtainRealImagToComplexPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort && "Real and imag".equals(port.getBlock().getParameter("Input"))) {
            return SimulinkPortLabelUtils.setRealImagPortData(port);
        }
        return null;
    }

    public static LabelLayoutData obtainComplexToRealImagPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort && "Real and imag".equals(port.getBlock().getParameter("Output"))) {
            return SimulinkPortLabelUtils.setRealImagPortData(port);
        }
        return null;
    }

    public static LabelLayoutData setRealImagPortData(SimulinkPortBase port) {
        if (port.getIndex().equals("1")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "Re");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "Im");
    }

    public static LabelLayoutData obtainSinPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "t");
        }
        return null;
    }

    public static LabelLayoutData obtainMinMaxResettablePortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "y");
        }
        if (port.getIndex().equals("1")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "u");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "R");
    }

    public static LabelLayoutData obtainAlgebraicConstraintPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "f(z)");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "z");
    }

    public static LabelLayoutData obtainPreLookupPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            if ("on".equals(port.getBlock().getParameter("OutputOnlyTheIndex"))) {
                return null;
            }
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "k");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "f");
        }
        if (!"Dialog".equals(port.getBlock().getParameter("BreakpointsDataSource"))) {
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "bp");
        }
        return null;
    }

    public static LabelLayoutData obtainLookupNDPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort && Integer.parseInt(port.getIndex()) == port.getBlock().getInPorts().size() && "on".equals(port.getBlock().getParameter("TableIsInput"))) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "T");
        }
        return null;
    }

    public static LabelLayoutData obtainWhileIteratorPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "cond");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "IC");
        }
        return null;
    }

    public static LabelLayoutData obtainForIteratorPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            String indexBase = port.getBlock().getParameter("IndexMode");
            if ("One-based".equals(indexBase)) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "1 : N ");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "0 : N-1 ");
        }
        String iterationSrc = port.getBlock().getParameter("IterationSource");
        if ("external".equals(iterationSrc) && port.getIndex().equals("1")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "N");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "Next_i");
    }

    public static LabelLayoutData obtainMultiPortSwitchPortData(SimulinkPortBase port) {
        int portIndex = Integer.parseInt(port.getIndex());
        if (port instanceof SimulinkOutPort || portIndex == 1) {
            return null;
        }
        String dataPortOrder = port.getBlock().getParameter("DataPortOrder");
        String portLabel = SimulinkPortLabelUtils.extractMultiPortSwitchPortLabelText(dataPortOrder, portIndex, port);
        if (StringUtils.isEmpty((String)portLabel)) {
            return null;
        }
        return SimulinkPortLabelUtils.extractMultiPortSwitchPortLabelLayout(portIndex, port, portLabel);
    }

    private static LabelLayoutData extractMultiPortSwitchPortLabelLayout(int portIndex, SimulinkPortBase port, String portLabelText) {
        LabelLayoutData portTextLabelLayout = portIndex == port.getBlock().getInPorts().size() && portIndex != 2 ? ("Additional data port".equals(port.getBlock().getParameter("DataPortForDefault")) ? SimulinkPortLabelUtils.positionPortLabel(port, "*") : SimulinkPortLabelUtils.positionPortLabel(port, "*, " + portLabelText)) : SimulinkPortLabelUtils.positionPortLabel(port, portLabelText);
        portTextLabelLayout.getPosition().y -= 10;
        return portTextLabelLayout;
    }

    private static String extractMultiPortSwitchPortLabelText(String dataPortOrder, int portIndex, SimulinkPortBase port) {
        if ("Zero-based contiguous".equals(dataPortOrder)) {
            return "" + (portIndex - 2);
        }
        if ("One-based contiguous".equals(dataPortOrder)) {
            return "" + (portIndex - 1);
        }
        String dataPortIndices = port.getBlock().getParameter("DataPortIndicesString");
        if (StringUtils.isEmpty((String)dataPortIndices)) {
            return "";
        }
        if (StringUtils.countCharacter((String)dataPortIndices, (char)',') != port.getBlock().getInPorts().size() - 1) {
            return "";
        }
        return dataPortIndices.split(",")[portIndex - 2].trim().replaceAll("\\s+", ", ");
    }

    public static LabelLayoutData obtainReferencePortData(SimulinkPortBase port) {
        String sourceType = port.getBlock().getParameter("SourceType");
        String sourceBlock = port.getBlock().getSourceBlockName();
        if (sourceType.contains("Unit Delay")) {
            return SimulinkPortLabelUtils.obtainUnitDelayBlocksPortData(port, sourceType);
        }
        if (sourceType.contains("TurnOnDelay") || sourceType.contains("TurnOffDelay")) {
            return SimulinkPortLabelUtils.obtainBaceTurnOnOffDelayPortData(port, sourceType);
        }
        if (sourceBlock.contains("Debounce")) {
            return SimulinkPortLabelUtils.obtainBaceDebouncePortData(port);
        }
        if (sourceBlock.contains("BACE_UnitDelay")) {
            return SimulinkPortLabelUtils.obtainBaceUnitDelayIndexPortData(port, sourceBlock);
        }
        if (sourceBlock.contains("BACE") && (sourceBlock.contains("Mapping") || sourceBlock.contains("Unmap"))) {
            return SimulinkPortLabelUtils.obtainBaceMappingUnmapPortData(port, sourceBlock);
        }
        if (sourceBlock.contains("putbit") || sourceBlock.contains("getbit") || sourceBlock.contains("setbit")) {
            return SimulinkPortLabelUtils.obtainBaceGetBitOrPutBitPortData(port, sourceBlock);
        }
        if (sourceBlock.contains("BACE") && (sourceBlock.contains("ArraySum") || sourceBlock.contains("ArrayMean"))) {
            return SimulinkPortLabelUtils.obtainBaceArraySumOrMeanPortData(port, sourceBlock);
        }
        if (sourceBlock.contains("BACE") && sourceBlock.contains("Integrator") && !sourceBlock.contains("BACE_DiscreteTimeIntegrator")) {
            return SimulinkPortLabelUtils.obtainBaceIntegratorPortData(port, sourceBlock);
        }
        if (sourceBlock.contains("BACE") && sourceType.contains("Data Type Propagation")) {
            return SimulinkPortLabelUtils.obtainDataTypePropagationPortData(port, sourceType);
        }
        if (sourceBlock.contains("BACE_PIDControl")) {
            return SimulinkPortLabelUtils.obtainBacePidControlPortData(port);
        }
        return SimulinkPortLabelUtils.obtainSimulinkReferencePortData(port);
    }

    public static @Nullable LabelLayoutData obtainSimulinkReferencePortData(SimulinkPortBase port) {
        SimulinkBlock referencedBlock = port.getBlock().resolveReferencedBlock().orElse(null);
        if (referencedBlock == null) {
            return null;
        }
        SimulinkPortBase referencedPort = referencedBlock.getInPort(port.getIndex());
        if (port instanceof SimulinkOutPort) {
            referencedPort = referencedBlock.getOutPort(port.getIndex());
        }
        if (referencedPort != null && referencedBlock.getType().equals("SubSystem")) {
            return SimulinkPortLabelUtils.obtainSubSystemPortLabelData(port, referencedPort);
        }
        if (referencedPort != null && port.getBlock().equals(referencedBlock)) {
            return null;
        }
        return SimulinkPortLabelUtils.obtainReferencedPortLabelData(port, SimulinkUtils.determineBlockType(referencedBlock));
    }

    public static LabelLayoutData obtainBaceMatlabFnPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "u");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "y");
    }

    private static LabelLayoutData obtainBacePidControlPortData(SimulinkPortBase port) {
        int portIndex = Integer.parseInt(port.getIndex());
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.obtainBacePidControlOutPortData(portIndex, port);
        }
        return SimulinkPortLabelUtils.obtainBacePidControlInPortData(portIndex, port);
    }

    private static LabelLayoutData obtainBacePidControlInPortData(int portIndex, SimulinkPortBase port) {
        switch (portIndex) {
            case 1: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "IN");
            }
            case 2: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "P", Color.RED);
            }
            case 3: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "I", Color.RED);
            }
            case 4: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "D", Color.RED);
            }
            case 5: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "I_min", Color.BLUE);
            }
            case 6: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "I_max", Color.BLUE);
            }
            case 7: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "OUT_min", Color.BLUE);
            }
            case 8: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "OUT_max", Color.BLUE);
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    private static LabelLayoutData obtainBacePidControlOutPortData(int portIndex, SimulinkPortBase port) {
        switch (portIndex) {
            case 1: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "OUT");
            }
            case 2: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "p", Color.RED);
            }
            case 3: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.RED);
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "d", Color.RED);
    }

    private static LabelLayoutData obtainBaceIntegratorPortData(SimulinkPortBase port, String sourceBlock) {
        boolean isStandardOrSimpleIntegrator;
        int portIndex = Integer.parseInt(port.getIndex());
        if (port instanceof SimulinkOutPort) {
            if (portIndex == 1) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "y");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "state", Color.RED);
        }
        boolean bl = isStandardOrSimpleIntegrator = sourceBlock.equals("BACE_Integrator_ASAM/Integrator_ASAM") || sourceBlock.equals("BACE_Simple_Integrator_ASAM/Simple_Integrator_ASAM");
        if (!isStandardOrSimpleIntegrator && portIndex >= 3) {
            portIndex += 2;
        }
        return SimulinkPortLabelUtils.obtainBaceIntegratorInPortData(port, portIndex, sourceBlock);
    }

    private static LabelLayoutData obtainBaceIntegratorInPortData(SimulinkPortBase port, int portIndex, String sourceBlock) {
        switch (portIndex) {
            case 1: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "MX");
            }
            case 2: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Mn");
            }
            case 3: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "IV");
            }
            case 4: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "R");
            }
            case 5: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "E");
            }
            case 6: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "K");
            }
            case 7: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            case 8: {
                return SimulinkPortLabelUtils.positionPortLabel(port, "dT");
            }
            case 9: {
                if (sourceBlock.equals("BACE_Integrator_ASAM_PAR_IV/Integrator_ASAM_PAR_IV")) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "R");
                }
                if (!sourceBlock.equals("BACE_Integrator_ASAM_ext/Integrator_ASAM_ext")) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "state", Color.RED);
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    public static LabelLayoutData obtainFixPointPortLabel(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            LabelLayoutData portLabel = SimulinkPortLabelUtils.positionPortLabel(port, "fp", Color.RED);
            portLabel.getPosition().translate(-3, -15);
            return portLabel;
        }
        return null;
    }

    private static LabelLayoutData obtainBaceArraySumOrMeanPortData(SimulinkPortBase port, String sourceBlock) {
        if (port instanceof SimulinkInPort) {
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Array");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "Width");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, sourceBlock.split("/")[1].split("Array")[1]);
    }

    private static LabelLayoutData obtainBaceGetBitOrPutBitPortData(SimulinkPortBase port, String sourceBlock) {
        if (port instanceof SimulinkInPort) {
            switch (port.getIndex()) {
                case "1": {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "in");
                }
                case "2": {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "pos", Color.RED);
                }
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "bed", Color.RED);
        }
        if (sourceBlock.contains("putbit") || sourceBlock.contains("setbit")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "out");
        }
        if ("off".equals(port.getBlock().getParameter("useMask"))) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "bed");
        }
        String text = port.getBlock().getParameter("bitIdxRange").substring(1, 4).replaceAll("\\s", "-");
        return SimulinkPortLabelUtils.positionPortLabel(port, "Out " + text);
    }

    public static LabelLayoutData obtainBaceBitShiftPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "input");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "shift", Color.RED);
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "output");
    }

    private static LabelLayoutData obtainBaceMappingUnmapPortData(SimulinkPortBase port, String sourceBlock) {
        String[] blockType = sourceBlock.split("/")[1].split("_");
        if (blockType[1].equals("Mapping")) {
            return SimulinkPortLabelUtils.extractBaceMappingUnmapPortLabels(port, SimulinkOutPort.class, blockType[0], "");
        }
        return SimulinkPortLabelUtils.extractBaceMappingUnmapPortLabels(port, SimulinkInPort.class, blockType[0], " In");
    }

    private static LabelLayoutData extractBaceMappingUnmapPortLabels(SimulinkPortBase port, Class<?> base, String uint, String in) {
        if (base.isAssignableFrom(port.getClass())) {
            return SimulinkPortLabelUtils.positionPortLabel(port, uint + in);
        }
        int index = Integer.parseInt(port.getIndex()) - 1;
        return SimulinkPortLabelUtils.positionPortLabel(port, "bit" + index);
    }

    public static LabelLayoutData obtainBaceUnitDelayIndexPortData(SimulinkPortBase port, String sourceBlock) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "y");
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            case "2": {
                if (!sourceBlock.contains("External")) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "IC");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "Index");
    }

    public static LabelLayoutData obtainBaceDebouncePortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "Outdbncsignal");
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Inrawsignal");
            }
            case "2": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Indbnccycles");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    public static LabelLayoutData obtainBaceMovingAveragePortData(SimulinkPortBase port, String sourceType) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "out");
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "in");
            }
            case "2": {
                if (!sourceType.contains("variable")) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "n");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    public static LabelLayoutData obtainBaceTurnOnOffDelayPortData(SimulinkPortBase port, String sourceType) {
        String index;
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "out_B");
        }
        switch (index = port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "T", Color.BLUE);
            }
            case "2": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "in_B");
            }
            case "3": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "dt");
            }
            case "4": {
                if (!sourceType.contains("Resettable")) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "Reset");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "i", Color.BLUE);
    }

    public static LabelLayoutData obtainDataTypePropagationPortData(SimulinkPortBase port, String sourceType) {
        if (port instanceof SimulinkInPort) {
            boolean isTwiceBitsBaceBlock;
            int portIndex = Integer.parseInt(port.getIndex());
            boolean bl = isTwiceBitsBaceBlock = sourceType.contains("3") || sourceType.contains("4");
            if (portIndex > 1 && isTwiceBitsBaceBlock) {
                ++portIndex;
            }
            switch (portIndex) {
                case 1: {
                    if (isTwiceBitsBaceBlock) {
                        return SimulinkPortLabelUtils.positionPortLabel(port, "Ref");
                    }
                    return SimulinkPortLabelUtils.positionPortLabel(port, "Ref1");
                }
                case 2: {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "Ref2");
                }
                case 3: {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "Prop");
                }
            }
            return null;
        }
        return null;
    }

    public static LabelLayoutData obtainConversionInheritedPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "y");
        }
        if (port.getIndex().equals("2")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "u");
        }
        return null;
    }

    public static LabelLayoutData obtainUnitDelayBlocksPortData(SimulinkPortBase port, String sourceType) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "y");
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            case "2": {
                if (sourceType.startsWith("Unit Delay Resettable")) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "R");
                }
                if (sourceType.startsWith("Unit Delay External")) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "IC");
                }
                return SimulinkPortLabelUtils.positionPortLabel(port, "E");
            }
            case "3": {
                if (!sourceType.endsWith("Resettable") && (!sourceType.endsWith("Initial Condition") || Integer.parseInt(port.getIndex()) >= port.getBlock().getInPorts().size())) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "R");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "IC");
    }

    public static LabelLayoutData obtainMuxPortData(SimulinkPortBase port) {
        if (!(port instanceof SimulinkInPort)) {
            return null;
        }
        String displayOption = port.getBlock().getParameter("DisplayOption");
        if ("signals".equals(displayOption)) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "signal" + port.getIndex());
        }
        return null;
    }

    public static LabelLayoutData obtainArithShiftPortData(SimulinkPortBase port) {
        if (!(port instanceof SimulinkInPort)) {
            return null;
        }
        if ("Input port".equals(port.getBlock().getParameter("BitShiftNumberSource"))) {
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "u");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "s");
        }
        return null;
    }

    public static LabelLayoutData obtainIntegratorPortData(SimulinkPortBase port) {
        String src;
        if (port.getIndex().equals("1") || !(port instanceof SimulinkInPort)) {
            return null;
        }
        if (Integer.parseInt(port.getIndex()) == port.getBlock().getInPorts().size() && "external".equals(src = port.getBlock().getParameter("InitialConditionSource"))) {
            return SimulinkPortLabelUtils.positionPortImage(port, "xo.png");
        }
        return SimulinkPortLabelUtils.getExternalResetIcon(port);
    }

    public static LabelLayoutData extractPortLabelForBlockPort(SimulinkPortBase port, List<String> portLabelOptions) {
        int portIndex = Integer.parseInt(port.getIndex()) - 1;
        return SimulinkPortLabelUtils.positionPortLabel(port, portLabelOptions.get(portIndex));
    }

    public static LabelLayoutData extractPortLabelForBlockPort(SimulinkPortBase port, List<String> inPortLabelOptions, List<String> outPortLabelOptions) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, outPortLabelOptions);
        }
        return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, inPortLabelOptions);
    }

    public static LabelLayoutData obtainSwitchCasePortLabelData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "u" + port.getIndex());
        }
        Object label = "default:";
        String caseConditions = port.getBlock().getParameter("ProcessedCaseConditions");
        caseConditions = caseConditions.replaceAll("[{}]", "");
        String[] caseParts = caseConditions.split(",");
        int index = Integer.parseInt(port.getIndex());
        if (index <= caseParts.length) {
            label = "case [ " + caseParts[index - 1].trim() + " ]:";
        }
        return SimulinkPortLabelUtils.positionOutPortLabelForSwitchCaseBlock(port, (String)label, port.getBlock().obtainBlockLayoutData().getPosition().width);
    }

    public static LabelLayoutData obtainIfPortLabelData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "u" + port.getIndex());
        }
        int index = Integer.parseInt(port.getIndex());
        Object label = "else";
        if (index == 1) {
            label = "if(" + port.getBlock().getParameter("IfExpression") + ")";
        } else {
            String[] elseIfs;
            String elseIfExpressions = port.getBlock().getParameter("ElseIfExpressions");
            if (elseIfExpressions != null && index - 2 < (elseIfs = elseIfExpressions.split(",")).length) {
                label = "elseif(" + elseIfs[index - 2] + ")";
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, (String)label);
    }

    public static LabelLayoutData obtainSubSystemPortLabelData(SimulinkPortBase port) {
        return SimulinkPortLabelUtils.obtainSubSystemPortLabelData(port, port);
    }

    public static LabelLayoutData obtainStringFindLabelData(SimulinkPortBase port) {
        String text = "";
        if (port instanceof SimulinkOutPort) {
            text = "idx";
        } else {
            int index = Integer.parseInt(port.getIndex());
            if (index == 1) {
                text = "str";
            } else if (index == 2) {
                text = "sub";
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, text);
    }

    public static LabelLayoutData obtainSubSystemPortLabelData(SimulinkPortBase layoutPort, SimulinkPortBase dataPort) {
        boolean isInport;
        String showPortLabels = layoutPort.getBlock().getParameter("ShowPortLabels");
        boolean visible = !"none".equals(showPortLabels);
        EOrientation orientation = layoutPort.getBlock().obtainBlockLayoutData().getOrientation();
        if (orientation.isRotated()) {
            visible = false;
        }
        if ((isInport = layoutPort instanceof SimulinkInPort) && layoutPort.isSpecialPort()) {
            return SimulinkPortLabelUtils.obtainSpecialPortLabel((SimulinkInPort)layoutPort, (SimulinkInPort)dataPort, orientation, !orientation.isRotated());
        }
        SimulinkBlock dataPortBlock = SimulinkPortLabelUtils.getSubsystemDataPortBlock(dataPort);
        SimulinkBlock portBlock = SimulinkPortLabelUtils.findPortBlock(dataPortBlock, dataPort.getIndex(), isInport);
        if (portBlock == null || portBlock.getName() == null) {
            return null;
        }
        String paramIconDisplay = portBlock.getParameter("IconDisplay");
        if ("FromPortIcon".equals(showPortLabels) && "off".equals(portBlock.getParameter("ShowName")) && "Port number".equals(paramIconDisplay)) {
            visible = false;
        }
        String text = SimulinkPortLabelUtils.obtainSubSystemPortLabelTextData(portBlock, layoutPort, dataPortBlock, showPortLabels, paramIconDisplay);
        return SimulinkPortLabelUtils.positionPortLabel(layoutPort, text, orientation, visible, null);
    }

    private static LabelLayoutData obtainReferencedPortLabelData(SimulinkPortBase referenceBlockPort, ESimulinkBlockType referencedBlockType) {
        return referencedBlockType.getBlockPortLabels(referenceBlockPort);
    }

    private static SimulinkBlock getSubsystemDataPortBlock(SimulinkPortBase dataPort) {
        String referencedSubsystem = dataPort.getBlock().getParameter("ReferencedSubsystem");
        if (referencedSubsystem == null) {
            return dataPort.getBlock();
        }
        Optional<SimulinkModel> sourceSubsystem = dataPort.getBlock().getModel().resolveModel(referencedSubsystem);
        if (!sourceSubsystem.isPresent()) {
            return dataPort.getBlock();
        }
        return sourceSubsystem.get();
    }

    private static String obtainSubSystemPortLabelTextData(SimulinkBlock portBlock, SimulinkPortBase layoutPort, SimulinkBlock dataPortBlock, String showPortLabels, String paramIconDisplay) {
        String portName = portBlock.getParameter("InterfaceData.PortName");
        String text = portName != null ? portName : (layoutPort.getFlexiblePortPlacementParameters().isPresent() ? SimulinkPortLabelUtils.determinePortLabelForFlexiblePortPlacement(portBlock, layoutPort) : portBlock.getName());
        String inputSignalName = SimulinkPortLabelUtils.getInputSignalNameFromPort(layoutPort, dataPortBlock).orElse(text);
        String innerInputSignalName = text;
        SimulinkPortBase blockPort = SimulinkBlockLabelUtils.getPort(portBlock);
        if (blockPort != null && blockPort.getSignalName().isPresent()) {
            innerInputSignalName = blockPort.getSignalName().get();
        }
        if ("FromPortIcon".equals(showPortLabels) && !"Port number".equals(paramIconDisplay)) {
            text = innerInputSignalName;
        } else if ("SignalName".equals(showPortLabels)) {
            text = !inputSignalName.equals(text) ? inputSignalName : innerInputSignalName;
            if (blockPort instanceof SimulinkInPort && !"1".equals(blockPort.getIndex())) {
                text = innerInputSignalName;
            }
        }
        return text.replaceAll("\\\\n", " ");
    }

    private static String determinePortLabelForFlexiblePortPlacement(SimulinkBlock portBlock, SimulinkPortBase layoutPort) {
        String portBlockName = portBlock.getName();
        if (portBlockName == null) {
            return layoutPort.getIndex();
        }
        if (SimulinkPortLabelUtils.subsystemPortBlockHasDefaultName(portBlockName, layoutPort instanceof SimulinkInPort)) {
            return layoutPort.getIndex();
        }
        return portBlockName;
    }

    private static boolean subsystemPortBlockHasDefaultName(String portBlockName, boolean isInport) {
        String portBlockNameWithoutTrailingNumber = StringUtils.stripTrailingDigits((String)portBlockName);
        if (isInport) {
            return "Inport".equals(portBlockNameWithoutTrailingNumber) || "In".equals(portBlockNameWithoutTrailingNumber);
        }
        return "Output".equals(portBlockNameWithoutTrailingNumber) || "Out".equals(portBlockNameWithoutTrailingNumber);
    }

    private static Optional<String> getInputSignalNameFromPort(SimulinkPortBase blockPort, SimulinkBlock dataPortBlock) {
        if (blockPort == null) {
            return Optional.empty();
        }
        if (blockPort instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.getInputSignalNameFromInPort((SimulinkInPort)blockPort);
        }
        if (blockPort instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.getInputSignalNameFromOutPort((SimulinkOutPort)blockPort, dataPortBlock);
        }
        return Optional.empty();
    }

    private static Optional<String> getInputSignalNameFromInPort(SimulinkInPort inPort) {
        if (inPort == null || inPort.getLine() == null) {
            return Optional.empty();
        }
        Optional<String> optionalInSignalName = inPort.getLine().getName();
        return optionalInSignalName.map(signalName -> "<" + signalName + ">");
    }

    private static Optional<String> getInputSignalNameFromOutPort(SimulinkOutPort outPort, SimulinkBlock dataPortBlock) {
        if (!outPort.getIndex().equals("1")) {
            return Optional.empty();
        }
        SimulinkInPort inPort = dataPortBlock.getInPort("1");
        return SimulinkPortLabelUtils.getInputSignalNameFromInPort(inPort);
    }

    public static LabelLayoutData obtainSpecialPortLabel(SimulinkInPort port, EOrientation orientation, boolean visible) {
        return SimulinkPortLabelUtils.obtainSpecialPortLabel(port, port, orientation, visible);
    }

    public static LabelLayoutData obtainSpecialPortLabel(SimulinkInPort layoutPort, SimulinkInPort dataPort, EOrientation orientation, boolean visible) {
        if (dataPort.isEnablePort()) {
            return SimulinkPortLabelUtils.positionPortImage(layoutPort, "enable_port_label.png");
        }
        if (dataPort.isResetPort()) {
            SimulinkBlock resetPortBlock = dataPort.getBlock().hasSubBlockOfType("ResetPort");
            if (resetPortBlock == null) {
                return null;
            }
            String resetPortIcon = SimulinkBlockLabelUtils.obtainResetPortBlockIcon(resetPortBlock);
            if (resetPortIcon != null) {
                return SimulinkPortLabelUtils.positionPortImage(layoutPort, resetPortIcon);
            }
            return null;
        }
        if (dataPort.isActionPort()) {
            String labelText = SimulinkPortLabelUtils.determineSpecialActionPortLabel(dataPort);
            return SimulinkPortLabelUtils.layoutSpecialPortLabel(layoutPort, labelText, orientation, visible);
        }
        if (dataPort.isTriggerPort()) {
            String labelText = SimulinkPortLabelUtils.determineTriggerPortLabel(dataPort);
            LabelLayoutData iconLabel = SimulinkPortLabelUtils.extractExternalResetIcon(labelText, layoutPort);
            if (iconLabel != null) {
                return iconLabel;
            }
            return SimulinkPortLabelUtils.layoutSpecialPortLabel(layoutPort, labelText, orientation, visible);
        }
        return null;
    }

    public static String determineSpecialActionPortLabel(SimulinkInPort port) {
        LabelLayoutData srcPort;
        if (port.getLine() != null && port.getLine().getSrcPort() != null && (srcPort = SimulinkPortLabelUtils.extractPortLabelData(port.getLine().getSrcPort())) != null && !srcPort.getText().toLowerCase().contains("out")) {
            return srcPort.getText().replaceAll(" *[\\[(].*[)\\]]", "") + " {}";
        }
        return "Action";
    }

    private static @NonNull String determineTriggerPortLabel(SimulinkInPort port) {
        SimulinkBlock triggerPortBlock = SimulinkPortLabelUtils.getSubsystemDataPortBlock(port).hasSubBlockOfType("TriggerPort");
        if (triggerPortBlock == null) {
            return "";
        }
        String procName = triggerPortBlock.getParameter("procName");
        if (procName != null) {
            return SimulinkUtils.replaceSimulinkLineBreaks(procName).trim() + "()";
        }
        String triggerType = triggerPortBlock.getParameter("TriggerType");
        if (triggerType == null) {
            return "";
        }
        if ("function-call".equals(triggerType)) {
            String functionName = triggerPortBlock.getName();
            if ("on".equals(triggerPortBlock.getParameter("IsSimulinkFunction")) && !StringUtils.isEmpty((String)triggerPortBlock.getParameter("FunctionName"))) {
                functionName = triggerPortBlock.getParameter("FunctionName");
            }
            return SimulinkUtils.replaceSimulinkLineBreaks(functionName).trim() + "()";
        }
        return triggerType;
    }

    public static LabelLayoutData layoutSpecialPortLabel(SimulinkInPort port, String text, EOrientation orientation, boolean visible) {
        Rectangle textBounds = LayoutHandlerBase.determineTextBounds(text, PORT_LABEL_FONT_DATA.getAwtFont());
        PortLayoutData portLayoutData = port.obtainLayoutData();
        Point position = new Point(portLayoutData.getPosition());
        position.x -= textBounds.width / 2;
        position.y = orientation == EOrientation.LEFT ? (position.y -= textBounds.height + 4) : (position.y += 4);
        return new LabelLayoutData(text, visible, PORT_LABEL_FONT_DATA, position, portLayoutData.getColor(), portLayoutData.getOpacity());
    }

    public static LabelLayoutData positionPortImage(SimulinkPortBase port, String imageFileIcon) {
        EOrientation orientation = EOrientation.getOrientationFromDirection(port.obtainLayoutData().getDirection());
        PortLayoutData portLayoutData = port.obtainLayoutData();
        Point position = new Point(portLayoutData.getPosition());
        if (orientation == EOrientation.RIGHT || orientation == EOrientation.LEFT) {
            position.y -= 4;
            position.x = SimulinkPortLabelUtils.adjustPortImagePosition(port, orientation, EOrientation.LEFT, position.x);
        } else {
            position.x -= 4;
            position.y = SimulinkPortLabelUtils.adjustPortImagePosition(port, orientation, EOrientation.UP, position.y);
        }
        return new LabelLayoutData("", imageFileIcon, PORT_LABEL_FONT_DATA, position, portLayoutData.getColor(), portLayoutData.getOpacity(), !orientation.isRotated());
    }

    private static int adjustPortImagePosition(SimulinkPortBase port, EOrientation portOrientation, EOrientation comparableOrientation, int coordinate) {
        coordinate = port instanceof SimulinkInPort ^ portOrientation == comparableOrientation ? (coordinate += 4) : (coordinate -= 16);
        return coordinate;
    }

    public static LabelLayoutData positionPortLabel(SimulinkPortBase port, String string) {
        EOrientation orientation;
        return SimulinkPortLabelUtils.positionPortLabel(port, string, orientation, !(orientation = port.getBlock().obtainBlockLayoutData().getOrientation()).isRotated(), null);
    }

    public static LabelLayoutData positionPortLabel(SimulinkPortBase port, String string, Color color) {
        EOrientation orientation;
        return SimulinkPortLabelUtils.positionPortLabel(port, string, orientation, !(orientation = port.getBlock().obtainBlockLayoutData().getOrientation()).isRotated(), color);
    }

    public static LabelLayoutData positionPortLabel(SimulinkPortBase port, String text, EOrientation blockOrientation, boolean visible, Color color) {
        Optional<FlexiblePortPlacementParameters> flexiblePortPlacementParameters;
        Rectangle textBounds = LayoutHandlerBase.determineTextBounds(text, PORT_LABEL_FONT_DATA.getAwtFont());
        PortLayoutData portLayoutData = port.obtainLayoutData();
        if (color == null) {
            color = portLayoutData.getColor();
        }
        if ((flexiblePortPlacementParameters = port.getFlexiblePortPlacementParameters()).isPresent()) {
            FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName adjustedSide = SimulinkPortLayoutUtils.adjustToBlockRotation(flexiblePortPlacementParameters.get().side, blockOrientation);
            Point labelPosition = SimulinkPortLabelUtils.computePortLabelPositionForFlexiblePortPlacement(textBounds, adjustedSide, portLayoutData.getPosition());
            return new LabelLayoutData(text, visible, PORT_LABEL_FONT_DATA, labelPosition, color, portLayoutData.getOpacity());
        }
        Point position = new Point(portLayoutData.getPosition());
        BlockLayoutData blockLayoutData = port.getBlock().obtainBlockLayoutData();
        if (!SimulinkUtils.isRoundSum(port.getBlock())) {
            SimulinkPortLabelUtils.modifyPortLabelPositionIfOutsideBlock(position, blockLayoutData, textBounds);
        }
        position.y -= textBounds.height / 2;
        position.x = port instanceof SimulinkInPort ^ blockOrientation == EOrientation.LEFT ? (position.x += 4) : (position.x -= 4 + textBounds.width);
        return new LabelLayoutData(text, visible, PORT_LABEL_FONT_DATA, position, color, portLayoutData.getOpacity());
    }

    private static void modifyPortLabelPositionIfOutsideBlock(Point position, BlockLayoutData blockLayoutData, Rectangle textBounds) {
        int halfTextHeight = textBounds.height / 2;
        if ((double)(position.y - halfTextHeight) <= blockLayoutData.getPosition().getY()) {
            position.y = (int)blockLayoutData.getPosition().getY() + halfTextHeight;
        } else if ((double)(position.y + halfTextHeight) >= blockLayoutData.getPosition().getMaxY()) {
            position.y = (int)blockLayoutData.getPosition().getMaxY() - halfTextHeight;
        }
    }

    private static @NonNull Point computePortLabelPositionForFlexiblePortPlacement(Rectangle textBounds, FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName adjustedPortSide, Point portPosition) {
        int x = 0;
        switch (adjustedPortSide) {
            case TOP: 
            case BOTTOM: {
                x = portPosition.x - (int)(textBounds.getWidth() / 2.0);
                break;
            }
            case LEFT: {
                x = portPosition.x + 4;
                break;
            }
            case RIGHT: {
                x = portPosition.x - 4 - (int)textBounds.getWidth();
                break;
            }
            default: {
                LOGGER.warn("Unknown EFlexiblePortPlacementSideName " + String.valueOf((Object)adjustedPortSide));
            }
        }
        int y = 0;
        switch (adjustedPortSide) {
            case TOP: {
                y = portPosition.y + 4;
                break;
            }
            case BOTTOM: {
                y = portPosition.y - 4 - textBounds.height;
                break;
            }
            case LEFT: 
            case RIGHT: {
                y = portPosition.y - textBounds.height / 2;
                break;
            }
            default: {
                LOGGER.warn("Unknown EFlexiblePortPlacementSideName " + String.valueOf((Object)adjustedPortSide));
            }
        }
        return new Point(x, y);
    }

    public static LabelLayoutData positionOutPortLabelForSwitchCaseBlock(SimulinkPortBase port, String text, int blockWidth) {
        EOrientation orientation = port.getBlock().obtainBlockLayoutData().getOrientation();
        if (LayoutHandlerBase.getTextWidth(text, PORT_LABEL_FONT_DATA.getAwtFont()) > (double)blockWidth * 0.65) {
            Matcher matcher = Pattern.compile("(\\[\\s[^\\s]+\\s[^\\s]+\\s)(.+)(\\s\\])").matcher(text);
            StringBuffer portLabelBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(portLabelBuffer, matcher.group(1) + "..." + matcher.group(3));
            }
            matcher.appendTail(portLabelBuffer);
            text = portLabelBuffer.toString();
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, text, orientation, !orientation.isRotated(), null);
    }

    private static SimulinkBlock findPortBlock(SimulinkBlock parent, String index, boolean inPort) {
        if (!inPort) {
            return SimulinkUtils.findOutPortBlock(parent, index).orElse(null);
        }
        List<SimulinkBlock> inports = SimulinkUtils.findInPortBlocks(parent, index);
        if (inports.isEmpty()) {
            return null;
        }
        return inports.get(0);
    }

    public static LabelLayoutData obtainRectangularSumInPortLabelData(SimulinkPortBase port) {
        if (!(port instanceof SimulinkInPort)) {
            return null;
        }
        return SimulinkPortLabelUtils.obtainSumInPortLabelData(port);
    }

    public static LabelLayoutData obtainSumInPortLabelData(SimulinkPortBase port) {
        int index;
        int logicalIndex;
        if (!(port instanceof SimulinkInPort)) {
            return null;
        }
        PortLayoutData portLayoutData = port.obtainLayoutData();
        String portsDescription = SimulinkPortLayoutUtils.getSumInputPortsDescription(port.getBlock());
        String text = Character.toString(portsDescription.charAt(logicalIndex = SimulinkPortLayoutUtils.computeLogicalIndexForSumBlockPort(portsDescription, index = Integer.parseInt(port.getIndex()))));
        if ("-".equals(text)) {
            text = EN_DASH;
        }
        BlockLayoutData blockLayoutData = port.getBlock().obtainBlockLayoutData();
        Point position = SimulinkPortLayoutUtils.getInsetPortPoint(port, blockLayoutData, -5);
        Rectangle textBounds = LayoutHandlerBase.determineTextBounds(text, PORT_LABEL_FONT_DATA.getAwtFont());
        if (!SimulinkUtils.isRoundSum(port.getBlock())) {
            SimulinkPortLabelUtils.modifyPortLabelPositionIfOutsideBlock(position, blockLayoutData, textBounds);
        }
        position.y -= textBounds.height / 2;
        position.x -= textBounds.width / 2;
        return new LabelLayoutData(text, true, PORT_LABEL_FONT_DATA, position, portLayoutData.getColor(), portLayoutData.getOpacity());
    }

    public static LabelLayoutData obtainBmwFunctionCallGeneratorPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return null;
        }
        String state = port.getBlock().getParameter("state");
        if ("on".equals(state)) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "state");
        }
        String nkw = port.getBlock().getParameter("nkw");
        if ("on".equals(nkw)) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "nkw");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "bace_fcall_generator");
    }

    public static LabelLayoutData obtainFunctionCallSplitPortLabelData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort && port.getIndex().equals("1")) {
            return SimulinkPortLabelUtils.positionPortImage(port, "fn_call_split.png");
        }
        return null;
    }

    public static LabelLayoutData obtainBusAssignmentPortData(SimulinkPortBase port) {
        int portIndex = Integer.parseInt(port.getIndex());
        if (portIndex == 1) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "Bus");
        }
        String[] assignedSignals = port.getBlock().getParameter("AssignedSignals").split(",");
        return SimulinkPortLabelUtils.positionPortLabel(port, ":= " + assignedSignals[portIndex - 2]);
    }

    public static LabelLayoutData obtainBaceEdgePortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort && port.getIndex().equals("2")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "i");
        }
        return null;
    }

    public static LabelLayoutData obtainBaceIfThenPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "if_B");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "Then");
        }
        return null;
    }

    public static LabelLayoutData obtainBaceSafeFloatComparePortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "real");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "B");
    }

    public static LabelLayoutData obtainBaceArrayMinMaxPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            if (port.getIndex().equals("1")) {
                return SimulinkPortLabelUtils.positionPortLabel(port, "Array");
            }
            return SimulinkPortLabelUtils.positionPortLabel(port, "Width");
        }
        if (port.getBlock().getOutPorts().size() > 1 && port.getIndex().equals("1")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "Index");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "Value");
    }

    public static LabelLayoutData obtainDiscreteFilterPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return null;
        }
        int portIndex = Integer.parseInt(port.getIndex());
        String numeratorSource = port.getBlock().getParameter("NumeratorSource");
        String denominatorSource = port.getBlock().getParameter("DenominatorSource");
        String initialStatesSource = port.getBlock().getParameter("InitialStatesSource");
        boolean initialStateInputSource = "Input port".equals(initialStatesSource);
        if (portIndex == port.getBlock().getInPorts().size() && initialStateInputSource) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "x0");
        }
        boolean denominatorInputSource = "Input port".equals(denominatorSource);
        boolean numeratorInputSource = "Input port".equals(numeratorSource);
        return SimulinkPortLabelUtils.obtainDiscreteFilterPortData(port, portIndex, numeratorInputSource, denominatorInputSource, initialStateInputSource);
    }

    private static LabelLayoutData obtainDiscreteFilterPortData(SimulinkPortBase port, int portIndex, boolean numeratorInputSource, boolean denominatorInputSource, boolean initialStateInputSource) {
        switch (portIndex) {
            case 1: {
                if (numeratorInputSource || denominatorInputSource || initialStateInputSource) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "u");
                }
                return null;
            }
            case 2: {
                if (numeratorInputSource) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "Num");
                }
                if (denominatorInputSource) {
                    return SimulinkPortLabelUtils.positionPortLabel(port, "Den");
                }
            }
            case 3: {
                if (!denominatorInputSource || !numeratorInputSource) break;
                return SimulinkPortLabelUtils.positionPortLabel(port, "Den");
            }
        }
        return SimulinkPortLabelUtils.getExternalResetIcon(port);
    }

    public static LabelLayoutData obtainDiscreteFirPortData(SimulinkPortBase port) {
        String coefficientSource = port.getBlock().getParameter("CoefSource");
        if (!"Input port".equals(coefficientSource)) {
            return null;
        }
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "Out");
        }
        if (port.getIndex().equals("1")) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "In");
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "Num");
    }

    public static LabelLayoutData obtainFunctionCallerPortData(SimulinkPortBase port) {
        int portIndex = Integer.parseInt(port.getIndex()) - 1;
        String parameterName = "FunctionOutput";
        if (port instanceof SimulinkInPort) {
            parameterName = "FunctionInput";
        }
        String[] portLabels = port.getBlock().getParameter(parameterName).split(",");
        return SimulinkPortLabelUtils.positionPortLabel(port, portLabels[portIndex]);
    }

    public static LabelLayoutData obtainLookupTableDynamicPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "y");
        }
        switch (port.getIndex()) {
            case "1": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "x");
            }
            case "2": {
                return SimulinkPortLabelUtils.positionPortLabel(port, "xdat");
            }
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, "ydat");
    }

    public static LabelLayoutData obtainVariantSourcePortData(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLabelUtils.getVariantControlDataForPort(port);
        }
        return null;
    }

    public static LabelLayoutData obtainVariantSinkPortData(SimulinkPortBase port) {
        if (port instanceof SimulinkOutPort) {
            return SimulinkPortLabelUtils.getVariantControlDataForPort(port);
        }
        return null;
    }

    private static LabelLayoutData getVariantControlDataForPort(SimulinkPortBase port) {
        SimulinkBlock variantBlock = port.getBlock();
        String variantControlsMxArrayFileName = variantBlock.getParameter("VariantControls");
        if (variantControlsMxArrayFileName == null) {
            return null;
        }
        String variantControlsArray = variantBlock.getModel().getParameter(variantControlsMxArrayFileName);
        if (variantControlsArray == null) {
            return null;
        }
        String[] portVariants = variantControlsArray.split("@");
        int portIndex = Integer.parseInt(port.getIndex()) - 1;
        if (portIndex >= portVariants.length) {
            return null;
        }
        return SimulinkPortLabelUtils.positionPortLabel(port, portVariants[portIndex]);
    }

    private SimulinkPortLabelUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

