/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.RectangleLayoutData;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.ui.SimulinkUiDataBase;
import org.conqat.lib.simulink.util.StateflowUtils;

public class StateflowNodeUiData
extends SimulinkUiDataBase {
    private static final String NODES_PROPERTY = "nodes";
    private static final String LAYOUT_DATA_PROPERTY = "layoutData";
    private static final String LABEL_DATA_PROPERTY = "labelData";
    private static final String TYPE_PROPERTY = "type";
    private static final String SUB_CHART_ID_PROPERTY = "subchartId";
    private static final String ATOMIC_PROPERTY = "atomic";
    @JsonProperty(value="layoutData")
    private final RectangleLayoutData layoutData;
    @JsonProperty(value="labelData")
    private final LabelLayoutData labelData;
    @JsonProperty(value="nodes")
    private final @Nullable List<StateflowNodeUiData> nodes;
    @JsonProperty(value="type")
    private final ENodeType type;
    @JsonProperty(value="subchartId")
    private @Nullable String subchartId = null;
    @JsonProperty(value="atomic")
    private boolean atomic = false;

    @JsonCreator
    public StateflowNodeUiData(@JsonProperty(value="name") String name, @JsonProperty(value="qualifiedName") String qualifiedName, @JsonProperty(value="layoutData") RectangleLayoutData layoutData, @JsonProperty(value="labelData") LabelLayoutData labelData, @JsonProperty(value="nodes") @Nullable List<StateflowNodeUiData> nodes, @JsonProperty(value="type") ENodeType type, @JsonProperty(value="atomic") boolean atomic) {
        super(name, qualifiedName);
        this.layoutData = layoutData;
        this.labelData = labelData;
        this.nodes = nodes;
        this.type = type;
        this.atomic = atomic;
    }

    public StateflowNodeUiData(StateflowNodeBase node) {
        this(node, node.buildQualifiedName());
    }

    public StateflowNodeUiData(StateflowNodeBase node, String specialQualifiedName) {
        super(StringUtils.getLastPart((String)specialQualifiedName, (char)'/'), specialQualifiedName);
        this.layoutData = node.obtainLayoutData();
        if (node instanceof StateflowState) {
            this.labelData = ((StateflowState)node).obtainLabelData();
            this.nodes = CollectionUtils.map(((StateflowState)node).getNodes(), StateflowNodeUiData::new);
            StateflowState state = (StateflowState)node;
            this.type = state.isNoteBox() ? ENodeType.NOTE_BOX : (state.isGroupState() ? ENodeType.GROUP_STATE : (state.isFunctionState() ? ENodeType.FUNCTION_STATE : ENodeType.PLAIN));
            this.atomic = state.isAtomicSubChart();
            if (state.isSubChart()) {
                this.subchartId = state.buildQualifiedName();
            }
            if (state.isSimulinkFunction() || state.isActionSubsystemState()) {
                this.subchartId = StateflowUtils.skipSubviewerParentCharts(state.getParentChart()).getStateflowBlock().getSubBlock(state.getParameter("simulink.blockName")).getId();
            }
        } else {
            this.labelData = null;
            this.nodes = null;
            this.type = ENodeType.JUNCTION;
        }
    }

    public LabelLayoutData getLabelData() {
        return this.labelData;
    }

    public RectangleLayoutData getLayoutData() {
        return this.layoutData;
    }

    public @Nullable List<StateflowNodeUiData> getNodes() {
        return this.nodes;
    }

    public ENodeType getType() {
        return this.type;
    }

    public @Nullable String getSubchartId() {
        return this.subchartId;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    @ExportToTypeScript
    public static enum ENodeType {
        JUNCTION,
        NOTE_BOX,
        GROUP_STATE,
        FUNCTION_STATE,
        PLAIN;

    }
}

