/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-invalid-message-type", languages={ELanguage.ABAP})
public class InvalidMessageTypeCheck
extends CheckImplementationBase {
    private static final Set<String> ALLOWED_TYPES = Set.of("'A'", "'E'", "'I'", "'S'", "'W'", "'X'");

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List entities = this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED);
        List messages = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)entities, Set.of(EShallowEntityType.STATEMENT), Set.of("message"));
        for (ShallowEntity message : messages) {
            this.processEntity(message);
        }
    }

    private void processEntity(ShallowEntity message) {
        UnmodifiableList messageTokens = message.includedTokens();
        int typeTokenIndex = TokenStreamUtils.firstTokenMatching((List)messageTokens, (ITokenMatcher)ETokenType.TYPE);
        int displayLikeTokenIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)messageTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DISPLAY, ETokenType.LIKE});
        if (typeTokenIndex != -1 && messageTokens.size() > typeTokenIndex + 1 && this.surroundedBySingleQuotes(((IToken)messageTokens.get(typeTokenIndex + 1)).getText()) && !ALLOWED_TYPES.contains(((IToken)messageTokens.get(typeTokenIndex + 1)).getText())) {
            this.createFinding((IToken)messageTokens.get(typeTokenIndex));
        }
        if (displayLikeTokenIndex != -1 && messageTokens.size() > typeTokenIndex + 2 && this.surroundedBySingleQuotes(((IToken)messageTokens.get(displayLikeTokenIndex + 2)).getText()) && !ALLOWED_TYPES.contains(((IToken)messageTokens.get(displayLikeTokenIndex + 2)).getText())) {
            this.createFinding((IToken)messageTokens.get(displayLikeTokenIndex));
        }
    }

    private void createFinding(IToken tokenIndex) {
        this.buildFinding("Invalid message type", this.buildLocation().forToken(tokenIndex)).createAndStore();
    }

    private boolean surroundedBySingleQuotes(String text) {
        if (text.length() < 2) {
            return false;
        }
        return text.charAt(0) == text.charAt(text.length() - 1) && text.charAt(0) == '\'';
    }
}

