/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class MissingCheckOfSySubrcCheckBase
extends CheckImplementationBase {
    private static final Set<String> CONDITIONAL_SUBTYPES_FOR_SY_SUBRC_CHECK = CollectionUtils.asHashSet((Object[])new String[]{"if", "check", "case"});
    private static final Set<String> SUBTYPES_IF_ELSEIF_ELSE = CollectionUtils.asHashSet((Object[])new String[]{"if", "elseif", "else"});
    private static final Set<String> SY_SUBRC_FIELD_NAMES = Set.of("sy-subrc", "syst-subrc");
    private static final Set<String> SUBTYPES_ELSEIF_ELSE = CollectionUtils.asHashSet((Object[])new String[]{"elseif", "else"});

    protected void processEntity(ShallowEntity entity) throws CheckException {
        if (!this.isEntityToCheck(entity)) {
            return;
        }
        if (MissingCheckOfSySubrcCheckBase.containsSySubrc(ShallowEntityTraversalUtils.getSubsequentEntity((ShallowEntity)entity))) {
            return;
        }
        if (MissingCheckOfSySubrcCheckBase.statementAfterConditionalOrCaseContainsSySubrc(entity)) {
            return;
        }
        this.buildFinding(this.getFindingsMessage(entity), this.buildLocation().forEntity(entity)).createAndStore();
    }

    private static boolean statementAfterConditionalOrCaseContainsSySubrc(ShallowEntity entity) {
        ShallowEntity outerConditionalStatement;
        if (MissingCheckOfSySubrcCheckBase.isInsideConditionalStatement(entity) && (outerConditionalStatement = entity.getParent()) != null && MissingCheckOfSySubrcCheckBase.containsSySubrc(MissingCheckOfSySubrcCheckBase.getStatementAfterConditional(outerConditionalStatement))) {
            return true;
        }
        if (MissingCheckOfSySubrcCheckBase.isInsideCaseStatement(entity)) {
            Optional outerCaseStatement = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, startEntity -> startEntity.getType() == EShallowEntityType.STATEMENT && startEntity.getSubtype().equals("case"));
            return outerCaseStatement.isPresent() && MissingCheckOfSySubrcCheckBase.containsSySubrc(ShallowEntityTraversalUtils.getSubsequentEntity((ShallowEntity)((ShallowEntity)outerCaseStatement.get())));
        }
        return false;
    }

    private static boolean isInsideConditionalStatement(ShallowEntity entity) {
        if (entity.getParent() == null || entity.getParent().getParent() == null) {
            return false;
        }
        return EShallowEntityType.STATEMENT == entity.getParent().getType() && SUBTYPES_IF_ELSEIF_ELSE.contains(entity.getParent().getSubtype());
    }

    private static ShallowEntity getStatementAfterConditional(ShallowEntity outerConditional) {
        UnmodifiableList conditionalNeighbours = Objects.requireNonNull(outerConditional.getParent()).getChildren();
        int indexOfConditionalInNeighbours = conditionalNeighbours.indexOf((Object)outerConditional);
        if (indexOfConditionalInNeighbours < 0) {
            return null;
        }
        for (int i = indexOfConditionalInNeighbours + 1; i < conditionalNeighbours.size(); ++i) {
            ShallowEntity current = (ShallowEntity)conditionalNeighbours.get(i);
            if (SUBTYPES_ELSEIF_ELSE.contains(current.getSubtype())) continue;
            return current;
        }
        return null;
    }

    private static boolean isInsideCaseStatement(ShallowEntity entity) {
        if (entity.getParent() == null) {
            return false;
        }
        Optional parent = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, startEntity -> startEntity.getType() == EShallowEntityType.STATEMENT && startEntity.getSubtype().equals("case"));
        return parent.isPresent();
    }

    protected abstract String getFindingsMessage(ShallowEntity var1);

    protected boolean isEntityToCheck(ShallowEntity entity) throws CheckException {
        return true;
    }

    static boolean isConditionalOnSySubrc(ShallowEntity entity) {
        return MissingCheckOfSySubrcCheckBase.containsSySubrc(entity) && CONDITIONAL_SUBTYPES_FOR_SY_SUBRC_CHECK.contains(entity.getSubtype());
    }

    private static boolean containsSySubrc(ShallowEntity entity) {
        return entity != null && entity.getType() == EShallowEntityType.STATEMENT && CollectionUtils.anyMatch((Collection)entity.ownStartTokens(), MissingCheckOfSySubrcCheckBase::isSySubrcToken);
    }

    private static boolean isSySubrcToken(IToken token) {
        return token.getType() == ETokenType.IDENTIFIER && SY_SUBRC_FIELD_NAMES.contains(LanguageFeatureParser.ABAP.normalizeVariable(token.getText()));
    }
}

