/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import java.util.Collection;
import java.util.List;

public abstract class CLikeMethodParameterCountCheckBase
extends CheckImplementationBase {
    public static final String CHECK_BASE_NAME = "Methods should not have too many parameters";
    private static final String FINDING_MESSAGE = "Method `%s` has %s parameters but no more than %s parameters are allowed";
    protected static final int MAXIMUM_NUMBER_OF_ALLOWED_PARAMETERS_DEFAULT_VALUE = 7;

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity methodEntity) {
        if (this.isDerivedMethod(methodEntity)) {
            return;
        }
        int parameterCount = this.countMethodParameters(methodEntity);
        if (parameterCount > this.getMaximumAllowedParameterCount()) {
            String message = String.format(FINDING_MESSAGE, methodEntity.getName(), parameterCount, this.getMaximumAllowedParameterCount());
            FindingPropertyList findingProperties = FindingPropertyList.singleton((String)"Number of parameters", (String)String.valueOf(parameterCount));
            this.buildFinding(message, this.buildLocation().forEntityFirstLine(methodEntity, ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).addFindingProperties(findingProperties).createAndStore();
        }
    }

    private int countMethodParameters(ShallowEntity methodEntity) {
        ELanguage methodLanguage = this.determineMethodLanguage(methodEntity);
        ITypeInfoExtractor typeInfoExtractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)methodLanguage, null);
        return typeInfoExtractor.extract(methodEntity).size();
    }

    protected ELanguage determineMethodLanguage(ShallowEntity methodEntity) {
        return this.context.getLanguage();
    }

    protected abstract int getMaximumAllowedParameterCount();

    protected abstract boolean isDerivedMethod(ShallowEntity var1);
}

