/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike.misra.control_flow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-goto-other-blocks-or-backwards", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class GotoOtherBlocksOrBackwardsCheck
extends CheckImplementationBase {
    private static final String CS_CASE_LABEL_PREFIX = "case ";

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            List<ShallowEntity> labels = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singletonList(method), (EShallowEntityType)EShallowEntityType.META).stream().filter(entity -> "label".equals(entity.getSubtype()) || this.isCsSwitchLabel((ShallowEntity)entity)).filter(entity -> !ShallowParsingUtils.locatedInAnonymousClassOrLambda((ShallowEntity)entity)).toList();
            List<ShallowEntity> gotoStatements = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singletonList(method), (EShallowEntityType)EShallowEntityType.STATEMENT).stream().filter(statement -> "goto".equals(statement.getName())).filter(statement -> !ShallowParsingUtils.locatedInAnonymousClassOrLambda((ShallowEntity)statement)).toList();
            for (ShallowEntity statement2 : gotoStatements) {
                this.checkGotoStatement(statement2, labels);
            }
        }
    }

    private boolean isCsSwitchLabel(ShallowEntity metaEntity) {
        return this.context.getLanguage() == ELanguage.CS && "case".equals(metaEntity.getSubtype());
    }

    private void checkGotoStatement(ShallowEntity gotoStatement, List<ShallowEntity> labels) {
        Optional<String> optionalLabelName = this.determineTargetLabelName(gotoStatement);
        if (optionalLabelName.isEmpty()) {
            this.buildFinding("Missing label at `goto`", this.buildLocation().forEntityFirstLine(gotoStatement)).createAndStore();
            return;
        }
        String labelName = optionalLabelName.get();
        List<ShallowEntity> foundLabels = this.filterLabelsWithName(labels, labelName);
        if (CollectionUtils.isNullOrEmpty(foundLabels)) {
            this.buildFinding("Label " + MarkupUtils.formatAsSourceCode((String)labelName) + " should be in `goto` scope", this.buildLocation().forEntityFirstLine(gotoStatement)).createAndStore();
            return;
        }
        if (foundLabels.size() > 1) {
            this.buildFinding("Multiple " + MarkupUtils.formatAsSourceCode((String)labelName) + " labels for goto in scope", this.buildLocation().forEntityFirstLine(gotoStatement)).createAndStore();
            return;
        }
        ShallowEntity targetLabel = foundLabels.get(0);
        if (gotoStatement.getStartOffset() > targetLabel.getStartOffset()) {
            this.buildFinding(MarkupUtils.formatAsSourceCode((String)labelName) + " should not jump backwards", this.buildLocation().forEntityFirstLine(gotoStatement)).createAndStore();
            return;
        }
        this.checkForJumpsIntoBlocks(gotoStatement, targetLabel, labelName);
    }

    private Optional<String> determineTargetLabelName(ShallowEntity gotoStatement) {
        UnmodifiableList includedTokens = gotoStatement.includedTokens();
        if (this.context.getLanguage() == ELanguage.CS && TokenStreamUtils.startsWith((List)includedTokens, (ETokenType[])new ETokenType[]{ETokenType.GOTO, ETokenType.CASE}) && includedTokens.size() == 4) {
            return Optional.of(CS_CASE_LABEL_PREFIX + ((IToken)includedTokens.get(2)).getText());
        }
        if (TokenStreamUtils.tokensBetween((List)includedTokens, (ETokenType)ETokenType.GOTO, (ETokenType)ETokenType.SEMICOLON).isEmpty()) {
            return Optional.empty();
        }
        int gotoKeywordIndex = TokenStreamUtils.firstTokenMatching((List)includedTokens, (ITokenMatcher)ETokenType.GOTO);
        String labelName = ((IToken)includedTokens.get(gotoKeywordIndex + 1)).getText();
        return Optional.of(labelName);
    }

    private List<ShallowEntity> filterLabelsWithName(List<ShallowEntity> labels, String labelName) {
        if (this.context.getLanguage() == ELanguage.CS && labelName.startsWith(CS_CASE_LABEL_PREFIX)) {
            String caseName = labelName.substring(CS_CASE_LABEL_PREFIX.length());
            return CollectionUtils.filter(labels, label -> label.getSubtype().equals("case") && caseName.equals(label.getName()));
        }
        return CollectionUtils.filter(labels, label -> labelName.equals(label.getName()));
    }

    private void checkForJumpsIntoBlocks(ShallowEntity gotoStatement, ShallowEntity targetLabel, String labelName) {
        ShallowEntity currentEntity = gotoStatement;
        while (currentEntity.getParent() != null) {
            currentEntity = currentEntity.getParent();
            if (targetLabel.getParent() != currentEntity) continue;
            return;
        }
        this.buildFinding(MarkupUtils.formatAsSourceCode((String)labelName) + " should not jump into block", this.buildLocation().forEntityFirstLine(gotoStatement)).createAndStore();
    }
}

