/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.base.TopLevelTypeCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.io.File;
import java.util.List;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Check(id="cqse-cpp-top-level-class-name", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CppTopLevelClassNameCheck
extends TopLevelTypeCheckBase {
    protected boolean isTopLevelType(ShallowEntity typeEntity) {
        return LanguageFeatureParser.CPP.isTopLevelClass(typeEntity);
    }

    protected void analyzeTopLevelTypes(List<ShallowEntity> topLevelTypeEntities) {
        String fileName = FileSystemUtils.getFilenameWithoutExtension((File)new File(this.context.getUniformPath()));
        for (ShallowEntity entity : topLevelTypeEntities) {
            if (fileName.equals(entity.getName())) continue;
            this.buildFinding("Class name `" + entity.getName() + "` does not match file name `" + fileName + "`", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

