/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-destructor-must-be-no-except", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DestructorMustBeNoExceptCheck
extends CheckImplementationBase {
    private static final TokenPattern NOEXCEPT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.NOEXCEPT}).optional(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.BOOLEAN_LITERAL}).group(0).sequence(new Object[]{ETokenType.RPAREN})}).optional(new Object[]{ETokenType.OVERRIDE}).optional(new Object[]{ETokenType.EQ, ETokenType.DEFAULT}).sequence(new Object[]{ETokenType.SEMICOLON});

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (method.getParent() == null || method.getParent().getType() != EShallowEntityType.TYPE || !"destructor declaration".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) {
        String findingMessage = "Destructor `" + entity.getName() + "` should be declared as `noexcept`";
        UnmodifiableList tokens = entity.ownStartTokens();
        TokenPatternMatch match = NOEXCEPT_PATTERN.findFirstMatch((List)tokens);
        if (match == null) {
            this.buildFinding(findingMessage, this.buildLocation().forEntity(entity)).createAndStore();
        } else {
            List matchTexts = match.groupTexts(0);
            if (!matchTexts.isEmpty() && ((String)matchTexts.get(0)).equalsIgnoreCase(ETokenType.FALSE.name())) {
                this.buildFinding(findingMessage, this.buildLocation().forEntity(entity)).createAndStore();
            }
        }
    }
}

