/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-exception-usage", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ExceptionUsageCheck
extends CheckImplementationBase {
    private static final Set<ETokenType> FORBIDDEN_TOKENS = EnumSet.of(ETokenType.THROW, ETokenType.TRY);

    public void execute() throws CheckException {
        this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED).stream().filter(t -> FORBIDDEN_TOKENS.contains(t.getType())).forEach(t -> this.buildFinding("Usage of exception handling keyword " + MarkupUtils.formatAsSourceCode((String)t.getText()), this.buildLocation().forToken(t)).createAndStore());
    }
}

