/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CppLanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-c-style-cast", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoCStyleCastCheck
extends CheckImplementationBase {
    private static final Pattern C_STYLE_CAST_PATTERN = Pattern.compile("(^|[^a-zA-Z0-9>])\\(" + String.valueOf(CppLanguageFeatureParser.VALID_IDENTIFIER_PATTERN) + "\\*?\\)\\(?(" + String.valueOf(CppLanguageFeatureParser.VALID_IDENTIFIER_PATTERN) + ")\\)?");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TokenStreamUtils.containsAny((List)statement.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.IDENTIFIER})) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (NoCStyleCastCheck.containsCStyleCast(entity)) {
            this.buildFinding("Avoid using c-style casts", this.buildLocation().forLine(entity.getStartLine())).createAndStore();
        }
    }

    private static boolean containsCStyleCast(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        return C_STYLE_CAST_PATTERN.matcher(TokenStreamTextUtils.concatTokenTexts((List)tokens)).find();
    }
}

