/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.binary_size;

import eu.cqse.check.cpp.binary_size.MacroExpansionOriginAndSize;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.PreprocessorMacroExpansionTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.cpp.BinarySizeCheckUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

public class MacroExpansionsOriginPhase
implements IGlobalExtractionPhase<MacroExpansionOriginAndSizeExtractable, MacroExpansionOriginAndSize> {
    public List<MacroExpansionOriginAndSizeExtractable> extract(ITokenElementContext context) throws CheckException {
        ArrayList<MacroExpansionOriginAndSizeExtractable> result = new ArrayList<MacroExpansionOriginAndSizeExtractable>();
        List expansions = context.getPreprocessorExpansions();
        for (PreprocessorTokenReplacement expansion : expansions) {
            PreprocessorMacroExpansionTokenReplacement macroExpansionTokenReplacement;
            if (!(expansion instanceof PreprocessorMacroExpansionTokenReplacement) || MacroExpansionsOriginPhase.needToIgnoreMacroExpansion(macroExpansionTokenReplacement = (PreprocessorMacroExpansionTokenReplacement)expansion, context)) continue;
            int macroDefinitionLineNumber = macroExpansionTokenReplacement.macroDefinitionLineNumber;
            List fileTokens = context.getTokens(ECodeViewOption.FILTERED);
            IToken firstReplacedToken = (IToken)fileTokens.get(expansion.originalTokensStartIndex);
            String macroName = firstReplacedToken.getText();
            int expansionTokenSize = macroExpansionTokenReplacement.getReplacementTokens().size();
            int operationsCount = MacroExpansionsOriginPhase.countOperationsInExpansion(expansion);
            String macroDefinitionUniformPath = macroExpansionTokenReplacement.macroDefinitionUniformPath;
            result.add(new MacroExpansionOriginAndSizeExtractable(new MacroExpansionOriginAndSize(macroDefinitionUniformPath, macroDefinitionLineNumber, macroName, context.getUniformPath(), expansionTokenSize, operationsCount)));
        }
        return result;
    }

    private static int countOperationsInExpansion(PreprocessorTokenReplacement expansion) {
        UnmodifiableList expansionTokens = expansion.getReplacementTokens();
        int operationsCount = 0;
        block4: for (int i = 0; i < expansionTokens.size(); ++i) {
            switch (((IToken)expansionTokens.get(i)).getType()) {
                case LPAREN: {
                    if (i <= 1 || ((IToken)expansionTokens.get(i - 1)).getType() != ETokenType.IDENTIFIER) continue block4;
                    ++operationsCount;
                    continue block4;
                }
                case EQ: 
                case ANDAND: 
                case OROR: 
                case PLUSPLUS: 
                case MINUSMINUS: 
                case PLUS: 
                case MINUS: 
                case MULT: 
                case DIV: 
                case AND: 
                case OR: 
                case XOR: 
                case MOD: 
                case LSHIFT: 
                case EQEQ: 
                case GT: 
                case LT: 
                case NOT: 
                case LTEQ: 
                case GTEQ: 
                case NOTEQ: 
                case COMP: 
                case QUESTION: 
                case PLUSEQ: 
                case MINUSEQ: 
                case MULTEQ: 
                case DIVEQ: 
                case ANDEQ: 
                case OREQ: 
                case XOREQ: 
                case MODEQ: 
                case LSHIFTEQ: 
                case RSHIFTEQ: {
                    ++operationsCount;
                    continue block4;
                }
            }
        }
        return operationsCount;
    }

    private static boolean needToIgnoreMacroExpansion(PreprocessorMacroExpansionTokenReplacement macroExpansionTokenReplacement, ITokenElementContext context) throws CheckException {
        int expansionTokenSize = macroExpansionTokenReplacement.getReplacementTokens().size();
        if (expansionTokenSize == 0) {
            return true;
        }
        if (expansionTokenSize == 1) {
            return true;
        }
        String macroDefinitionUniformPath = macroExpansionTokenReplacement.macroDefinitionUniformPath;
        if (macroDefinitionUniformPath.startsWith("/")) {
            return true;
        }
        if (MacroExpansionsOriginPhase.expansionInitializesClassStructEnumField(macroExpansionTokenReplacement, context)) {
            return true;
        }
        return MacroExpansionsOriginPhase.expansionContainsOnlyLiteralsAndOperators(macroExpansionTokenReplacement);
    }

    private static boolean expansionContainsOnlyLiteralsAndOperators(PreprocessorMacroExpansionTokenReplacement macroExpansionTokenReplacement) {
        return macroExpansionTokenReplacement.getReplacementTokens().stream().allMatch(token -> switch (token.getType().getTokenClass()) {
            case ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.COMMENT, ETokenType.ETokenClass.WHITESPACE, ETokenType.ETokenClass.DELIMITER -> true;
            case ETokenType.ETokenClass.SPECIAL, ETokenType.ETokenClass.KEYWORD, ETokenType.ETokenClass.IDENTIFIER -> BinarySizeCheckUtils.isSupportedType((String)token.getText());
            default -> false;
        });
    }

    private static boolean expansionInitializesClassStructEnumField(PreprocessorMacroExpansionTokenReplacement macroExpansionTokenReplacement, ITokenElementContext context) throws CheckException {
        ShallowEntity previousSibling;
        int firstReplacedTokenIndex = macroExpansionTokenReplacement.originalTokensStartIndex;
        IToken unpreprocessedMacroNameToken = (IToken)context.getTokens(ECodeViewOption.FILTERED).get(firstReplacedTokenIndex);
        List preprocessedTokens = context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        int indexInPreprocessedTokens = TokenStreamUtils.indexOfByOffset((List)preprocessedTokens, (int)unpreprocessedMacroNameToken.getOffset());
        if (indexInPreprocessedTokens < 1 || ((IToken)preprocessedTokens.get(indexInPreprocessedTokens - 1)).getType() != ETokenType.EQ) {
            return false;
        }
        IToken firstTokenOfExpansion = (IToken)preprocessedTokens.get(indexInPreprocessedTokens);
        Optional containingShallowEntity = ShallowEntityTraversalUtils.findContainingEntityDepthFirst((IToken)firstTokenOfExpansion, (List)context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED));
        if (containingShallowEntity.isEmpty()) {
            return false;
        }
        if (((ShallowEntity)containingShallowEntity.get()).getType() == EShallowEntityType.ATTRIBUTE && Objects.equals(((ShallowEntity)containingShallowEntity.get()).getSubtype(), "global variable") && (previousSibling = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)((ShallowEntity)containingShallowEntity.get()))) != null && previousSibling.getType() == EShallowEntityType.TYPE && Objects.equals(previousSibling.getSubtype(), "struct")) {
            return true;
        }
        ShallowEntity parentEntity = ((ShallowEntity)containingShallowEntity.get()).getParent();
        if (parentEntity == null) {
            return false;
        }
        return Objects.equals(parentEntity.getSubtype(), "enum") || Objects.equals(parentEntity.getSubtype(), "class");
    }

    public MacroExpansionOriginAndSizeExtractable createValue(String uniformPath, String value, MacroExpansionOriginAndSize additionalInformation) {
        return new MacroExpansionOriginAndSizeExtractable(additionalInformation);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    public EnumSet<ELanguage> getLanguages() {
        return CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES;
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.PREPROCESSOR_EXPANSIONS, ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    @IndexValueClass
    public static class MacroExpansionOriginAndSizeExtractable
    implements IExtractedValue<MacroExpansionOriginAndSize> {
        private final MacroExpansionOriginAndSize info;

        public MacroExpansionOriginAndSizeExtractable(MacroExpansionOriginAndSize info) {
            this.info = info;
        }

        public MacroExpansionOriginAndSize getAdditionalInformation() {
            return this.info;
        }

        public String getUniformPath() {
            return this.info.expansionLocationUniformPath();
        }

        public String getValue() {
            return this.info.macroDefinitionUniformPath();
        }
    }
}

