/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.preprocessor;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Check(id="cqse-macro-argument-with-directives", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MacroArgumentWithDirectivesCheck
extends CheckImplementationBase {
    private static final Pattern MACRO_MATCHING_PATTERN = Pattern.compile("#\\s*define\\s+(\\w+)\\(.*", 2);

    public void execute() throws CheckException {
        List fileTokens = this.context.getTokens(ECodeViewOption.FILTERED);
        Set<String> macrosWithParameters = MacroArgumentWithDirectivesCheck.findMacrosWithParameters(fileTokens);
        Iterator iterator = TokenStreamUtils.allStartingIndicesOfTypeSequence((List)fileTokens, (int)0, (int)fileTokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).iterator();
        while (iterator.hasNext()) {
            int foundIndex;
            int closingIndex;
            int identifierIndex = (Integer)iterator.next();
            if (!macrosWithParameters.contains(((IToken)fileTokens.get(identifierIndex)).getText()) || (closingIndex = TokenStreamUtils.findMatchingClosingToken((List)fileTokens, (int)(identifierIndex + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) == -1 || (foundIndex = TokenStreamUtils.firstTokenMatching((List)fileTokens, (int)identifierIndex, (int)closingIndex, (ITokenMatcher)ETokenType.PREPROCESSOR_DIRECTIVE)) == -1) continue;
            this.buildFinding("Token `" + ((IToken)fileTokens.get(foundIndex)).getText() + "` in macro argument looks like preprocessor directive", this.buildLocation().betweenLines(((IToken)fileTokens.get(identifierIndex)).getLineNumber(), ((IToken)fileTokens.get(closingIndex)).getLineNumber())).createAndStore();
        }
    }

    private static Set<String> findMacrosWithParameters(List<IToken> fileTokens) {
        HashSet<String> macroNames = new HashSet<String>();
        for (IToken preprocessorDirectiveToken : TokenStreamUtils.findAllTokens(fileTokens, (ITokenMatcher)ETokenType.PREPROCESSOR_DIRECTIVE)) {
            String directiveText = preprocessorDirectiveToken.getText();
            Matcher matcher = MACRO_MATCHING_PATTERN.matcher(directiveText = directiveText.replaceAll("\\\\\n", " "));
            if (!matcher.find()) continue;
            macroNames.add(matcher.group(1));
        }
        return macroNames;
    }
}

