/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeBuilder;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformationFactory;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-nonsensical-binary-operations", languages={ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.PYTHON, ELanguage.KOTLIN}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NonsensicalBinaryOperationsCheck
extends CheckImplementationBase {
    private static final Set<ETokenType> POSSIBLY_NONSENSICAL_SELF_OPERATIONS = Set.of(ETokenType.AND, ETokenType.OR, ETokenType.XOR, ETokenType.MINUS, ETokenType.DIV, ETokenType.MOD);
    private static final Set<ETokenType> POSSIBLY_NONSENSICAL_SELF_OPERATOR_ASSIGNMENTS = Set.of(ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.MINUSEQ, ETokenType.DIVEQ, ETokenType.MODEQ);
    private static final Set<ETokenType> POSSIBLY_NONSENSICAL_ZERO_OPERATIONS = Set.of(ETokenType.AND, ETokenType.OR, ETokenType.XOR, ETokenType.MINUS);
    private static final Set<ETokenType> POSSIBLY_NONSENSICAL_ZERO_OPERATOR_ASSIGNMENTS = Set.of(ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.MINUSEQ);
    private static final String ZERO_STRING_REPRESENTATION = "0";
    private static final Set<ETokenType> OPENING_TYPES = Set.of(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK);
    private final Set<Integer> findingLocations = new HashSet<Integer>();
    @CheckOption(name="Include operations on expression", description="When enabled, operations on expressions are included in the check for nonsensical binary operations. When disabled only operations on single variables are included.")
    private boolean includeExpressions = true;

    public void execute() throws CheckException {
        this.findingLocations.clear();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        if (LanguageFeatureParser.CPP.containsMacroExpandedContent(entity)) {
            return;
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        List<Integer> variableOperations = this.getNonsensicalSelfOperationIndices((List<IToken>)tokens);
        for (int i : variableOperations) {
            this.createFindingForIndex((List<IToken>)tokens, i, true);
        }
        List<Integer> zeroLiteralOperations = this.getNonsensicalZeroLiteralOperationIndices((List<IToken>)tokens);
        for (int i : zeroLiteralOperations) {
            this.createFindingForIndex((List<IToken>)tokens, i, false);
        }
        this.processAssignmentOperator((List<IToken>)tokens);
        if (this.includeExpressions) {
            this.processExpressions((List<IToken>)tokens);
        }
    }

    private void processAssignmentOperator(List<IToken> tokens) {
        if (tokens.size() > 4 || tokens.size() < 3 || tokens.get(0).getType() != ETokenType.IDENTIFIER || !POSSIBLY_NONSENSICAL_ZERO_OPERATOR_ASSIGNMENTS.contains(tokens.get(1).getType()) && !POSSIBLY_NONSENSICAL_SELF_OPERATOR_ASSIGNMENTS.contains(tokens.get(1).getType()) || this.shouldBeIgnored(1, tokens)) {
            return;
        }
        if (POSSIBLY_NONSENSICAL_SELF_OPERATOR_ASSIGNMENTS.contains(tokens.get(1).getType()) && tokens.get(2).getType() == ETokenType.IDENTIFIER && tokens.get(0).getText().equals(tokens.get(2).getText())) {
            this.createFindingForIndex(tokens, 1, true);
        }
        if (POSSIBLY_NONSENSICAL_ZERO_OPERATOR_ASSIGNMENTS.contains(tokens.get(1).getType()) && (ZERO_STRING_REPRESENTATION.equals(tokens.get(2).getText()) || ZERO_STRING_REPRESENTATION.equals(tokens.get(0).getText())) && !this.shouldBeIgnored(1, tokens)) {
            this.createFindingForIndex(tokens, 1, true);
        }
    }

    private List<Integer> getNonsensicalSelfOperationIndices(List<IToken> tokens) {
        List<Integer> variableOperations = TokenStreamUtils.firstTokenOfClassOrTypeSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.IDENTIFIER});
        variableOperations = variableOperations.stream().filter(i -> ((IToken)tokens.get((int)i)).getText().equals(((IToken)tokens.get(i + 2)).getText())).map(i -> i + 1).filter(i -> POSSIBLY_NONSENSICAL_SELF_OPERATIONS.contains(((IToken)tokens.get((int)i)).getType())).toList();
        return this.filterByPrecedence(variableOperations, tokens, true);
    }

    private List<Integer> getNonsensicalZeroLiteralOperationIndices(List<IToken> tokens) {
        List<Integer> literalOperations = TokenStreamUtils.firstTokenOfClassOrTypeSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.LITERAL});
        literalOperations.addAll(TokenStreamUtils.firstTokenOfClassOrTypeSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.IDENTIFIER}));
        literalOperations.addAll(TokenStreamUtils.firstTokenOfClassOrTypeSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.RPAREN, ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.LITERAL}));
        literalOperations.addAll(TokenStreamUtils.firstTokenOfClassOrTypeSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.OPERATOR, ETokenType.LPAREN}));
        literalOperations = literalOperations.stream().filter(i -> ((IToken)tokens.get((int)i)).getText().equals(ZERO_STRING_REPRESENTATION) || ((IToken)tokens.get(i + 2)).getText().equals(ZERO_STRING_REPRESENTATION)).map(i -> i + 1).filter(i -> POSSIBLY_NONSENSICAL_ZERO_OPERATIONS.contains(((IToken)tokens.get((int)i)).getType()) && !this.shouldBeIgnored((int)i, tokens)).toList();
        return this.filterByPrecedence(literalOperations, tokens, false);
    }

    private void processExpressions(List<IToken> tokens) {
        if (!IOperatorInformationFactory.isLanguageSupported((ELanguage)this.context.getLanguage())) {
            return;
        }
        if (tokens.stream().noneMatch(token -> token.getType().getTokenClass() == ETokenType.ETokenClass.OPERATOR)) {
            return;
        }
        IOperatorInformation operatorInformation = IOperatorInformationFactory.getDefaultOperatorInformation((ELanguage)this.context.getLanguage());
        ExpressionTreeNode root = ExpressionTreeBuilder.buildExpressionTree(tokens, (IOperatorInformation)operatorInformation, (boolean)true, (boolean)true, (boolean)false);
        ArrayList<ExpressionTreeNode> toVisit = new ArrayList<ExpressionTreeNode>();
        toVisit.add(root);
        while (!toVisit.isEmpty()) {
            ArrayList newNodes = new ArrayList();
            for (ExpressionTreeNode node : toVisit) {
                if (node.getChildren().isEmpty()) continue;
                if (node.isOperator() && POSSIBLY_NONSENSICAL_SELF_OPERATIONS.contains(node.getOperator()) && (node.getChildren().size() == 2 && ((ExpressionTreeNode)node.getChildren().get(0)).equals(node.getChildren().get(1)) && !TokenStreamTextUtils.concatTokenTexts((List)((ExpressionTreeNode)node.getChildren().get(1)).getExpression()).equals(ZERO_STRING_REPRESENTATION) || operatorInformation.isCommutative(node.getOperator()) && new HashSet(node.getChildren()).size() < node.getChildren().size())) {
                    this.createFindingForExpression(node.getExpression());
                    continue;
                }
                newNodes.addAll(node.getChildren());
            }
            toVisit = newNodes;
        }
    }

    private List<Integer> filterByPrecedence(List<Integer> operatorIndices, List<IToken> tokens, boolean noAttribute) {
        return operatorIndices.stream().filter(i -> !(i - 2 >= 0 && (NonsensicalBinaryOperationsCheck.precedence((IToken)tokens.get((int)i)) <= NonsensicalBinaryOperationsCheck.precedence((IToken)tokens.get(i - 2)) || noAttribute && NonsensicalBinaryOperationsCheck.isAttributeIndication(i - 2, tokens)) || i + 2 < tokens.size() && (NonsensicalBinaryOperationsCheck.precedence((IToken)tokens.get((int)i)) <= NonsensicalBinaryOperationsCheck.precedence((IToken)tokens.get(i + 2)) || OPENING_TYPES.contains(((IToken)tokens.get(i + 2)).getType()) || noAttribute && NonsensicalBinaryOperationsCheck.isAttributeIndication(i + 2, tokens)) || this.shouldBeIgnored((int)i, tokens))).toList();
    }

    private boolean shouldBeIgnored(int index, List<IToken> tokens) {
        if (index < 0 || index >= tokens.size()) {
            return true;
        }
        IToken operator = tokens.get(index);
        if (this.context.getLanguage() == ELanguage.PYTHON) {
            return operator.getType() == ETokenType.AND && operator.getText().equalsIgnoreCase("and") || operator.getType() == ETokenType.OR && operator.getText().equalsIgnoreCase("or");
        }
        if (index - 1 >= 0 && tokens.get(index - 1).getType().isLiteral() && ZERO_STRING_REPRESENTATION.equals(tokens.get(index - 1).getText())) {
            return this.shouldLeadingZeroOperatorBeIgnored(operator.getType());
        }
        if (index + 1 < tokens.size() && tokens.get(index + 1).getType().isLiteral() && ZERO_STRING_REPRESENTATION.equals(tokens.get(index + 1).getText())) {
            return this.shouldTrailingZeroOperatorBeIgnored(operator.getType());
        }
        return false;
    }

    private boolean shouldLeadingZeroOperatorBeIgnored(ETokenType type) {
        if (this.context.getLanguage() == ELanguage.CPP || this.context.getLanguage() == ELanguage.CPP_MS_CLI || this.context.getLanguage() == ELanguage.CS) {
            return type == ETokenType.MINUS;
        }
        return false;
    }

    private boolean shouldTrailingZeroOperatorBeIgnored(ETokenType type) {
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return type == ETokenType.OR || type == ETokenType.OREQ;
        }
        return false;
    }

    private static boolean isAttributeIndication(int index, List<IToken> tokens) {
        return tokens.get(index).getType() == ETokenType.DOT || tokens.get(index).getType() == ETokenType.POINTERTO || tokens.get(index).getType() == ETokenType.SCOPE;
    }

    private static int precedence(IToken operatorToken) {
        ETokenType type = operatorToken.getType();
        return switch (type) {
            case ETokenType.OR -> 1;
            case ETokenType.XOR -> 2;
            case ETokenType.AND -> 3;
            case ETokenType.EQEQ, ETokenType.EQEQEQ, ETokenType.NOTEQEQ, ETokenType.NOTEQ, ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ -> 4;
            case ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT -> 5;
            case ETokenType.PLUS, ETokenType.MINUS -> 6;
            case ETokenType.MULT, ETokenType.DIV, ETokenType.MOD -> 7;
            case ETokenType.NOT, ETokenType.COMP, ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.IN, ETokenType.POWER, ETokenType.BIT_NOT -> 10;
            default -> -1;
        };
    }

    private void createFindingForIndex(List<IToken> tokens, int index, boolean selfOperation) {
        if (index <= 0 || index >= tokens.size() - 1) {
            return;
        }
        StringBuilder message = new StringBuilder();
        if (selfOperation) {
            message.append("Nonsensical operation on a variable and itself (");
        } else {
            message.append("Nonsensical operation (");
        }
        NonsensicalBinaryOperationsCheck.appendExpression(tokens, index, message);
        message.append(") has a constant result");
        Optional location = this.buildLocation().forTokens(tokens.subList(index - 1, index + 1));
        if (this.includeExpressions && location.isPresent()) {
            this.findingLocations.add(((TextRegionLocation)location.get()).getRawStartOffset());
        }
        this.buildFinding(message.toString(), location).createAndStore();
    }

    private static void appendExpression(List<IToken> tokens, int index, StringBuilder message) {
        if (tokens.get(index - 1).getType() == ETokenType.RPAREN) {
            int openingParentheses = TokenStreamUtils.findMatchingOpeningToken(tokens, (int)(index - 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (openingParentheses == -1) {
                return;
            }
            message.append(StringUtils.concat((Iterable)TokenStreamTextUtils.getTokenTexts(tokens, (int)openingParentheses, (int)index), (String)""));
        } else {
            message.append(tokens.get(index - 1).getText());
        }
        message.append(tokens.get(index).getText());
        if (tokens.get(index + 1).getType() == ETokenType.LPAREN) {
            int closingParentheses = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(index + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (closingParentheses == -1) {
                return;
            }
            message.append(StringUtils.concat((Iterable)TokenStreamTextUtils.getTokenTexts(tokens, (int)index, (int)closingParentheses), (String)""));
        } else {
            message.append(tokens.get(index + 1).getText());
        }
    }

    private void createFindingForExpression(List<IToken> tokens) {
        Optional location = this.buildLocation().forTokens(tokens);
        if (location.isEmpty() || this.findingLocations.contains(((TextRegionLocation)location.get()).getRawStartOffset())) {
            return;
        }
        this.findingLocations.add(((TextRegionLocation)location.get()).getRawStartOffset());
        String tokenText = StringUtils.truncateWithEllipsis((String)TokenStreamTextUtils.concatTokenTexts(tokens), (int)100);
        String message = "Nonsensical operation on identical sub-expressions in (" + tokenText + ")";
        this.buildFinding(message, location).createAndStore();
    }
}

