/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-reassigning-parameters", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidReassigningParametersCheck
extends CheckImplementationBase {
    private static final ITokenMatcher ASSIGNMENT_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.MINUSEQ, ETokenType.MINUSMINUS, ETokenType.PLUSEQ, ETokenType.PLUSPLUS, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.URSHIFTEQ});
    private static final ITokenMatcher UNARY_PREFIX_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MINUSMINUS, ETokenType.PLUSPLUS});

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        Set<String> parameterNames = ShallowParsingUtils.extractParameterNameTokens((ShallowEntity)entity).stream().map(IToken::getText).collect(Collectors.toSet());
        List primitiveStatements = ShallowParsingUtils.listPrimitiveStatements((Collection)entity.getChildren());
        for (ShallowEntity statement : primitiveStatements) {
            UnmodifiableList statementTokens = statement.ownStartTokens();
            List assignmentIndices = TokenStreamUtils.findAll((List)statementTokens, (ITokenMatcher)ASSIGNMENT_OPERATORS);
            Iterator iterator = assignmentIndices.iterator();
            while (iterator.hasNext()) {
                int assignmentIndex = (Integer)iterator.next();
                IToken assignment = (IToken)statementTokens.get(assignmentIndex);
                if (UNARY_PREFIX_OPERATORS.matches(assignment) && assignmentIndex + 1 < statementTokens.size()) {
                    this.checkIfVariableEqualsToIdentifier(assignmentIndex + 1, (UnmodifiableList<IToken>)statementTokens, parameterNames);
                }
                if (assignmentIndex - 1 < 0) continue;
                this.checkIfVariableEqualsToIdentifier(assignmentIndex - 1, (UnmodifiableList<IToken>)statementTokens, parameterNames);
            }
        }
    }

    private void checkIfVariableEqualsToIdentifier(int assignedVariableTokenIndex, UnmodifiableList<IToken> statementTokens, Set<String> parameterNames) throws CheckException {
        if (assignedVariableTokenIndex - 1 >= 0 && ((IToken)statementTokens.get(assignedVariableTokenIndex - 1)).getType() == ETokenType.DOT) {
            return;
        }
        IToken assignedVariableToken = (IToken)statementTokens.get(assignedVariableTokenIndex);
        String variableName = assignedVariableToken.getText();
        if (assignedVariableToken.getType() == ETokenType.IDENTIFIER && parameterNames.contains(variableName)) {
            this.buildFinding("Reassigned value of the method parameter `" + variableName + "`", this.buildLocation().forToken(assignedVariableToken)).createAndStore();
        }
    }
}

