/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Check(id="cqse-method-returns-null-as-optional", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MethodReturnsNullAsOptionalCheck
extends CheckImplementationBase {
    private static final String OPTIONAL_SHORT_CLASS_NAME = Optional.class.getSimpleName();
    private static final String OPTIONAL_QUALIFIED_CLASS_NAME = Optional.class.getName();

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity method) throws CheckException {
        if (MethodReturnsNullAsOptionalCheck.isMethodWithOptionalReturnType(method)) {
            this.checkStatements(method);
        }
    }

    private void checkStatements(ShallowEntity method) throws CheckException {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singleton(method), (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            if (this.isNestedInLambdaOrAnonymousClass(statement, method)) continue;
            this.checkStatementForReturnNull(statement);
        }
    }

    private boolean isNestedInLambdaOrAnonymousClass(ShallowEntity statement, ShallowEntity method) {
        for (ShallowEntity parent = statement.getParent(); parent != null; parent = parent.getParent()) {
            if (parent == method) {
                return false;
            }
            if (parent.getType() == EShallowEntityType.STATEMENT) continue;
            return true;
        }
        CCSMAssert.fail((String)"Should not reach here as we know statement is a child of method");
        return false;
    }

    private void checkStatementForReturnNull(ShallowEntity statement) throws CheckException {
        if (TokenStreamUtils.hasTokenTypeSequence((List)statement.includedTokens(), (int)0, (ETokenType[])new ETokenType[]{ETokenType.RETURN, ETokenType.NULL_LITERAL})) {
            this.buildFinding("Method should return `Optional.empty()` instead of `null`", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private static boolean isMethodWithOptionalReturnType(ShallowEntity method) {
        int genericsDepth = 0;
        for (IToken token : method.ownStartTokens()) {
            ETokenType tokenType = token.getType();
            if (tokenType == ETokenType.LT) {
                ++genericsDepth;
            }
            if (tokenType == ETokenType.GT) {
                CCSMAssert.isTrue((--genericsDepth >= 0 ? 1 : 0) != 0, (String)"Generics depth is negative");
            }
            if (genericsDepth != 0 || tokenType != ETokenType.IDENTIFIER) continue;
            return OPTIONAL_SHORT_CLASS_NAME.equals(token.getText()) || OPTIONAL_QUALIFIED_CLASS_NAME.equals(token.getText());
        }
        return false;
    }
}

