/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaTypeInfoExtractor;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-missing-test-annotation", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingTestAnnotationCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Annotation in JUnit test class missing";
    private static final Set<String> TEST_ANNOTATION_SIMPLE_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"Test", "RepeatedTest", "ParameterizedTest"});
    private static final Set<String> TEST_ANNOTATION_QUALIFIED_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"org.junit.Test", "org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest"});
    private static final TokenPattern EXTENDS_JUNIT3_BASE_CLASS = LanguageFeatureParser.JAVA.classExtendsPattern().regex("\\bTestCase\\b");
    @CheckOption(name="Annotation in JUnit test class missing: Test class name pattern", description="The naming pattern for test classes. Default is \".*Test$\".")
    private String testClassNamePattern = ".*Test$";
    private Pattern compiledTestClassNamePattern;

    public void initialize() throws CheckException {
        this.compiledTestClassNamePattern = Pattern.compile(this.testClassNamePattern);
    }

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (type.getName() == null || !this.compiledTestClassNamePattern.matcher(type.getName()).matches()) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity classEntity) {
        if (!MissingTestAnnotationCheck.isJUnit4OrHigherTestClass(classEntity)) {
            return;
        }
        for (ShallowEntity child : classEntity.getChildrenOfType(EShallowEntityType.METHOD)) {
            if (classEntity.getName() == null || classEntity.getName().equals(child.getName())) continue;
            this.processMethodInJUnit4OrHigherTestClass(child);
        }
    }

    private static boolean isJUnit4OrHigherTestClass(ShallowEntity classEntity) {
        if (MissingTestAnnotationCheck.isJUnit3TestClass(classEntity)) {
            return false;
        }
        return classEntity.getChildrenOfType(EShallowEntityType.METHOD).stream().anyMatch(MissingTestAnnotationCheck::isTestAnnotationPresent);
    }

    private static boolean isJUnit3TestClass(ShallowEntity classEntity) {
        return EXTENDS_JUNIT3_BASE_CLASS.matchesAnywhere((List)classEntity.ownStartTokens());
    }

    private void processMethodInJUnit4OrHigherTestClass(ShallowEntity method) {
        if (MissingTestAnnotationCheck.isPublicNonAbstractNonStaticParameterlessMethod(method) && !LanguageFeatureParser.JAVA.isAnnotated(method)) {
            this.buildFinding("Method " + MarkupUtils.formatAsSourceCode((String)method.getName()) + " is `public` but has no JUnit annotation", this.buildLocation().forEntityFirstLine(method)).createAndStore();
        }
    }

    private static boolean isTestAnnotationPresent(ShallowEntity method) {
        List annotations = CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)method);
        return annotations.stream().map(ShallowEntity::getName).anyMatch(MissingTestAnnotationCheck::isTestAnnotationName);
    }

    private static boolean isPublicNonAbstractNonStaticParameterlessMethod(ShallowEntity method) {
        if (!TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PUBLIC})) {
            return false;
        }
        if (TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.ABSTRACT})) {
            return false;
        }
        if (TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.STATIC})) {
            return false;
        }
        return new JavaTypeInfoExtractor().extractFromMethod(method).isEmpty();
    }

    private static boolean isTestAnnotationName(String annotationName) {
        return TEST_ANNOTATION_SIMPLE_NAMES.contains(annotationName) || TEST_ANNOTATION_QUALIFIED_NAMES.contains(annotationName);
    }
}

