/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;

@Check(id="cqse-number-of-imports", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NumberOfImportsCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum number of imports", description="The maximum number of imports that are allowed.")
    private int maximumNumberOfImports = 50;

    public void execute() throws CheckException {
        List elements = this.select("/META[subtype('import')]");
        if (elements.size() > this.maximumNumberOfImports) {
            this.buildFinding("Too many imports (" + elements.size() + "/" + this.maximumNumberOfImports + ")", this.buildLocation().forElement()).createAndStore();
        }
    }
}

