/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="java:S5790", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AnnotateJUnitInnerTestClassesWithNestedCheck
extends CheckImplementationBase {
    private static final String NESTED_ANNOTATION = "Nested";

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        if (((List)LanguageFeatureParser.JAVA.getTestFrameworkImports(ast).getCollectionOrEmpty((Object)EJavaTestFramework.JUNIT_5)).isEmpty()) {
            return;
        }
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).forEach(this::handleType);
    }

    private void handleType(ShallowEntity type) {
        boolean isAnnotatedWithNested = CLikeLanguageFeatureParserBase.hasAnnotation((ShallowEntity)type, Set.of(NESTED_ANNOTATION));
        if (AnnotateJUnitInnerTestClassesWithNestedCheck.isInnerClass(type) && !AnnotateJUnitInnerTestClassesWithNestedCheck.isAbstractClass(type) && JavaLanguageFeatureParser.isTestClass((ShallowEntity)type)) {
            if (isAnnotatedWithNested && CLikeLanguageFeatureParserBase.isStatic((ShallowEntity)type)) {
                this.buildFinding(AnnotateJUnitInnerTestClassesWithNestedCheck.createMessage(type, false), this.buildLocation().forEntityFirstLine(type)).createAndStore();
            } else if (!isAnnotatedWithNested && !CLikeLanguageFeatureParserBase.isStatic((ShallowEntity)type)) {
                this.buildFinding(AnnotateJUnitInnerTestClassesWithNestedCheck.createMessage(type, true), this.buildLocation().forEntityFirstLine(type)).createAndStore();
            }
        }
    }

    private static boolean isInnerClass(ShallowEntity type) {
        return type.getParent() != null && type.getParent().getType() == EShallowEntityType.TYPE;
    }

    private static boolean isAbstractClass(ShallowEntity type) {
        return TokenStreamUtils.contains((List)type.ownStartTokens(), (ETokenType)ETokenType.ABSTRACT);
    }

    private static String createMessage(ShallowEntity type, boolean shouldBeAnnotatedWithNested) {
        if (shouldBeAnnotatedWithNested) {
            return "%s should be annotated with `@Nested`".formatted(type.getName());
        }
        return "%s should not be annotated with `@Nested`".formatted(type.getName());
    }
}

