/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.xml;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.java.xml.XMLFeatures;
import eu.cqse.check.java.xml.XMLType;
import eu.cqse.check.java.xml.XMLTypeInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class XMLCheckUtils {
    static SetMap<ShallowEntity, XMLTypeInformation> extractXMLTypeInformation(List<ShallowEntity> statements, ITypeResolution lookup) {
        SetMap xmlTypeInformation = new SetMap();
        for (ShallowEntity statement : statements) {
            if (statement.getType() != EShallowEntityType.STATEMENT) continue;
            ScopedTypeLookup typeLookup = lookup.getTypeLookup(statement);
            for (String variable : typeLookup.getAllVariables()) {
                TypedVariable typeInfo = typeLookup.getTypeInfo(variable);
                XMLType type = XMLType.getXMLType(typeInfo.getTypeName());
                if (type == null) continue;
                xmlTypeInformation.add((Object)statement, (Object)new XMLTypeInformation(variable, type));
            }
        }
        return xmlTypeInformation;
    }

    public static boolean customEntityResolverIsSet(SetMap<ShallowEntity, XMLTypeInformation> xmlTypeInformation) {
        Predicate<ShallowEntity> predicate = entity -> {
            Set typeInfos = (Set)xmlTypeInformation.getCollectionOrEmpty(entity);
            return typeInfos.stream().anyMatch(helper -> XMLCheckUtils.customEntityResolverIsSet(entity, helper.variable(), helper.xmlType()));
        };
        return !ShallowEntityTraversalUtils.selectEntities(new ArrayList(xmlTypeInformation.getKeys()), predicate).isEmpty();
    }

    private static boolean customEntityResolverIsSet(ShallowEntity statement, String variable, XMLType type) {
        if (!type.hasFeature(XMLFeatures.CUSTOM_ENTITY_RESOLVER)) {
            return false;
        }
        TokenPattern pattern = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setEntityResolver"}).or(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setResourceResolver"})}).or(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setXMLResolver"})})}), ETokenType.LPAREN}).notFollowedBy((Object)ETokenType.NULL_LITERAL);
        UnmodifiableList iTokens = statement.ownStartTokens();
        return pattern.matchesAnywhere((List)iTokens);
    }

    private XMLCheckUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

