/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.javascript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.javascript.UnacceptedTokensCheckBase;
import java.util.List;

@Check(id="cqse-do-not-use-eq-eq", languages={ELanguage.JAVASCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotUseEqEqCheck
extends UnacceptedTokensCheckBase {
    @Override
    protected ITokenMatcher getUnacceptedTokenTypes() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ});
    }

    @Override
    protected String getFindingMessage(IToken findingToken) {
        String expectedToken = "===";
        if (findingToken.getType() == ETokenType.NOTEQ) {
            expectedToken = "!==";
        }
        return "Comparator `" + findingToken.getText() + "` should be replaced with `" + expectedToken + "`";
    }

    @Override
    protected boolean ignoreFindingToken(List<IToken> tokens, int unacceptedTokenIndex) {
        int nextTokenIndex = unacceptedTokenIndex + 1;
        if (tokens.size() == nextTokenIndex) {
            return false;
        }
        return tokens.get(nextTokenIndex).getType() == ETokenType.NULL_LITERAL;
    }
}

