/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-avoid-repetitive-dml", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidRepetitiveDMLCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List abstractSyntaxTree = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)abstractSyntaxTree, Set.of(EShallowEntityType.STATEMENT), Set.of("loop", "while", "for")).forEach(this::checkForRepetitiveDMLOperations);
    }

    private void checkForRepetitiveDMLOperations(ShallowEntity loopEntity) {
        UnmodifiableList nestedEntities = loopEntity.getChildren();
        if (nestedEntities.isEmpty()) {
            return;
        }
        nestedEntities.forEach(entity -> {
            if (this.isDMLOperation((ShallowEntity)entity)) {
                this.buildFinding("Avoid repetitive DML operations inside loops. Use %s or %s instead.".formatted(MarkupUtils.formatAsSourceCode((String)"BULK COLLECT"), MarkupUtils.formatAsSourceCode((String)"FORALL")), this.buildLocation().forEntity(entity)).createAndStore();
            }
            this.checkForRepetitiveDMLOperations((ShallowEntity)entity);
        });
    }

    private boolean isDMLOperation(ShallowEntity entity) {
        String subtype = entity.getName();
        if (subtype == null) {
            return false;
        }
        return List.of("insert", "update", "delete", "select").contains(subtype);
    }
}

