/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.simulink.LocalCodeSnippetParser;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkEnumeratedType;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0031", languages={ELanguage.SIMULINK, ELanguage.MATLAB})
public class SimulinkEnumDefinitionDefaultCheck
extends CheckImplementationBase {
    private static final String MESSAGE_PATTERN_EMPTY_ENUMERATION = "Enumeration {0} is empty";
    private static final String MESSAGE_PATTERN_ENUMERATION_WITH_SINGLE_VALUE = "Enumeration {0} has only one value";
    private static final String MESSAGE_PATTERN_ENUMERATION_NO_DEFAULT_VALUE = "Enumeration {0} has no default value";
    private static final String MESSAGE_PATTERN_ENUMERATION_WRONG_DEFAULT_VALUE = "Default value {0} for enumeration {1} is not one of its members";
    private static final FindingPropertyList RECOMMENDED_ACTION_EMPTY_ENUMERATION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Add values to this enumeration or remove it.");
    private static final FindingPropertyList RECOMMENDED_ACTION_ENUMERATION_WITH_SINGLE_VALUE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Add more values to this enumeration and set a default value.");
    private static final FindingPropertyList RECOMMENDED_ACTION_ENUMERATION_NO_DEFAULT_VALUE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set a member of the enumeration as its default value.");
    private final LocalCodeSnippetParser matlabParser = new LocalCodeSnippetParser(ELanguage.MATLAB);

    public void execute() throws CheckException {
        if (ELanguage.MATLAB == this.context.getLanguage()) {
            this.checkEnumerationsInMatlabFile(this.context.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED));
        } else if (ELanguage.SIMULINK == this.context.getLanguage() && this.context.getSimulinkContext().getSimulinkModelForModelFile().isPresent()) {
            SimulinkModel model = (SimulinkModel)this.context.getSimulinkContext().getSimulinkModelForModelFile().get();
            for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
                QualifiedNameLocation findingLocation = this.context.buildLocation().forSimulinkBlock(block);
                for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                    this.checkEnumerationsInMatlabScript(script, findingLocation);
                }
            }
            for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
                String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
                QualifiedNameLocation findingLocation = this.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState);
                this.checkEnumerationsInMatlabScript(script, findingLocation);
            }
        } else {
            Optional dataDictionary = this.context.getSimulinkContext().getSimulinkDataDictionaryForDictionaryFile();
            dataDictionary.ifPresent(this::checkEnumerationsInDataDictionary);
        }
    }

    private void checkEnumerationsInDataDictionary(SimulinkDataDictionary dataDictionary) {
        for (ISimulinkDataDictionaryEntry entry : dataDictionary.getEntries()) {
            if (!(entry instanceof SimulinkEnumeratedType)) {
                return;
            }
            this.checkEnumeration((SimulinkEnumeratedType)entry, (ElementLocation)this.buildLocation().forSimulinkDataDictionaryEntry(entry));
        }
    }

    private void checkEnumerationsInMatlabFile(ShallowEntity rootEntity) {
        SimulinkEnumDefinitionDefaultCheck.extractEnumerationEntity(rootEntity).ifPresent(this::checkEnumerationClass);
        this.checkInlineEnumerationsInStatements((List<ShallowEntity>)rootEntity.getChildren(), entity -> this.buildLocation().forEntity(entity).orElse(null));
    }

    private void checkEnumerationsInMatlabScript(String script, QualifiedNameLocation findingLocation) {
        List<ShallowEntity> entities = this.matlabParser.parseTopLevel(script, this.context.getUniformPath());
        this.checkInlineEnumerationsInStatements(entities, entity -> findingLocation);
    }

    private void checkInlineEnumerationsInStatements(List<ShallowEntity> statements, Function<ShallowEntity, ElementLocation> findingLocationGetter) {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listMatchingEntitiesRecursive(statements, entity -> EShallowEntityType.STATEMENT == entity.getType())) {
            List<SimulinkEnumeratedType> enums = SimulinkEnumDefinitionDefaultCheck.extractInlineDeclaredEnumsFromStatements(statement);
            for (SimulinkEnumeratedType enumeration : enums) {
                this.checkEnumeration(enumeration, findingLocationGetter.apply(statement));
            }
        }
    }

    private void checkEnumerationClass(ShallowEntity enumerationEntity) {
        ShallowEntity enumerationClass = enumerationEntity.getParent();
        String enumName = enumerationClass.getName();
        Map<String, String> enumValues = SimulinkEnumDefinitionDefaultCheck.extractEnumValuesFromEnumerationEntity(enumerationEntity);
        String defaultValue = null;
        ShallowEntity defaultValueMethod = SimulinkEnumDefinitionDefaultCheck.extractDefaultValueMethodFromEnumerationClass(enumerationClass);
        if (defaultValueMethod != null) {
            Optional<String> matchingDefaultValue = defaultValueMethod.includedTokens().stream().map(IToken::getText).filter(enumValues::containsKey).findFirst();
            defaultValue = matchingDefaultValue.orElse("");
        }
        this.checkEnumeration(new SimulinkEnumeratedType(enumName, "Unknown", enumValues, defaultValue), this.buildLocation().forEntityFirstLine(enumerationClass, ECodeViewOption.ETextViewOption.FILTERED_CONTENT).orElse(null));
    }

    private void checkEnumeration(SimulinkEnumeratedType enumeration, ElementLocation findingLocation) {
        int valuesCount = enumeration.getEnumerationItems().size();
        if (valuesCount == 0) {
            this.buildFinding(MessageFormat.format(MESSAGE_PATTERN_EMPTY_ENUMERATION, MarkupUtils.formatAsSourceCode((String)enumeration.getName())), findingLocation).addFindingProperties(RECOMMENDED_ACTION_EMPTY_ENUMERATION).createAndStore();
        } else if (valuesCount == 1) {
            this.buildFinding(MessageFormat.format(MESSAGE_PATTERN_ENUMERATION_WITH_SINGLE_VALUE, MarkupUtils.formatAsSourceCode((String)enumeration.getName())), findingLocation).addFindingProperties(RECOMMENDED_ACTION_ENUMERATION_WITH_SINGLE_VALUE).createAndStore();
        } else if (StringUtils.isEmpty((String)enumeration.getDefaultItem())) {
            this.buildFinding(MessageFormat.format(MESSAGE_PATTERN_ENUMERATION_NO_DEFAULT_VALUE, MarkupUtils.formatAsSourceCode((String)enumeration.getName())), findingLocation).addFindingProperties(RECOMMENDED_ACTION_ENUMERATION_NO_DEFAULT_VALUE).createAndStore();
        } else if (!enumeration.getEnumerationItems().contains(enumeration.getDefaultItem())) {
            this.buildFinding(MessageFormat.format(MESSAGE_PATTERN_ENUMERATION_WRONG_DEFAULT_VALUE, MarkupUtils.formatAsSourceCode((String)enumeration.getDefaultItem()), MarkupUtils.formatAsSourceCode((String)enumeration.getName())), findingLocation).addFindingProperties(RECOMMENDED_ACTION_ENUMERATION_NO_DEFAULT_VALUE).createAndStore();
        }
    }

    private static Optional<ShallowEntity> extractEnumerationEntity(ShallowEntity rootEntity) {
        return ShallowEntityTraversalUtils.selectEntities((Collection)rootEntity.getChildren(), entity -> entity.getType() == EShallowEntityType.META && "enumeration".equals(entity.getSubtype())).stream().findFirst();
    }

    private static ShallowEntity extractDefaultValueMethodFromEnumerationClass(ShallowEntity enumerationClass) {
        Optional methodEntity = ShallowEntityTraversalUtils.selectEntities((Collection)enumerationClass.getChildren(), entity -> entity.getType() == EShallowEntityType.META && "methods".equals(entity.getSubtype())).stream().findAny();
        if (methodEntity.isEmpty()) {
            return null;
        }
        for (ShallowEntity methodDeclaration : ((ShallowEntity)methodEntity.get()).getChildrenOfType(EShallowEntityType.METHOD)) {
            if (!"getDefaultValue".equals(methodDeclaration.getName())) continue;
            return methodDeclaration;
        }
        return null;
    }

    private static List<SimulinkEnumeratedType> extractInlineDeclaredEnumsFromStatements(ShallowEntity statement) {
        ArrayList<SimulinkEnumeratedType> declaredEnums = new ArrayList<SimulinkEnumeratedType>();
        UnmodifiableList tokens = statement.ownStartTokens();
        Iterator iterator = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN}).iterator();
        while (iterator.hasNext()) {
            int parameterStart;
            int parameterEnd;
            int startIndex = (Integer)iterator.next();
            if (!"Simulink".equals(((IToken)tokens.get(startIndex)).getText()) || !"defineIntEnumType".equals(((IToken)tokens.get(startIndex + 2)).getText()) || (parameterEnd = TokenStreamUtils.findMatchingClosingToken((List)tokens, (int)((parameterStart = startIndex + 3) + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) == -1 || tokens.size() < startIndex + 4) continue;
            String enumName = StringUtils.removeSingleQuotes((String)((IToken)tokens.get(parameterStart + 1)).getText());
            Map<String, String> enumValues = SimulinkEnumDefinitionDefaultCheck.extractEnumValuesFromInlineDeclaration((List<IToken>)tokens, parameterStart);
            String defaultValue = SimulinkEnumDefinitionDefaultCheck.extractEnumDefaultValueFromInlineDeclaration((List<IToken>)tokens, parameterStart, parameterEnd);
            declaredEnums.add(new SimulinkEnumeratedType(enumName, "Unknown", enumValues, defaultValue));
        }
        return declaredEnums;
    }

    private static Map<String, String> extractEnumValuesFromEnumerationEntity(ShallowEntity enumerationEntity) {
        if (enumerationEntity == null) {
            return Map.of();
        }
        List<String> enumNames = enumerationEntity.includedTokens().stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).toList();
        List<String> enumValues = enumerationEntity.includedTokens().stream().filter(token -> token.getType() == ETokenType.INTEGER_LITERAL).map(IToken::getText).toList();
        HashMap<String, String> enumNamesAndValues = new HashMap<String, String>();
        for (int i = 0; i < enumNames.size(); ++i) {
            enumNamesAndValues.put(enumNames.get(i), enumValues.get(i));
        }
        return enumNamesAndValues;
    }

    private static Map<String, String> extractEnumValuesFromInlineDeclaration(List<IToken> tokens, int start) {
        int startEnumNames = TokenStreamUtils.findFirstTopLevel(tokens, (int)(start + 1), (ITokenMatcher)ETokenType.ARRAY_SEPARATOR, List.of(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK), List.of(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK)) + 1;
        int endEnumNames = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(startEnumNames + 1), (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE);
        List<String> enumNames = tokens.subList(startEnumNames, endEnumNames).stream().filter(token -> token.getType() == ETokenType.STRING_LITERAL).map(token -> StringUtils.removeSingleQuotes((String)token.getText())).toList();
        int startEnumValues = TokenStreamUtils.findFirstTopLevel(tokens, (int)(endEnumNames + 1), (ITokenMatcher)ETokenType.ARRAY_SEPARATOR, List.of(), List.of()) + 1;
        int endEnumValues = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(startEnumValues + 1), (ETokenType)ETokenType.LBRACK, (ETokenType)ETokenType.RBRACK);
        List<String> enumValues = tokens.subList(startEnumValues, endEnumValues).stream().filter(token -> token.getType() == ETokenType.INTEGER_LITERAL).map(IToken::getText).toList();
        HashMap<String, String> enumNamesAndValues = new HashMap<String, String>();
        for (int i = 0; i < enumNames.size(); ++i) {
            enumNamesAndValues.put(enumNames.get(i), enumValues.get(i));
        }
        return enumNamesAndValues;
    }

    private static String extractEnumDefaultValueFromInlineDeclaration(List<IToken> tokens, int start, int end) {
        int index = TokenStreamTextUtils.findFirst(tokens, (int)start, (int)end, (String)"'DefaultValue'");
        if (index == -1) {
            return null;
        }
        return StringUtils.removeSingleQuotes((String)tokens.get(index + 2).getText());
    }
}

