/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import com.google.common.collect.ImmutableSet;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0656", languages={ELanguage.SIMULINK})
public class SimulinkDefaultControlCaseCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_IF = FindingPropertyList.singleton((String)"Recommended Action", (String)"Enable the `else` case of the affected `if` blocks.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SWITCH = FindingPropertyList.singleton((String)"Recommended Action", (String)"Enable the `default` case of the affected `switch` block.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, (Set)ImmutableSet.of((Object)"If"), (boolean)false, (boolean)false)) {
            if (!"off".equals(block.getParameter("ShowElse"))) continue;
            this.buildFinding("Default `else` case missing (turned off) for `if` block", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_IF).createAndStore();
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, (Set)ImmutableSet.of((Object)"SwitchCase"), (boolean)false, (boolean)false)) {
            if (!"off".equals(block.getParameter("ShowDefaultCase"))) continue;
            this.buildFinding("Case `default` missing (turned off) for `switch` block", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SWITCH).createAndStore();
        }
    }
}

