/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import com.google.common.collect.Sets;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0641", languages={ELanguage.SIMULINK})
public class SimulinkSampleTimeSettingCheck
extends CheckImplementationBase {
    private static final String NO_SAMPLE_TIME_FINDING_MESSAGE = "The block does not have the sample time set to '-1' ('inherited')";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider setting the sample time to '-1' ('inherited').");
    private static final Set<String> BLOCK_TYPE_EXCEPTIONS = Sets.newHashSet((Object[])new String[]{"RandomNumber", "Sin", "Step", "UniformRandomNumber", "FromSpreadsheet", "DigitalClock", "FromWorkspace", "Constant", "FromFile", "DiscretePulseGenerator", "RateTransition", "Delay", "Inport", "SignalSpecification", "DiscreteIntegrator", "Memory", "UnitDelay", "Outport", "TriggerPort", "EnablePort"});
    private static final Set<String> REFERENCE_TYPE_SOURCE_EXCEPTIONS = Sets.newHashSet((Object[])new String[]{"simulink/Sources/Repeating\\nSequence\\nStair", "Counter Limited", "Counter Free-Running", "Enumerated Constant", "SignalEditor", "simulink/Sources/Waveform\\nGenerator Limited", "Repeated Sequence Interpolated", "Function-Call Generator"});
    private static final Predicate<SimulinkBlock> EXCEPTIONS_FILTER = simulinkBlock -> {
        boolean isException = BLOCK_TYPE_EXCEPTIONS.contains(simulinkBlock.getType());
        boolean isReferenceException = simulinkBlock.isOfType("Reference") && REFERENCE_TYPE_SOURCE_EXCEPTIONS.contains(simulinkBlock.getSourceType());
        boolean isSubSystemException = simulinkBlock.isOfType("SubSystem") && "on".equals(simulinkBlock.getParameter("TreatAsAtomicUnit"));
        return !isException && !isReferenceException && !isSubSystemException;
    };

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        Collection simulinkBlocks = SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false);
        simulinkBlocks = simulinkBlocks.stream().filter(EXCEPTIONS_FILTER).collect(Collectors.toSet());
        for (SimulinkBlock block : simulinkBlocks) {
            boolean hasCorrectSampleTimeMode;
            String sampleTime = block.getParameter("SampleTime");
            String sampleTimeMode = block.getParameter("SampleTimeMode");
            boolean isSourceBlock = block.getInPorts().size() == 0 && block.getOutPorts().size() > 0;
            boolean hasCorrectSampleTime = sampleTime != null && !"-1".equals(sampleTime);
            boolean bl = hasCorrectSampleTimeMode = sampleTimeMode != null && !"inherited".equals(sampleTimeMode);
            if (isSourceBlock || !hasCorrectSampleTime && !hasCorrectSampleTimeMode) continue;
            this.context.buildFinding(NO_SAMPLE_TIME_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

