/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0171", languages={ELanguage.SIMULINK})
public class SimulinkSubsystemGotoConnectionsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_CONNECTION = "Missing direct connection from %s to %s";
    private static final String FINDING_MESSAGE_UNUSED = "Subsystem %s contains unused signal from input %s";
    private static final FindingPropertyList RECOMMENDED_ACTION_CONNECTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Create a direct connection between the subsystems");
    private static final FindingPropertyList RECOMMENDED_ACTION_UNUSED = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use the signal from the inport inside the subsystem or remove it");
    private static final Set<String> UNUSED_SIGNAL_DESTINATIONS = Set.of("Terminator", "Outport");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            ListMap<String, SimulinkBlock> subSystemListMap = SimulinkSubsystemGotoConnectionsCheck.getGotoTagToConnectedSubsystems(block);
            for (SimulinkBlock subBlock : block.getSubBlocks()) {
                if (!subBlock.hasSubBlocks()) continue;
                if (SimulinkUtils.isUserVisible((SimulinkBlock)subBlock)) {
                    this.checkOutgoingSignals(subBlock, subSystemListMap);
                }
                if (SimulinkUtils.isCommentedBlock((SimulinkBlock)subBlock)) continue;
                this.checkInnerSignals(subBlock);
            }
        }
    }

    private static ListMap<String, SimulinkBlock> getGotoTagToConnectedSubsystems(SimulinkBlock system) {
        ListMap subsystems = new ListMap();
        for (SimulinkBlock block : system.getSubBlocks()) {
            if (!block.isOfType("From")) continue;
            Set subSystemNames = block.getOutLines().stream().filter(out -> !out.hasUnconnectedEndpoint()).map(out -> out.getDstPort().getBlock()).filter(SimulinkBlock::hasSubBlocks).collect(Collectors.toSet());
            subsystems.addAll((Object)SimulinkSubsystemGotoConnectionsCheck.getGotoTag(block), subSystemNames);
        }
        return subsystems;
    }

    private static String getGotoTag(SimulinkBlock block) {
        return Optional.ofNullable(block.getParameter("GotoTag")).orElse("");
    }

    private void checkOutgoingSignals(SimulinkBlock system, ListMap<String, SimulinkBlock> subSystemListMap) {
        HashSet<SimulinkBlock> directlyConnectedSubSystems = new HashSet<SimulinkBlock>();
        HashSet subSystemsConnectedByGotoFrom = new HashSet();
        for (SimulinkLine line : system.getOutLines()) {
            if (line.getDstPort() == null) continue;
            SimulinkBlock destination = line.getDstPort().getBlock();
            if (destination.isOfType("SubSystem")) {
                directlyConnectedSubSystems.add(destination);
                continue;
            }
            if (!destination.isOfType("Goto")) continue;
            subSystemsConnectedByGotoFrom.addAll(subSystemListMap.getCollectionOrEmpty((Object)SimulinkSubsystemGotoConnectionsCheck.getGotoTag(destination)));
        }
        subSystemsConnectedByGotoFrom.removeAll(directlyConnectedSubSystems);
        for (SimulinkBlock subSystem : subSystemsConnectedByGotoFrom) {
            String findingMessage = String.format(FINDING_MESSAGE_CONNECTION, system.getName(), subSystem.getName());
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(system)).addSiblingLocations(Collections.singletonList(this.buildLocation().forSimulinkBlock(subSystem))).addFindingProperties(RECOMMENDED_ACTION_CONNECTION).createAndStore();
        }
    }

    private void checkInnerSignals(SimulinkBlock system) {
        HashSet<SimulinkBlock> inportWithFindings = new HashSet<SimulinkBlock>();
        for (SimulinkLine line : system.getContainedLines()) {
            SimulinkOutPort srcPort = line.getSrcPort();
            SimulinkInPort dstPort = line.getDstPort();
            if (srcPort == null || dstPort == null || inportWithFindings.contains(srcPort.getBlock()) || !SimulinkUtils.isInport((SimulinkBlock)srcPort.getBlock()) || !UNUSED_SIGNAL_DESTINATIONS.contains(dstPort.getBlock().getType())) continue;
            inportWithFindings.add(srcPort.getBlock());
            String findingMessage = String.format(FINDING_MESSAGE_UNUSED, system.getName(), line.getSrcPort().getBlock().getName());
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(system)).addFindingProperties(RECOMMENDED_ACTION_UNUSED).createAndStore();
        }
    }
}

