/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.db_0042", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfInportAndOutportBlocksCheck
extends CheckImplementationBase {
    @CheckOption(name="Check for duplicated inports", description="If true, duplicated inport blocks shall not be used, if possible. Implements sub check db_0042_c. If false, duplicated inports are allowed without restriction.")
    private boolean checkForDuplicatedInportBlocks = true;
    private static final String FINDING_INPORT_POSITIONING = "Inport block is not placed on the left side of the diagram without a signal overlap";
    private static final FindingPropertyList RECOMMENDED_ACTION_INPORT_POSITIONING = FindingPropertyList.singleton((String)"Recommended Action", (String)"Inport block shall be moved to the left side of the diagram without causing a signal overlap.");
    private static final String FINDING_OUTPORT_POSITIONING = "Outport block is not placed on the right side of the diagram without a signal overlap";
    private static final FindingPropertyList RECOMMENDED_ACTION_OUTPORT_POSITIONING = FindingPropertyList.singleton((String)"Recommended Action", (String)"Outport block shall be moved to the right side of the diagram without causing a signal overlap.");
    private static final String FINDING_INPORT_DUPLICATE = "Inport is a duplicate of another Inport";
    private static final FindingPropertyList RECOMMENDED_ACTION_INPORT_DUPLICATE_SYSTEM = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove this block.");
    private static final FindingPropertyList RECOMMENDED_ACTION_INPORT_DUPLICATE_SUBSYSTEM = FindingPropertyList.singleton((String)"Recommended Action", (String)"Check if this block can be removed.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Model", "SubSystem"), (boolean)false, (boolean)false)) {
            this.checkSubBlocks(block);
        }
    }

    private void checkSubBlocks(SimulinkBlock block) {
        if (!block.hasSubBlocks() || block instanceof StateflowBlock) {
            return;
        }
        List<Set<SimulinkBlock>> connectedComponents = SimulinkUsageOfInportAndOutportBlocksCheck.getConnectedComponents(block);
        for (Set<SimulinkBlock> connectedComponent : connectedComponents) {
            Set<SimulinkBlock> inports = connectedComponent.stream().filter(SimulinkUtils::isInport).collect(Collectors.toSet());
            Set<SimulinkBlock> outports = connectedComponent.stream().filter(SimulinkUtils::isOutport).collect(Collectors.toSet());
            Pair<Double, Double> minMaxLineXCoordinates = SimulinkUsageOfInportAndOutportBlocksCheck.getMinAndMaxXCoordinateOfBlockLines(CollectionUtils.differenceSet(connectedComponent, (Collection[])new Collection[]{inports, outports}));
            double leftBoundary = Math.min(SimulinkUsageOfInportAndOutportBlocksCheck.getMinimumXCoordinateOfBlocks(CollectionUtils.differenceSet(connectedComponent, (Collection[])new Collection[]{inports})), (Double)minMaxLineXCoordinates.getFirst());
            double rightBoundary = Math.max(SimulinkUsageOfInportAndOutportBlocksCheck.getMaximumXCoordinateOfBlocks(CollectionUtils.differenceSet(connectedComponent, (Collection[])new Collection[]{outports})), (Double)minMaxLineXCoordinates.getSecond());
            this.checkInports(inports, leftBoundary);
            this.checkOutports(outports, rightBoundary);
        }
    }

    private void checkInports(Set<SimulinkBlock> ports, double leftBoundary) {
        for (SimulinkBlock port : ports) {
            if (SimulinkUsageOfInportAndOutportBlocksCheck.violationInPortPosition(port, leftBoundary)) {
                this.buildFinding(FINDING_INPORT_POSITIONING, (ElementLocation)this.buildLocation().forSimulinkBlock(port)).addFindingProperties(RECOMMENDED_ACTION_INPORT_POSITIONING).createAndStore();
            }
            if (!this.checkForDuplicatedInportBlocks) continue;
            this.checkInportDuplicates(port);
        }
    }

    private void checkOutports(Set<SimulinkBlock> ports, double rightBoundary) {
        for (SimulinkBlock port : ports) {
            if (!SimulinkUsageOfInportAndOutportBlocksCheck.violationInPortPosition(port, rightBoundary)) continue;
            this.buildFinding(FINDING_OUTPORT_POSITIONING, (ElementLocation)this.buildLocation().forSimulinkBlock(port)).addFindingProperties(RECOMMENDED_ACTION_OUTPORT_POSITIONING).createAndStore();
        }
    }

    private static boolean violationInPortPosition(SimulinkBlock port, double boundaryXValue) {
        SimulinkBlock parent;
        Collection portLines;
        Rectangle portPosition = port.obtainBlockLayoutData().getPosition();
        boolean isInport = SimulinkUtils.isInport((SimulinkBlock)port);
        double adjustedBoundaryXValue = boundaryXValue;
        if (isInport) {
            portLines = port.getOutLines();
            adjustedBoundaryXValue -= portPosition.getWidth();
        } else {
            portLines = port.getInLines();
            adjustedBoundaryXValue += portPosition.getWidth();
        }
        if (SimulinkUsageOfInportAndOutportBlocksCheck.isOnWrongSideOfConnectedBlock(portPosition, portLines, isInport)) {
            return true;
        }
        Line2D.Double boundaryLine = new Line2D.Double(new Point2D.Double(adjustedBoundaryXValue, portPosition.getCenterY()), new Point2D.Double(portPosition.getCenterX(), portPosition.getCenterY()));
        if (SimulinkUsageOfInportAndOutportBlocksCheck.wouldIntersectLine(portLines, boundaryLine, parent = port.getParent()) || SimulinkUsageOfInportAndOutportBlocksCheck.wouldIntersectBlock(port, boundaryLine, (Collection<SimulinkBlock>)parent.getSubBlocks())) {
            return false;
        }
        if (isInport) {
            return portPosition.getMaxX() > boundaryXValue;
        }
        return portPosition.getMinX() < boundaryXValue;
    }

    private static boolean wouldIntersectLine(Collection<SimulinkLine> portLines, Line2D boundaryLine, SimulinkBlock parent) {
        for (SimulinkLine simulinkLine : parent.getContainedLines()) {
            if (portLines.contains(simulinkLine)) continue;
            List linePoints = simulinkLine.obtainLayoutData().getPoints();
            List<Line2D> straightLines = SimulinkUsageOfInportAndOutportBlocksCheck.getStraightLines(linePoints);
            if (!straightLines.stream().anyMatch(boundaryLine::intersectsLine)) continue;
            return true;
        }
        return false;
    }

    private static boolean wouldIntersectBlock(SimulinkBlock port, Line2D boundaryLine, Collection<SimulinkBlock> blocks) {
        for (SimulinkBlock block : blocks) {
            Rectangle subBlockPosition;
            if (block.equals(port) || !boundaryLine.intersects(subBlockPosition = block.obtainBlockLayoutData().getPosition())) continue;
            return true;
        }
        return false;
    }

    private static boolean isOnWrongSideOfConnectedBlock(Rectangle portPosition, Collection<SimulinkLine> portLines, boolean isInport) {
        for (SimulinkLine portLine : portLines) {
            if (portLine.hasUnconnectedEndpoint()) continue;
            Object port = isInport ? portLine.getDstPort() : portLine.getSrcPort();
            if (portPosition.getCenterX() > port.obtainLayoutData().getPosition().getX() != isInport) continue;
            return true;
        }
        return false;
    }

    private static List<Line2D> getStraightLines(List<Point> linePoints) {
        ArrayList<Line2D> lines = new ArrayList<Line2D>();
        if (linePoints.size() < 2) {
            return lines;
        }
        Point start = linePoints.get(0);
        Point end = linePoints.get(1);
        for (int i = 2; i < linePoints.size(); ++i) {
            Point point = linePoints.get(i);
            if (start.getX() != point.getX() && start.getY() != point.getY()) {
                lines.add(new Line2D.Double(start, end));
                start = end;
            }
            end = point;
        }
        lines.add(new Line2D.Double(start, end));
        return lines;
    }

    private void checkInportDuplicates(SimulinkBlock inport) {
        if (inport.isOfType("InportShadow")) {
            if (inport.getParent().isOfType("Model")) {
                this.buildFinding(FINDING_INPORT_DUPLICATE, (ElementLocation)this.buildLocation().forSimulinkBlock(inport)).addFindingProperties(RECOMMENDED_ACTION_INPORT_DUPLICATE_SYSTEM).createAndStore();
            } else {
                this.buildFinding(FINDING_INPORT_DUPLICATE, (ElementLocation)this.buildLocation().forSimulinkBlock(inport)).addFindingProperties(RECOMMENDED_ACTION_INPORT_DUPLICATE_SUBSYSTEM).createAndStore();
            }
        }
    }

    private static List<Set<SimulinkBlock>> getConnectedComponents(SimulinkBlock block) {
        ArrayList<Set<SimulinkBlock>> connectedComponents = new ArrayList<Set<SimulinkBlock>>();
        for (SimulinkBlock subBlocks : block.getSubBlocks()) {
            if (connectedComponents.stream().anyMatch(component -> component.contains(subBlocks))) continue;
            connectedComponents.add(SimulinkUsageOfInportAndOutportBlocksCheck.getConnectedBlocks(subBlocks, new HashSet<SimulinkBlock>()));
        }
        return connectedComponents;
    }

    private static Set<SimulinkBlock> getConnectedBlocks(SimulinkBlock block, Set<SimulinkBlock> connectedBlocks) {
        SimulinkBlock next;
        connectedBlocks.add(block);
        for (SimulinkLine line : block.getOutLines()) {
            if (line.getDstPort() == null || connectedBlocks.contains(next = line.getDstPort().getBlock())) continue;
            connectedBlocks.addAll(SimulinkUsageOfInportAndOutportBlocksCheck.getConnectedBlocks(next, connectedBlocks));
        }
        for (SimulinkLine line : block.getInLines()) {
            if (line.getSrcPort() == null || connectedBlocks.contains(next = line.getSrcPort().getBlock())) continue;
            connectedBlocks.addAll(SimulinkUsageOfInportAndOutportBlocksCheck.getConnectedBlocks(next, connectedBlocks));
        }
        return connectedBlocks;
    }

    private static double getMinimumXCoordinateOfBlocks(Set<SimulinkBlock> blocks) {
        return blocks.stream().mapToDouble(a -> a.obtainBlockLayoutData().getPosition().getMinX()).min().orElse(Double.POSITIVE_INFINITY);
    }

    private static double getMaximumXCoordinateOfBlocks(Set<SimulinkBlock> blocks) {
        return blocks.stream().mapToDouble(a -> a.obtainBlockLayoutData().getPosition().getMaxX()).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private static Pair<Double, Double> getMinAndMaxXCoordinateOfBlockLines(Set<SimulinkBlock> blocks) {
        Pair minMaxPair = new Pair((Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY);
        for (SimulinkBlock block : blocks) {
            for (SimulinkLine line : block.getOutLines()) {
                if (line.getDstPort() == null || SimulinkUtils.isOutport((SimulinkBlock)line.getDstPort().getBlock())) continue;
                DoubleStream valueStream = line.obtainLayoutData().getPoints().stream().mapToDouble(Point::getX);
                DoubleSummaryStatistics statistics = valueStream.summaryStatistics();
                double lineMinX = statistics.getMin();
                if ((Double)minMaxPair.getFirst() > lineMinX) {
                    minMaxPair.setFirst((Object)lineMinX);
                }
                double lineMaxX = statistics.getMax();
                if (!((Double)minMaxPair.getSecond() < lineMaxX)) continue;
                minMaxPair.setSecond((Object)lineMaxX);
            }
        }
        return minMaxPair;
    }
}

