/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0628", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfSaturationBlocksCheck
extends CheckImplementationBase {
    private static final String SATURATE_DATA_TYPE = "Inherit: Same as input";
    private static final String SATURATE_DYNAMIC_DATA_TYPE = "Inherit: Same as second input";
    private static final String FINDINGS_MESSAGE_DATA_TYPE = "The output data type shall be set to ";
    private static final String FINDINGS_MESSAGE_UPPER_LIMIT = "The upper limit shall be lower than the maximum value of the output data type";
    private static final String FINDINGS_MESSAGE_LOWER_LIMIT = "The lower limit shall be higher than the minimum value of the output data type";
    private static final String RECOMMENDED_ACTION_DATA_TYPE = "Set output data type to ";
    private static final String RECOMMENDED_ACTION_UPPER_LIMIT = "Set the upper limit lower than ";
    private static final String RECOMMENDED_ACTION_LOWER_LIMIT = "Set the lower limit higher than ";
    private static final String FIRST_PORT = "1";
    private static final String SECOND_PORT = "2";
    private static final String THIRD_PORT = "3";
    private static final BigInteger INT8_MAX = BigInteger.TWO.pow(7).subtract(BigInteger.ONE);
    private static final BigInteger INT8_MIN = BigInteger.TWO.pow(7).negate();
    private static final BigInteger UINT8_MAX = BigInteger.TWO.pow(8).subtract(BigInteger.ONE);
    private static final BigInteger INT16_MAX = BigInteger.TWO.pow(15).subtract(BigInteger.ONE);
    private static final BigInteger INT16_MIN = BigInteger.TWO.pow(15).negate();
    private static final BigInteger UINT16_MAX = BigInteger.TWO.pow(16).subtract(BigInteger.ONE);
    private static final BigInteger INT32_MAX = BigInteger.TWO.pow(31).subtract(BigInteger.ONE);
    private static final BigInteger INT32_MIN = BigInteger.TWO.pow(31).negate();
    private static final BigInteger UINT32_MAX = BigInteger.TWO.pow(32).subtract(BigInteger.ONE);
    private static final BigInteger INT64_MAX = BigInteger.TWO.pow(63).subtract(BigInteger.ONE);
    private static final BigInteger INT64_MIN = BigInteger.TWO.pow(63).negate();
    private static final BigInteger UINT64_MAX = BigInteger.TWO.pow(64).subtract(BigInteger.ONE);
    private static final Map<String, DataTypeLimits> DATA_TYPE_MAPPING = new HashMap<String, DataTypeLimits>();
    private static final Map<String, BigInteger> DATA_TYPE_LIMIT_FUNCTIONS;

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkBlocks);
    }

    private void checkBlocks(SimulinkModel model) {
        this.checkSaturateBlocks(model);
        this.checkSaturationDynamicBlocks(model);
    }

    private void checkSaturateBlocks(SimulinkModel model) {
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Saturate"), (boolean)false, (boolean)false)) {
            this.checkBlock(block, SATURATE_DATA_TYPE, FIRST_PORT, type -> this.checkSaturateLimits(block, (DataTypeLimits)type));
        }
    }

    private void checkSaturationDynamicBlocks(SimulinkModel model) {
        List blocks = SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Reference", "Saturation Dynamic"), (boolean)false, (boolean)false);
        for (SimulinkBlock block : blocks) {
            if (!"Saturation Dynamic".equals(block.getSourceType())) continue;
            this.checkBlock(block, SATURATE_DYNAMIC_DATA_TYPE, SECOND_PORT, type -> this.checkSaturationDynamicLimits(block, (DataTypeLimits)type));
        }
    }

    private void checkBlock(SimulinkBlock block, String expectedDataType, String port, Consumer<DataTypeLimits> check) {
        this.checkDataType(block, expectedDataType, port);
        this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().map(type -> type.getResolvedOutputDataTypesForBlock(block, FIRST_PORT)).map(DATA_TYPE_MAPPING::get).ifPresent(check);
    }

    private void checkSaturateLimits(SimulinkBlock block, DataTypeLimits limits) {
        Optional.ofNullable(block.getParameter("LowerLimit")).ifPresent(lowerLimit -> this.checkLowerLimit(block, limits, (String)lowerLimit));
        Optional.ofNullable(block.getParameter("UpperLimit")).ifPresent(upperLimit -> this.checkUpperLimit(block, limits, (String)upperLimit));
    }

    private void checkSaturationDynamicLimits(SimulinkBlock block, DataTypeLimits limits) {
        SimulinkUsageOfSaturationBlocksCheck.resolveLimit(block.getInPort(FIRST_PORT)).ifPresent(limit -> this.checkUpperLimit(block, limits, (String)limit));
        SimulinkUsageOfSaturationBlocksCheck.resolveLimit(block.getInPort(THIRD_PORT)).ifPresent(limit -> this.checkLowerLimit(block, limits, (String)limit));
    }

    private static Optional<String> resolveLimit(SimulinkInPort inPort) {
        return Optional.ofNullable(inPort.getLine()).map(SimulinkLine::getSrcPort).map(SimulinkPortBase::getBlock).map(block -> block.getParameter("Value"));
    }

    private void checkLowerLimit(SimulinkBlock block, DataTypeLimits limits, String lowerLimit) {
        BigInteger resolvedLimit;
        if (DATA_TYPE_LIMIT_FUNCTIONS.containsKey(lowerLimit) && (resolvedLimit = DATA_TYPE_LIMIT_FUNCTIONS.get(lowerLimit)).compareTo(limits.min) <= 0) {
            String recommendedAction = RECOMMENDED_ACTION_LOWER_LIMIT + MarkupUtils.formatAsSourceCode((String)limits.min.toString());
            this.buildFinding(FINDINGS_MESSAGE_LOWER_LIMIT, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)recommendedAction)).createAndStore();
        }
    }

    private void checkUpperLimit(SimulinkBlock block, DataTypeLimits limits, String upperLimit) {
        BigInteger resolvedLimit;
        if (DATA_TYPE_LIMIT_FUNCTIONS.containsKey(upperLimit) && (resolvedLimit = DATA_TYPE_LIMIT_FUNCTIONS.get(upperLimit)).compareTo(limits.max) >= 0) {
            String recommendedAction = RECOMMENDED_ACTION_UPPER_LIMIT + MarkupUtils.formatAsSourceCode((String)limits.max.toString());
            this.buildFinding(FINDINGS_MESSAGE_UPPER_LIMIT, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)recommendedAction)).createAndStore();
        }
    }

    private void checkDataType(SimulinkBlock block, String expectedDataType, String port) {
        boolean dataTypeIsInherited;
        String dataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        boolean bl = dataTypeIsInherited = null == dataType || dataType.equals(expectedDataType);
        if (dataTypeIsInherited) {
            return;
        }
        Optional dataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile();
        Optional<String> outputDataType = dataTypes.map(type -> type.getResolvedOutputDataTypesForBlock(block, FIRST_PORT));
        Optional<String> inputDataType = dataTypes.map(type -> type.getInputDataType(block, port));
        if (inputDataType.isEmpty() || outputDataType.isEmpty()) {
            return;
        }
        if (inputDataType.get().equals("Unknown") || inputDataType.get().equals("NOT_CONNECTED") || outputDataType.get().equals("Unknown") || outputDataType.get().equals("NOT_CONNECTED")) {
            return;
        }
        if (inputDataType.equals(outputDataType)) {
            return;
        }
        String message = FINDINGS_MESSAGE_DATA_TYPE + MarkupUtils.formatAsSourceCode((String)expectedDataType);
        String recommendedActions = RECOMMENDED_ACTION_DATA_TYPE + MarkupUtils.formatAsSourceCode((String)SATURATE_DATA_TYPE);
        this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)recommendedActions)).createAndStore();
    }

    static {
        DATA_TYPE_MAPPING.put("int8", new DataTypeLimits("int8", INT8_MIN, INT8_MAX));
        DATA_TYPE_MAPPING.put("int16", new DataTypeLimits("int16", INT16_MIN, INT16_MAX));
        DATA_TYPE_MAPPING.put("int32", new DataTypeLimits("int32", INT32_MIN, INT32_MAX));
        DATA_TYPE_MAPPING.put("int64", new DataTypeLimits("int64", INT64_MIN, INT64_MAX));
        DATA_TYPE_MAPPING.put("uint8", new DataTypeLimits("uint8", BigInteger.ZERO, UINT8_MAX));
        DATA_TYPE_MAPPING.put("uint16", new DataTypeLimits("uint16", BigInteger.ZERO, UINT16_MAX));
        DATA_TYPE_MAPPING.put("uint32", new DataTypeLimits("uint32", BigInteger.ZERO, UINT32_MAX));
        DATA_TYPE_MAPPING.put("uint64", new DataTypeLimits("uint64", BigInteger.ZERO, UINT64_MAX));
        DATA_TYPE_LIMIT_FUNCTIONS = new HashMap<String, BigInteger>();
        for (DataTypeLimits type : DATA_TYPE_MAPPING.values()) {
            DATA_TYPE_LIMIT_FUNCTIONS.put("intmax('" + type.name + "')", type.max);
            DATA_TYPE_LIMIT_FUNCTIONS.put("intmin('" + type.name + "')", type.min);
        }
    }

    private static final class DataTypeLimits {
        private final String name;
        private final BigInteger min;
        private final BigInteger max;

        private DataTypeLimits(String name, BigInteger min, BigInteger max) {
            this.name = name;
            this.min = min;
            this.max = max;
        }
    }
}

