/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0702", languages={ELanguage.SIMULINK})
public class SimulinkNumericLiteralsInStateflowCheck
extends CheckImplementationBase {
    private static final String FORBIDDEN_LITERALS_FINDING_PROPERTY_NAME = "Forbidden literals";
    @CheckOption(name="Allowed numeric literals in Stateflow charts", description="Allow certain numeric literals in Stateflow charts, e.g. in transition conditions. Separate by commas. If the list contains, for example, 42 then the check ignores the literals 42 and -42.")
    private Set<String> allowedNumericLiterals = Set.of("0", "1", "0.0");
    @CheckOption(name="Allow numeric literals in parentheses or braces", description="Allow use of numeric literals in Stateflow charts in parentheses or braces, e.g. vector indices.")
    private boolean allowParentheses = false;
    private static final String RECOMMENDED_ACTION = "Use constants or named parameters instead of numerical literals.";
    private static final String FINDING_MESSAGE_LITERALS_TRANSITION = "Usage of numerical literals in Stateflow Transition ({0})";
    private static final String FINDING_MESSAGE_LITERALS_NODE = "Usage of numerical literals in Stateflow Node ({0})";
    private static final Set<ETokenType> NUMERIC_LITERALS = EnumSet.of(ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.IMAGINARY_LITERAL);

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            this.checkBlock((StateflowBlock)block);
        }
    }

    private void checkBlock(StateflowBlock block) {
        StateflowChart chart = block.getChart();
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            this.checkNodeLabel(node);
            for (StateflowTransition transition : node.getInTransitions()) {
                this.checkTransitionLabel(transition);
            }
        }
    }

    private void checkTransitionLabel(StateflowTransition transition) {
        StateflowTransitionParts parts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
        String forbiddenLiterals = this.extractForbiddenLiteralsFromTransitionParts(parts);
        if (!forbiddenLiterals.isEmpty()) {
            FindingPropertyList properties = new FindingPropertyList();
            properties.addProperty("Recommended Action", (Object)RECOMMENDED_ACTION);
            properties.addProperty(FORBIDDEN_LITERALS_FINDING_PROPERTY_NAME, (Object)forbiddenLiterals);
            this.context.buildFinding(MessageFormat.format(FINDING_MESSAGE_LITERALS_TRANSITION, forbiddenLiterals), (ElementLocation)this.context.buildLocation().forStateflowTransition(transition)).addFindingProperties(properties).createAndStore();
        }
    }

    private String extractForbiddenLiteralsFromTransitionParts(StateflowTransitionParts parts) {
        ArrayList<String> forbiddenNumericLiterals = new ArrayList<String>();
        forbiddenNumericLiterals.addAll(this.filterForbiddenNumericLiterals(parts.condition));
        forbiddenNumericLiterals.addAll(this.filterForbiddenNumericLiterals(parts.conditionAction));
        forbiddenNumericLiterals.addAll(this.filterForbiddenNumericLiterals(parts.transitionAction));
        return StringUtils.concat(forbiddenNumericLiterals, (String)", ");
    }

    private void checkNodeLabel(StateflowNodeBase node) {
        if (!(node instanceof StateflowState)) {
            return;
        }
        List stateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)((StateflowState)node));
        String forbiddenLiterals = this.extractForbiddenLiteralsFromStateActions(stateActions);
        if (!forbiddenLiterals.isEmpty()) {
            FindingPropertyList properties = new FindingPropertyList();
            properties.addProperty("Recommended Action", (Object)RECOMMENDED_ACTION);
            properties.addProperty(FORBIDDEN_LITERALS_FINDING_PROPERTY_NAME, (Object)forbiddenLiterals);
            this.context.buildFinding(MessageFormat.format(FINDING_MESSAGE_LITERALS_NODE, forbiddenLiterals), (ElementLocation)this.context.buildLocation().forStateflowNode(node)).addFindingProperties(properties).createAndStore();
        }
    }

    private String extractForbiddenLiteralsFromStateActions(List<StateflowStateAction> stateActions) {
        ArrayList<String> forbiddenNumericLiterals = new ArrayList<String>();
        for (StateflowStateAction stateAction : stateActions) {
            forbiddenNumericLiterals.addAll(this.filterForbiddenNumericLiterals(stateAction.actionCode));
        }
        return StringUtils.concat(forbiddenNumericLiterals, (String)", ");
    }

    private List<String> filterForbiddenNumericLiterals(List<IToken> tokens) {
        if (CollectionUtils.isNullOrEmpty(tokens)) {
            return Collections.emptyList();
        }
        ArrayList<String> forbiddenNumericLiterals = new ArrayList<String>();
        if (this.allowParentheses) {
            for (ETokenType numericLiteral : NUMERIC_LITERALS) {
                TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.LPAREN, numericLiteral, ETokenType.RPAREN});
                TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACE, numericLiteral, ETokenType.RBRACE});
            }
        }
        for (IToken token : tokens) {
            String numberText;
            if (!NUMERIC_LITERALS.contains(token.getType()) || this.allowedNumericLiterals.contains(numberText = token.getText().strip())) continue;
            forbiddenNumericLiterals.add(numberText);
        }
        return forbiddenNumericLiterals;
    }
}

