/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.LinkedList;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0763", languages={ELanguage.SIMULINK})
public class SimulinkStateflowMultipleInternalTransitionsCheck
extends CheckImplementationBase {
    @CheckOption(name="Allow multiple internal Transitions", description="If not checked, only one internal transition in a Stateflow state is allowed (MAAB rule jc_0763_a1). If checked, multiple internal transitions are allowed but only in sorted order (MAAB rule jc_0763_a2).")
    private boolean multipleTransitionsAllowed = false;
    private static final String FINDING_MESSAGE_A1 = "Multiple internal transitions in a Stateflow state";
    private static final String FINDING_MESSAGE_A2 = "Incorrect order of internal transition in a Stateflow state";
    private static final FindingPropertyList RECOMMENDED_ACTION_A1 = FindingPropertyList.singleton((String)"Recommended Action", (String)"Only use one internal transition per state (jc_0763_a1).");
    private static final FindingPropertyList RECOMMENDED_ACTION_A2 = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use internal transition in correct order (jc_0763_a2).");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        StateflowMachine machine = model.getStateflowMachine();
        if (machine == null) {
            return;
        }
        machine.getCharts(false).forEach(this::checkInternalTransitions);
    }

    private void checkInternalTransitions(StateflowChart chart) {
        for (StateflowNodeBase node : chart.getNodes()) {
            if (!(node instanceof StateflowState) || StateflowUtils.isCommented((ParameterizedElement)node)) continue;
            this.checkState((StateflowState)node);
            ((StateflowState)node).getCharts().forEach(this::checkInternalTransitions);
        }
    }

    private void checkState(StateflowState state) {
        String stateId = state.getStateflowId();
        LinkedList<StateflowTransition> internalInputTransitions = new LinkedList<StateflowTransition>();
        for (StateflowNodeBase node : state.getNodes()) {
            node.getInTransitions().stream().filter(transition -> !StateflowUtils.isCommented((ParameterizedElement)transition) && stateId.equals(transition.getParameter("src.id"))).forEach(internalInputTransitions::add);
        }
        if (internalInputTransitions.size() < 2) {
            return;
        }
        if (!this.multipleTransitionsAllowed) {
            this.buildFinding(FINDING_MESSAGE_A1, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION_A1).createAndStore();
        } else if (!SimulinkStateflowMultipleInternalTransitionsCheck.isInSortedOrder(internalInputTransitions)) {
            this.buildFinding(FINDING_MESSAGE_A2, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION_A2).createAndStore();
        }
    }

    private static boolean isInSortedOrder(List<StateflowTransition> transitions) {
        transitions.sort(SimulinkStateflowMultipleInternalTransitionsCheck::compareYCoordinates);
        int previousExecutionOrder = 0;
        double previousY = 2.147483647E9;
        for (StateflowTransition transition : transitions) {
            String executionOrder = transition.getDeclaredParameter("executionOrder");
            if (executionOrder == null) continue;
            int currentExecutionOrder = Integer.parseInt(executionOrder);
            double currentY = SimulinkStateflowMultipleInternalTransitionsCheck.getYCoordinate(transition);
            if (currentY != previousY && previousExecutionOrder >= currentExecutionOrder) {
                return false;
            }
            if (currentExecutionOrder > previousExecutionOrder) {
                previousExecutionOrder = currentExecutionOrder;
            }
            previousY = currentY;
        }
        return true;
    }

    private static int compareYCoordinates(StateflowTransition a, StateflowTransition b) {
        double yA = SimulinkStateflowMultipleInternalTransitionsCheck.getYCoordinate(a);
        double yB = SimulinkStateflowMultipleInternalTransitionsCheck.getYCoordinate(b);
        if (yA == -1.0 || yB == -1.0) {
            return Integer.MAX_VALUE;
        }
        return Double.compare(yA, yB);
    }

    private static double getYCoordinate(StateflowTransition transition) {
        String srcIntersection = transition.getParameter("src_intersection");
        if (srcIntersection == null) {
            return -1.0;
        }
        double[] intersection = SimulinkUtils.getDoubleParameterArray((String)srcIntersection);
        if (intersection.length < 6) {
            return -1.0;
        }
        return intersection[5];
    }
}

