/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.sql_like.SqlLikeCustomCheckUtils;
import java.util.Collections;
import java.util.List;

@Check(id="cqse-no-select-star", languages={ELanguage.PLSQL, ELanguage.ESQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoSelectStarCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List<ShallowEntity> selectedEntities = SqlLikeCustomCheckUtils.selectStatementsOrCursorsPerformingSelect(this.context.getRootEntity(this.getCodeViewOption()));
        for (ShallowEntity entity : selectedEntities) {
            this.processEntity(entity);
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singletonList(this.context.getRootEntity(this.getCodeViewOption())), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!statement.getSubtype().equals("select")) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        List<IToken> tokens = SqlLikeCustomCheckUtils.extractSelect(entity);
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.SELECT, ETokenType.MULT})) {
            this.buildFinding("Usage of `SELECT * FROM xxx` should be avoided", this.buildLocation().forToken(tokens.get(1))).createAndStore();
        }
    }
}

