/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.alm.ws.client.internal;

import com.polarion.alm.ws.client.internal.ClientSessionHandlerInfo;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;

public class ClientSessionHandler
implements Handler {
    private static final String SESSION_NS = "http://ws.polarion.com/session";
    private static final String SESSION_LOCALPART = "sessionID";
    private ClientSessionHandlerInfo info;

    public void destroy() {
    }

    public QName[] getHeaders() {
        return null;
    }

    public boolean handleFault(MessageContext arg0) {
        return false;
    }

    public boolean handleRequest(MessageContext arg0) {
        Long currentClientSession = this.info.getSessionId();
        if (currentClientSession == null) {
            return true;
        }
        Message msg = ((org.apache.axis.MessageContext)arg0).getRequestMessage();
        if (msg == null) {
            return false;
        }
        try {
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeaderElement header = new SOAPHeaderElement(SESSION_NS, SESSION_LOCALPART, (Object)currentClientSession);
            env.addHeader(header);
            if (this.info.getSessionCookie() != null && !this.info.getSessionCookie().isEmpty()) {
                arg0.setProperty("Cookie", (Object)this.info.getSessionCookie());
            }
        }
        catch (AxisFault e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean handleResponse(MessageContext arg0) {
        Message msg = ((org.apache.axis.MessageContext)arg0).getResponseMessage();
        if (msg == null) {
            return false;
        }
        try {
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeaderElement header = env.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (header == null) {
                return false;
            }
            this.info.setSessionId((Long)header.getValueAsType(Constants.XSD_LONG));
            header.setProcessed(true);
            if (arg0.getProperty("Cookie") != null) {
                this.info.setSessionCookie((String)arg0.getProperty("Cookie"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void init(HandlerInfo arg0) {
        this.info = (ClientSessionHandlerInfo)arg0;
    }
}

